@extends('layouts.app')

@section('title', 'Mutasi Penduduk')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Mutasi Penduduk</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-exchange-alt me-2 text-primary"></i>
            Mutasi Penduduk
        </h2>
        <p class="text-muted mb-0">Kelola data perubahan kependudukan seperti kelahiran, kematian, dan perpindahan</p>
    </div>
    <div>
        <a href="{{ route('admin.mutasi-penduduk.statistik') }}" class="btn btn-gradient-success me-2">
            <i class="fas fa-chart-line me-2"></i>
            Statistik
        </a>
        <a href="{{ route('admin.mutasi-penduduk.create') }}" class="btn btn-gradient-primary">
            <i class="fas fa-plus-circle me-2"></i>
            Tambah Mutasi
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-primary me-3">
                    <i class="fas fa-exchange-alt"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($statistik['total']) }}</h4>
                    <small class="text-muted">Total Mutasi</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-calendar-month"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($statistik['bulan_ini']) }}</h4>
                    <small class="text-muted">Bulan Ini</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-baby"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($statistik['by_jenis']['Lahir'] ?? 0) }}</h4>
                    <small class="text-muted">Kelahiran</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-6">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-secondary me-3">
                    <i class="fas fa-cross"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($statistik['by_jenis']['Meninggal'] ?? 0) }}</h4>
                    <small class="text-muted">Meninggal</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Additional Statistics Row -->
<div class="row mb-4">
    <div class="col-lg-4 col-md-6">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-arrow-right"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($statistik['by_jenis']['Pindah Masuk'] ?? 0) }}</h4>
                    <small class="text-muted">Pindah Masuk</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-warning me-3">
                    <i class="fas fa-arrow-left"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($statistik['by_jenis']['Pindah Keluar'] ?? 0) }}</h4>
                    <small class="text-muted">Pindah Keluar</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-secondary me-3">
                    <i class="fas fa-edit"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($statistik['by_jenis']['Status Update'] ?? 0) }}</h4>
                    <small class="text-muted">Update Status</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.mutasi-penduduk.index') }}">
            <div class="row g-3">
                <div class="col-lg-3 col-md-6">
                    <label class="form-label">Jenis Mutasi</label>
                    <select name="jenis_mutasi" class="form-select">
                        <option value="">Semua Jenis Mutasi</option>
                        <option value="Lahir" {{ request('jenis_mutasi') == 'Lahir' ? 'selected' : '' }}>Lahir</option>
                        <option value="Meninggal" {{ request('jenis_mutasi') == 'Meninggal' ? 'selected' : '' }}>Meninggal</option>
                        <option value="Pindah Masuk" {{ request('jenis_mutasi') == 'Pindah Masuk' ? 'selected' : '' }}>Pindah Masuk</option>
                        <option value="Pindah Keluar" {{ request('jenis_mutasi') == 'Pindah Keluar' ? 'selected' : '' }}>Pindah Keluar</option>
                        <option value="Status Update" {{ request('jenis_mutasi') == 'Status Update' ? 'selected' : '' }}>Status Update</option>
                    </select>
                </div>
                <div class="col-lg-2 col-md-6">
                    <label class="form-label">Tahun</label>
                    <select name="tahun" class="form-select">
                        <option value="">Semua Tahun</option>
                        @for($i = date('Y'); $i >= date('Y') - 10; $i--)
                            <option value="{{ $i }}" {{ request('tahun') == $i ? 'selected' : '' }}>{{ $i }}</option>
                        @endfor
                    </select>
                </div>
                <div class="col-lg-2 col-md-6">
                    <label class="form-label">Bulan</label>
                    <select name="bulan" class="form-select">
                        <option value="">Semua Bulan</option>
                        @for($i = 1; $i <= 12; $i++)
                            <option value="{{ $i }}" {{ request('bulan') == $i ? 'selected' : '' }}>
                                {{ DateTime::createFromFormat('!m', $i)->format('F') }}
                            </option>
                        @endfor
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label">Pencarian</label>
                    <input type="text" name="search" class="form-control" placeholder="Cari NIK atau Nama..." value="{{ request('search') }}">
                </div>
                <div class="col-lg-2 col-md-6">
                    <label class="form-label">&nbsp;</label>
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary flex-fill">
                            <i class="fas fa-search me-1"></i> Filter
                        </button>
                        <a href="{{ route('admin.mutasi-penduduk.index') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-refresh"></i>
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card">
    <div class="card-header bg-light">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">
                <i class="fas fa-table me-2"></i>
                Daftar Mutasi Penduduk
            </h5>
            <div class="btn-group">
                <button type="button" class="btn btn-outline-success dropdown-toggle btn-sm" data-bs-toggle="dropdown">
                    <i class="fas fa-download me-1"></i> Export
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#" onclick="exportData('pdf')">
                        <i class="fas fa-file-pdf me-2"></i>PDF
                    </a></li>
                    <li><a class="dropdown-item" href="#" onclick="exportData('excel')">
                        <i class="fas fa-file-excel me-2"></i>Excel
                    </a></li>
                    <li><a class="dropdown-item" href="#" onclick="exportData('csv')">
                        <i class="fas fa-file-csv me-2"></i>CSV
                    </a></li>
                </ul>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-striped">
                <thead class="table-light">
                    <tr>
                        <th width="5%" class="text-center">No</th>
                        <th width="15%">NIK</th>
                        <th width="20%">Nama</th>
                        <th width="15%" class="text-center">Jenis Mutasi</th>
                        <th width="12%" class="text-center">Tanggal</th>
                        <th width="20%">Keterangan</th>
                        <th width="10%">Admin</th>
                        <th width="8%" class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($mutasi as $index => $item)
                    <tr>
                        <td class="text-center">{{ $mutasi->firstItem() + $index }}</td>
                        <td class="text-monospace">{{ $item->nik }}</td>
                        <td>
                            <div class="fw-semibold">{{ $item->penduduk->nama ?? 'Data tidak ditemukan' }}</div>
                            @if($item->penduduk)
                            <small class="text-muted">{{ $item->penduduk->jenis_kelamin }}</small>
                            @endif
                        </td>
                        <td class="text-center">
                            @php
                                $badgeClass = [
                                    'Lahir' => 'bg-success',
                                    'Meninggal' => 'bg-secondary',
                                    'Pindah Masuk' => 'bg-info',
                                    'Pindah Keluar' => 'bg-warning',
                                    'Status Update' => 'bg-primary'
                                ];
                            @endphp
                            <span class="badge {{ $badgeClass[$item->jenis_mutasi] ?? 'bg-secondary' }}">
                                {{ $item->jenis_mutasi }}
                            </span>
                        </td>
                        <td class="text-center">
                            <div class="fw-semibold">{{ \Carbon\Carbon::parse($item->tanggal_mutasi)->format('d/m/Y') }}</div>
                            <small class="text-muted">{{ \Carbon\Carbon::parse($item->tanggal_mutasi)->format('H:i') }}</small>
                        </td>
                        <td>
                            @if($item->keterangan)
                                <span title="{{ $item->keterangan }}">{{ Str::limit($item->keterangan, 40) }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <small class="text-muted">{{ $item->admin_user }}</small>
                        </td>
                        <td class="text-center">
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.mutasi-penduduk.show', $item->id) }}" 
                                   class="btn btn-soft-primary btn-sm" title="Detail" data-bs-toggle="tooltip">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.mutasi-penduduk.edit', $item->id) }}" 
                                   class="btn btn-soft-info btn-sm" title="Edit" data-bs-toggle="tooltip">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" 
                                        class="btn btn-soft-danger btn-sm" 
                                        title="Hapus"
                                        data-bs-toggle="tooltip"
                                        onclick="deleteItem({{ $item->id }})">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <div class="text-muted">
                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                <div>Tidak ada data mutasi penduduk</div>
                                <small>Silakan tambah data mutasi baru</small>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($mutasi->hasPages())
        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-4">
            <div class="text-muted">
                Menampilkan {{ $mutasi->firstItem() ?? 0 }} sampai {{ $mutasi->lastItem() ?? 0 }} 
                dari {{ $mutasi->total() }} entri
            </div>
            <div>
                {{ $mutasi->appends(request()->query())->links() }}
            </div>
        </div>
        @endif
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-exclamation-triangle text-warning me-2"></i>
                    Konfirmasi Hapus
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="text-center">
                    <i class="fas fa-trash-alt fa-3x text-danger mb-3"></i>
                    <p class="mb-0">Apakah Anda yakin ingin menghapus data mutasi ini?</p>
                    <small class="text-muted">Tindakan ini tidak dapat dibatalkan</small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Batal
                </button>
                <form id="deleteForm" method="POST" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash me-1"></i> Hapus
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Initialize tooltips
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});

function deleteItem(id) {
    const deleteForm = document.getElementById('deleteForm');
    deleteForm.action = '{{ route("admin.mutasi-penduduk.index") }}/' + id;
    
    const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    deleteModal.show();
}

function exportData(format) {
    const params = new URLSearchParams(window.location.search);
    params.set('export', format);
    window.location.href = '{{ route("admin.mutasi-penduduk.index") }}?' + params.toString();
}
</script>
@endpush
@endsection