@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.mutasi-penduduk.index') }}">Mutasi Penduduk</a></li>
                        <li class="breadcrumb-item active">Detail Mutasi</li>
                    </ol>
                </div>
                <h4 class="page-title">Detail Mutasi Penduduk</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <h4 class="header-title">Informasi Mutasi</h4>
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end">
                                <a href="{{ route('admin.mutasi-penduduk.edit', $mutasiPenduduk->id) }}" class="btn btn-warning me-1">
                                    <i class="mdi mdi-pencil me-1"></i> Edit
                                </a>
                                <a href="{{ route('admin.mutasi-penduduk.index') }}" class="btn btn-secondary">
                                    <i class="mdi mdi-arrow-left me-1"></i> Kembali
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-8">
                            <!-- Informasi Penduduk -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Data Penduduk</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-2">
                                                <strong>NIK:</strong><br>
                                                {{ $mutasiPenduduk->nik }}
                                            </div>
                                            <div class="mb-2">
                                                <strong>Nama:</strong><br>
                                                {{ $mutasiPenduduk->penduduk->nama ?? 'Data tidak ditemukan' }}
                                            </div>
                                            @if($mutasiPenduduk->penduduk)
                                            <div class="mb-2">
                                                <strong>Jenis Kelamin:</strong><br>
                                                {{ $mutasiPenduduk->penduduk->jenis_kelamin }}
                                            </div>
                                            @endif
                                        </div>
                                        <div class="col-md-6">
                                            @if($mutasiPenduduk->penduduk)
                                            <div class="mb-2">
                                                <strong>Tempat, Tanggal Lahir:</strong><br>
                                                {{ $mutasiPenduduk->penduduk->tempat_lahir }}, 
                                                {{ \Carbon\Carbon::parse($mutasiPenduduk->penduduk->tanggal_lahir)->format('d F Y') }}
                                            </div>
                                            <div class="mb-2">
                                                <strong>Status Hidup:</strong><br>
                                                <span class="badge {{ $mutasiPenduduk->penduduk->status_hidup == 'Hidup' ? 'bg-success' : 'bg-danger' }}">
                                                    {{ $mutasiPenduduk->penduduk->status_hidup }}
                                                </span>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Informasi Mutasi -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Detail Mutasi</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <strong>Jenis Mutasi:</strong><br>
                                                @php
                                                    $badgeClass = [
                                                        'Lahir' => 'bg-success',
                                                        'Meninggal' => 'bg-danger',
                                                        'Pindah Masuk' => 'bg-primary',
                                                        'Pindah Keluar' => 'bg-warning',
                                                        'Status Update' => 'bg-info'
                                                    ];
                                                @endphp
                                                <span class="badge {{ $badgeClass[$mutasiPenduduk->jenis_mutasi] ?? 'bg-secondary' }}">
                                                    {{ $mutasiPenduduk->jenis_mutasi }}
                                                </span>
                                            </div>
                                            <div class="mb-3">
                                                <strong>Tanggal Mutasi:</strong><br>
                                                {{ \Carbon\Carbon::parse($mutasiPenduduk->tanggal_mutasi)->format('d F Y') }}
                                            </div>
                                            @if($mutasiPenduduk->no_surat_keterangan)
                                            <div class="mb-3">
                                                <strong>No. Surat Keterangan:</strong><br>
                                                {{ $mutasiPenduduk->no_surat_keterangan }}
                                            </div>
                                            @endif
                                        </div>
                                        <div class="col-md-6">
                                            @if($mutasiPenduduk->asal_daerah || $mutasiPenduduk->tujuan_daerah)
                                            <div class="mb-3">
                                                @if($mutasiPenduduk->asal_daerah)
                                                <strong>Asal Daerah:</strong><br>
                                                {{ $mutasiPenduduk->asal_daerah }}
                                                @endif
                                                @if($mutasiPenduduk->tujuan_daerah)
                                                <br><strong>Tujuan Daerah:</strong><br>
                                                {{ $mutasiPenduduk->tujuan_daerah }}
                                                @endif
                                            </div>
                                            @endif

                                            @if($mutasiPenduduk->sebab_meninggal || $mutasiPenduduk->tempat_meninggal)
                                            <div class="mb-3">
                                                @if($mutasiPenduduk->sebab_meninggal)
                                                <strong>Sebab Meninggal:</strong><br>
                                                {{ $mutasiPenduduk->sebab_meninggal }}
                                                @endif
                                                @if($mutasiPenduduk->tempat_meninggal)
                                                <br><strong>Tempat Meninggal:</strong><br>
                                                {{ $mutasiPenduduk->tempat_meninggal }}
                                                @endif
                                            </div>
                                            @endif
                                        </div>
                                    </div>

                                    @if($mutasiPenduduk->keterangan)
                                    <div class="mb-3">
                                        <strong>Keterangan:</strong><br>
                                        <div class="border rounded p-2 bg-light">
                                            {{ $mutasiPenduduk->keterangan }}
                                        </div>
                                    </div>
                                    @endif

                                    @if($mutasiPenduduk->catatan_admin)
                                    <div class="mb-3">
                                        <strong>Catatan Admin:</strong><br>
                                        <div class="border rounded p-2 bg-warning-light">
                                            {{ $mutasiPenduduk->catatan_admin }}
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <!-- Informasi Sistem -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Informasi Sistem</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>Dicatat Oleh:</strong><br>
                                        {{ $mutasiPenduduk->admin_user }}
                                    </div>
                                    <div class="mb-3">
                                        <strong>Tanggal Pencatatan:</strong><br>
                                        {{ $mutasiPenduduk->created_at->format('d F Y H:i') }} WIB
                                    </div>
                                    @if($mutasiPenduduk->updated_at != $mutasiPenduduk->created_at)
                                    <div class="mb-3">
                                        <strong>Terakhir Diubah:</strong><br>
                                        {{ $mutasiPenduduk->updated_at->format('d F Y H:i') }} WIB
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Data Lama (jika ada) -->
                            @if($mutasiPenduduk->data_lama)
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Data Sebelum Mutasi</h5>
                                </div>
                                <div class="card-body">
                                    <div class="accordion" id="dataLamaAccordion">
                                        <div class="accordion-item">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button collapsed" type="button" 
                                                        data-bs-toggle="collapse" data-bs-target="#dataLamaContent">
                                                    Lihat Data Backup
                                                </button>
                                            </h2>
                                            <div id="dataLamaContent" class="accordion-collapse collapse" 
                                                 data-bs-parent="#dataLamaAccordion">
                                                <div class="accordion-body">
                                                    <small class="text-muted">
                                                        @php
                                                            $dataLama = json_decode($mutasiPenduduk->data_lama, true);
                                                        @endphp
                                                        @if(is_array($dataLama))
                                                            @foreach(['nama', 'status_hidup', 'alamat', 'rt', 'rw'] as $field)
                                                                @if(isset($dataLama[$field]))
                                                                    <strong>{{ ucfirst(str_replace('_', ' ', $field)) }}:</strong> 
                                                                    {{ $dataLama[$field] }}<br>
                                                                @endif
                                                            @endforeach
                                                        @else
                                                            {{ $mutasiPenduduk->data_lama }}
                                                        @endif
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 