@extends('layouts.app')

@section('title', 'Kelola Objek Wisata')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Kelola Objek Wisata</h1>
        <a href="{{ route('admin.objek-wisata.create') }}" class="btn btn-primary btn-icon-split">
            <span class="icon text-white-50">
                <i class="fas fa-plus"></i>
            </span>
            <span class="text">Tambah Objek Wisata</span>
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Objek Wisata</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-map-marked-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['aktif'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Menunggu Verifikasi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['pending'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Kunjungan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($stats['total_kunjungan'] ?? 0) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Search -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.objek-wisata.index') }}">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control" id="search" name="search" 
                                   value="{{ request('search') }}" placeholder="Nama objek wisata...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="aktif" {{ request('status') === 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="nonaktif" {{ request('status') === 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" id="kategori" name="kategori">
                                <option value="">Semua Kategori</option>
                                <option value="alam" {{ request('kategori') === 'alam' ? 'selected' : '' }}>Alam</option>
                                <option value="budaya" {{ request('kategori') === 'budaya' ? 'selected' : '' }}>Budaya</option>
                                <option value="religi" {{ request('kategori') === 'religi' ? 'selected' : '' }}>Religi</option>
                                <option value="sejarah" {{ request('kategori') === 'sejarah' ? 'selected' : '' }}>Sejarah</option>
                                <option value="kuliner" {{ request('kategori') === 'kuliner' ? 'selected' : '' }}>Kuliner</option>
                                <option value="adventure" {{ request('kategori') === 'adventure' ? 'selected' : '' }}>Adventure</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="submit" class="btn btn-primary btn-sm mr-2">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="{{ route('admin.objek-wisata.index') }}" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-undo"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Objek Wisata</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="15%">Foto</th>
                            <th width="20%">Nama</th>
                            <th width="15%">Kategori</th>
                            <th width="15%">Harga Tiket</th>
                            <th width="10%">Status</th>
                            <th width="10%">Rating</th>
                            <th width="10%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($objekWisata as $index => $wisata)
                        <tr>
                            <td>{{ $objekWisata->firstItem() + $index }}</td>
                            <td>
                                @if($wisata->foto_utama && is_string($wisata->foto_utama))
                                    <img src="{{ $wisata->foto_utama_url }}" 
                                         alt="{{ $wisata->nama_wisata }}" 
                                         class="img-thumbnail" 
                                         style="width: 80px; height: 60px; object-fit: cover;"
                                         onerror="this.style.display='none';">
                                @else
                                @endif
                            </td>
                            <td>
                                <div class="font-weight-bold">{{ $wisata->nama_wisata }}</div>
                                <small class="text-muted">{{ Str::limit($wisata->alamat ?? '-', 50) }}</small>
                            </td>
                            <td>
                                @php
                                    $kategori = $wisata->kategori_wisata ?? '';
                                @endphp
                                @if($kategori === 'lainnya')
                                    <span class="badge badge-light" style="color: black; border: 1px solid #ddd;">{{ ucfirst(str_replace('_', ' ', $kategori)) }}</span>
                                @else
                                    <span class="badge badge-info">{{ ucfirst(str_replace('_', ' ', $kategori)) }}</span>
                                @endif
                            </td>
                            <td>
                                @if(($wisata->harga_tiket_dewasa ?? 0) > 0)
                                    <div><strong>Dewasa:</strong> Rp {{ number_format($wisata->harga_tiket_dewasa) }}</div>
                                    @if(($wisata->harga_tiket_anak ?? 0) > 0)
                                        <div><strong>Anak:</strong> Rp {{ number_format($wisata->harga_tiket_anak) }}</div>
                                    @endif
                                @else
                                    <span class="text-success font-weight-bold">GRATIS</span>
                                @endif
                            </td>
                            <td>
                                @if($wisata->status === 'aktif')
                                    <span class="badge badge-success">Aktif</span>
                                @elseif($wisata->status === 'pending')
                                    <span class="badge badge-warning">Pending</span>
                                @else
                                    <span class="badge badge-secondary">Non-aktif</span>
                                @endif
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-star text-warning mr-1"></i>
                                    <span class="font-weight-bold">{{ number_format($wisata->rating_rata_rata ?? 0, 1) }}</span>
                                    <small class="text-muted ml-1">({{ $wisata->jumlah_review ?? 0 }})</small>
                                </div>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.objek-wisata.show', $wisata->id) }}" 
                                       class="btn btn-info btn-sm" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.objek-wisata.edit', $wisata->id) }}" 
                                       class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @if($wisata->status === 'pending')
                                        <form action="{{ route('admin.objek-wisata.approve', $wisata->id) }}" 
                                              method="POST" class="d-inline">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="btn btn-success btn-sm" 
                                                    title="Setujui" 
                                                    onclick="return confirm('Setujui objek wisata ini?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    @endif
                                    <button type="button" class="btn btn-danger btn-sm" 
                                            onclick="deleteWisata({{ $wisata->id }})" 
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="fas fa-search fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Tidak ada data objek wisata</h5>
                                <p class="text-muted">Silakan tambah objek wisata baru atau ubah filter pencarian</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($objekWisata->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Menampilkan {{ $objekWisata->firstItem() }} - {{ $objekWisata->lastItem() }} 
                        dari {{ $objekWisata->total() }} data
                    </div>
                    {{ $objekWisata->appends(request()->query())->links() }}
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus objek wisata ini?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteWisata(id) {
    $('#deleteForm').attr('action', `/admin/objek-wisata/${id}`);
    $('#deleteModal').modal('show');
}

// Auto-hide alerts
setTimeout(function() {
    $('.alert').fadeOut('slow');
}, 5000);
</script>
@endpush 
