@extends('layouts.app')

@section('title', 'Pengaduan & Aspirasi')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Pengaduan & Aspirasi</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-comments me-2 text-primary"></i>
            Pengaduan & Aspirasi
        </h2>
        <p class="text-muted mb-0">Kelola pengaduan dan aspirasi dari warga</p>
    </div>
    <div>
        <button type="button" class="btn btn-gradient-success me-2" data-bs-toggle="modal" data-bs-target="#addPengaduanModal">
            <i class="fas fa-plus me-2"></i>
            Tambah Pengaduan
        </button>
        <button type="button" class="btn btn-gradient-info" onclick="exportPengaduan()">
            <i class="fas fa-download me-2"></i>
            Export Data
        </button>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-primary me-3">
                    <i class="fas fa-comments"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['total'] ?? 0 }}</h4>
                    <small class="text-muted">Total Pengaduan</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-warning me-3">
                    <i class="fas fa-clock"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['baru'] ?? 0 }}</h4>
                    <small class="text-muted">Baru</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-cog"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['diproses'] ?? 0 }}</h4>
                    <small class="text-muted">Diproses</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-check"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['selesai'] ?? 0 }}</h4>
                    <small class="text-muted">Selesai</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" id="filterStatus">
                            <option value="">Semua Status</option>
                            <option value="baru">Baru</option>
                            <option value="diproses">Diproses</option>
                            <option value="selesai">Selesai</option>
                            <option value="ditolak">Ditolak</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Kategori</label>
                        <select class="form-select" id="filterKategori">
                            <option value="">Semua Kategori</option>
                            <option value="infrastruktur">Infrastruktur</option>
                            <option value="layanan">Layanan Publik</option>
                            <option value="keamanan">Keamanan</option>
                            <option value="lingkungan">Lingkungan</option>
                            <option value="sosial">Sosial</option>
                            <option value="lainnya">Lainnya</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Tanggal</label>
                        <input type="date" class="form-control" id="filterTanggal">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="button" class="btn btn-primary" onclick="applyFilters()">
                                <i class="fas fa-filter me-2"></i>Filter
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-end">
                <button type="button" class="btn btn-outline-secondary" onclick="resetFilters()">
                    <i class="fas fa-refresh me-2"></i>Reset
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Main Content -->
<div class="row">
    <!-- Pengaduan List -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    Daftar Pengaduan
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="pengaduan-list">
                    @forelse($pengaduan as $p)
                    <div class="pengaduan-item border-bottom p-3" data-id="{{ $p->id }}">
                        <div class="d-flex">
                            <div class="flex-shrink-0">
                                <div class="avatar bg-{{ $p->status_color }} text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 45px; height: 45px;">
                                    <i class="fas fa-{{ $p->kategori_icon }}"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6 class="mb-1">{{ $p->judul }}</h6>
                                        <p class="mb-2 text-muted small">
                                            {{ Str::limit($p->deskripsi, 100) }}
                                        </p>
                                        <div class="d-flex align-items-center gap-3">
                                            <span class="badge bg-{{ $p->status_color }}">{{ ucfirst($p->status) }}</span>
                                            <span class="badge bg-secondary">{{ ucfirst($p->kategori) }}</span>
                                            <small class="text-muted">
                                                <i class="fas fa-user me-1"></i>
                                                {{ $p->penduduk->nama ?? 'Anonim' }}
                                            </small>
                                            <small class="text-muted">
                                                <i class="fas fa-calendar me-1"></i>
                                                {{ $p->created_at->format('d/m/Y H:i') }}
                                            </small>
                                        </div>
                                    </div>
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" class="btn btn-outline-info" 
                                                onclick="viewDetail({{ $p->id }})" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-success" 
                                                onclick="respondPengaduan({{ $p->id }})" title="Tanggapi">
                                            <i class="fas fa-reply"></i>
                                        </button>
                                        @if($p->latitude && $p->longitude)
                                        <button type="button" class="btn btn-outline-warning" 
                                                onclick="showLocation({{ $p->latitude }}, {{ $p->longitude }})" title="Lokasi">
                                            <i class="fas fa-map-marker-alt"></i>
                                        </button>
                                        @endif
                                    </div>
                                </div>
                                
                                @if($p->foto)
                                <div class="mt-2">
                                    <img src="{{ Storage::url($p->foto) }}" class="img-thumbnail" 
                                         style="max-height: 150px; cursor: pointer;"
                                         onclick="showImage('{{ Storage::url($p->foto) }}')">
                                </div>
                                @endif
                                
                                @if($p->tanggapan)
                                <div class="mt-3 p-3 bg-light rounded">
                                    <div class="d-flex align-items-center mb-2">
                                        <i class="fas fa-reply text-success me-2"></i>
                                        <strong class="text-success">Tanggapan Admin</strong>
                                        <small class="text-muted ms-auto">
                                            {{ $p->tanggal_tanggapan ? $p->tanggal_tanggapan->format('d/m/Y H:i') : '' }}
                                        </small>
                                    </div>
                                    <p class="mb-0">{{ $p->tanggapan }}</p>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="text-center py-5">
                        <div class="text-muted">
                            <i class="fas fa-comments fa-3x mb-3 d-block"></i>
                            <h5>Belum ada pengaduan</h5>
                            <p>Pengaduan dari warga akan muncul di sini</p>
                        </div>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
    
    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Quick Stats -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-pie me-2"></i>
                    Statistik Pengaduan
                </h6>
            </div>
            <div class="card-body">
                <canvas id="pengaduanChart" height="200"></canvas>
            </div>
        </div>
        
        <!-- Recent Activity -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-clock me-2"></i>
                    Aktivitas Terbaru
                </h6>
            </div>
            <div class="card-body">
                <div class="activity-timeline">
                    @foreach($recent_activities ?? [] as $activity)
                    <div class="activity-item">
                        <div class="activity-icon bg-{{ $activity['color'] }}">
                            <i class="fas fa-{{ $activity['icon'] }}"></i>
                        </div>
                        <div class="activity-content">
                            <p class="mb-1">{{ $activity['message'] }}</p>
                            <small class="text-muted">{{ $activity['time'] }}</small>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Pengaduan Modal -->
<div class="modal fade" id="addPengaduanModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>
                    Tambah Pengaduan
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addPengaduanForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Pelapor</label>
                                <select class="form-select" name="penduduk_id">
                                    <option value="">Anonim</option>
                                    @foreach($penduduk ?? [] as $p)
                                    <option value="{{ $p->id }}">{{ $p->nama }} - {{ $p->nik }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Kategori</label>
                                <select class="form-select" name="kategori" required>
                                    <option value="">Pilih Kategori</option>
                                    <option value="infrastruktur">Infrastruktur</option>
                                    <option value="layanan">Layanan Publik</option>
                                    <option value="keamanan">Keamanan</option>
                                    <option value="lingkungan">Lingkungan</option>
                                    <option value="sosial">Sosial</option>
                                    <option value="lainnya">Lainnya</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label required">Judul Pengaduan</label>
                        <input type="text" class="form-control" name="judul" required 
                               placeholder="Ringkasan pengaduan...">
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label required">Deskripsi</label>
                        <textarea class="form-control" name="deskripsi" rows="4" required 
                                  placeholder="Jelaskan detail pengaduan..."></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Foto Pendukung</label>
                        <input type="file" class="form-control" name="foto" accept="image/*">
                        <div class="form-text">Upload foto jika ada (Maks. 2MB)</div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Latitude</label>
                                <input type="number" class="form-control" name="latitude" 
                                       step="any" placeholder="Contoh: -6.200000">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Longitude</label>
                                <input type="number" class="form-control" name="longitude" 
                                       step="any" placeholder="Contoh: 106.816666">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <button type="button" class="btn btn-outline-primary btn-sm" onclick="getCurrentLocation()">
                            <i class="fas fa-map-marker-alt me-2"></i>
                            Dapatkan Lokasi Saat Ini
                        </button>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-2"></i>Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-eye me-2"></i>
                    Detail Pengaduan
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detailContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Respond Modal -->
<div class="modal fade" id="respondModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-reply me-2"></i>
                    Tanggapi Pengaduan
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="respondForm">
                @csrf
                <input type="hidden" name="pengaduan_id" id="respondPengaduanId">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label required">Status</label>
                        <select class="form-select" name="status" required>
                            <option value="diproses">Diproses</option>
                            <option value="selesai">Selesai</option>
                            <option value="ditolak">Ditolak</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label required">Tanggapan</label>
                        <textarea class="form-control" name="tanggapan" rows="4" required 
                                  placeholder="Berikan tanggapan untuk pengaduan ini..."></textarea>
                    </div>
                    
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="send_wa" value="1" checked>
                        <label class="form-check-label">
                            Kirim notifikasi WhatsApp ke pelapor
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-reply me-2"></i>Kirim Tanggapan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Foto Pengaduan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" class="img-fluid" alt="Foto Pengaduan">
            </div>
        </div>
    </div>
</div>

<!-- Location Modal -->
<div class="modal fade" id="locationModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Lokasi Pengaduan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="locationMap" style="height: 400px;"></div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .pengaduan-item {
        transition: background-color 0.2s;
    }
    
    .pengaduan-item:hover {
        background-color: #f8f9fa;
    }
    
    .avatar {
        font-size: 18px;
    }
    
    .activity-timeline {
        position: relative;
    }
    
    .activity-item {
        display: flex;
        margin-bottom: 15px;
    }
    
    .activity-icon {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 12px;
        margin-right: 12px;
        flex-shrink: 0;
    }
    
    .activity-content {
        flex: 1;
    }
    
    .activity-content p {
        font-size: 14px;
        line-height: 1.4;
    }
</style>
@endpush

@push('scripts')
<script>
let map;

$(document).ready(function() {
    // Initialize chart
    initPengaduanChart();
});

// Initialize pengaduan chart
function initPengaduanChart() {
    const ctx = document.getElementById('pengaduanChart').getContext('2d');
    new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Baru', 'Diproses', 'Selesai', 'Ditolak'],
            datasets: [{
                data: [
                    {{ $stats['baru'] ?? 0 }},
                    {{ $stats['diproses'] ?? 0 }},
                    {{ $stats['selesai'] ?? 0 }},
                    {{ $stats['ditolak'] ?? 0 }}
                ],
                backgroundColor: [
                    '#ffc107',
                    '#17a2b8',
                    '#28a745',
                    '#dc3545'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
}

// Apply filters
function applyFilters() {
    const status = document.getElementById('filterStatus').value;
    const kategori = document.getElementById('filterKategori').value;
    const tanggal = document.getElementById('filterTanggal').value;
    
    // Implement filtering logic here
    showToast('Filter diterapkan', 'success');
}

// Reset filters
function resetFilters() {
    document.getElementById('filterStatus').value = '';
    document.getElementById('filterKategori').value = '';
    document.getElementById('filterTanggal').value = '';
    showToast('Filter direset', 'info');
}

// View detail
function viewDetail(id) {
    showLoading();
    
    fetch(`/admin/pengaduan/${id}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const p = data.data;
                const detailHtml = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Informasi Pelapor</h6>
                            <table class="table table-sm">
                                <tr><td>Nama</td><td>: ${p.penduduk ? p.penduduk.nama : 'Anonim'}</td></tr>
                                <tr><td>NIK</td><td>: ${p.penduduk ? p.penduduk.nik : '-'}</td></tr>
                                <tr><td>No. HP</td><td>: ${p.penduduk ? (p.penduduk.no_wa || '-') : '-'}</td></tr>
                                <tr><td>Tanggal</td><td>: ${p.created_at}</td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Informasi Pengaduan</h6>
                            <table class="table table-sm">
                                <tr><td>Kategori</td><td>: ${p.kategori}</td></tr>
                                <tr><td>Status</td><td>: <span class="badge bg-${p.status_color}">${p.status}</span></td></tr>
                                <tr><td>Lokasi</td><td>: ${p.latitude && p.longitude ? 'Ada' : 'Tidak ada'}</td></tr>
                            </table>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>Deskripsi</h6>
                            <p>${p.deskripsi}</p>
                        </div>
                    </div>
                    ${p.foto ? `
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>Foto</h6>
                            <img src="${p.foto}" class="img-fluid" style="max-height: 300px;">
                        </div>
                    </div>
                    ` : ''}
                    ${p.tanggapan ? `
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>Tanggapan</h6>
                            <div class="alert alert-info">
                                <p class="mb-1">${p.tanggapan}</p>
                                <small class="text-muted">Ditanggapi: ${p.tanggal_tanggapan}</small>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                `;
                
                document.getElementById('detailContent').innerHTML = detailHtml;
                $('#detailModal').modal('show');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Gagal memuat detail', 'error');
        })
        .finally(() => {
            hideLoading();
        });
}

// Respond pengaduan
function respondPengaduan(id) {
    document.getElementById('respondPengaduanId').value = id;
    $('#respondModal').modal('show');
}

// Show image
function showImage(src) {
    document.getElementById('modalImage').src = src;
    $('#imageModal').modal('show');
}

// Show location
function showLocation(lat, lng) {
    $('#locationModal').modal('show');
    
    setTimeout(() => {
        if (map) {
            map.remove();
        }
        
        map = L.map('locationMap').setView([lat, lng], 15);
        
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);
        
        L.marker([lat, lng])
            .addTo(map)
            .bindPopup('Lokasi Pengaduan')
            .openPopup();
    }, 300);
}

// Get current location
function getCurrentLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            document.querySelector('input[name="latitude"]').value = position.coords.latitude;
            document.querySelector('input[name="longitude"]').value = position.coords.longitude;
            showToast('Lokasi berhasil didapatkan', 'success');
        }, function() {
            showToast('Gagal mendapatkan lokasi', 'error');
        });
    } else {
        showToast('Browser tidak mendukung geolocation', 'error');
    }
}

// Export pengaduan
function exportPengaduan() {
    showToast('Fitur export akan segera tersedia', 'info');
}

// Handle add pengaduan form
document.getElementById('addPengaduanForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    showLoading();
    
    fetch('/admin/pengaduan', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Pengaduan berhasil ditambahkan', 'success');
            $('#addPengaduanModal').modal('hide');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast(data.message || 'Gagal menambahkan pengaduan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});

// Handle respond form
document.getElementById('respondForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    showLoading();
    
    fetch('/admin/pengaduan/respond', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Tanggapan berhasil dikirim', 'success');
            $('#respondModal').modal('hide');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast(data.message || 'Gagal mengirim tanggapan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});
</script>
@endpush 
