@extends('layouts.app')

@section('title', 'Detail Perangkat Desa')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.perangkat-desa.index') }}">Perangkat Desa</a></li>
    <li class="breadcrumb-item active">Detail {{ $perangkatDesa->nama }}</li>
@endsection

@push('styles')
<style>
    .profile-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
        padding: 2rem;
        margin-bottom: 2rem;
    }
    
    .profile-photo {
        width: 120px;
        height: 120px;
        border: 4px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    }
    
    .info-card {
        border: none;
        border-radius: 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    
    .info-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.15);
    }
    
    .info-label {
        font-weight: 600;
        color: #495057;
        margin-bottom: 0.5rem;
    }
    
    .info-value {
        color: #212529;
        font-size: 1.1rem;
    }
    
    .status-badge {
        font-size: 0.9rem;
        padding: 0.5rem 1rem;
        border-radius: 25px;
        font-weight: 600;
    }
    
    .file-preview {
        max-width: 100%;
        border-radius: 10px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }
    
    .action-buttons .btn {
        border-radius: 25px;
        padding: 0.6rem 1.5rem;
        font-weight: 600;
        margin: 0.25rem;
    }
    
    .section-title {
        color: #495057;
        font-weight: 700;
        border-bottom: 3px solid #e9ecef;
        padding-bottom: 0.5rem;
        margin-bottom: 1.5rem;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <!-- Profile Header -->
    <div class="profile-header text-center">
        <div class="row align-items-center">
            <div class="col-md-3">
                <img src="{{ \App\Helpers\ImageHelper::getAvatarUrl($perangkatDesa->foto, $perangkatDesa->nama) }}" 
                     class="rounded-circle profile-photo mx-auto d-block" 
                     alt="{{ $perangkatDesa->nama }}">
            </div>
            <div class="col-md-9 text-md-start text-center mt-3 mt-md-0">
                <h2 class="mb-2">{{ $perangkatDesa->nama }}</h2>
                <h4 class="mb-3 text-white-50">{{ $perangkatDesa->jabatan }}</h4>
                <div class="d-flex flex-wrap justify-content-md-start justify-content-center gap-2">
                    @if($perangkatDesa->status == 'Aktif')
                        <span class="badge bg-success status-badge">
                            <i class="fas fa-check-circle me-1"></i>Aktif
                        </span>
                    @elseif($perangkatDesa->status == 'Tidak Aktif')
                        <span class="badge bg-warning status-badge">
                            <i class="fas fa-pause-circle me-1"></i>Tidak Aktif
                        </span>
                    @elseif($perangkatDesa->status == 'Pensiun')
                        <span class="badge bg-info status-badge">
                            <i class="fas fa-clock me-1"></i>Pensiun
                        </span>
                    @else
                        <span class="badge bg-secondary status-badge">
                            <i class="fas fa-exchange-alt me-1"></i>Mutasi
                        </span>
                    @endif
                    
                    @if($perangkatDesa->nip)
                        <span class="badge bg-light text-dark status-badge">
                            NIP: {{ $perangkatDesa->nip }}
                        </span>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="action-buttons text-center mb-4">
        <a href="{{ route('admin.perangkat-desa.edit', $perangkatDesa) }}" class="btn btn-primary">
            <i class="fas fa-edit me-2"></i>Edit Data
        </a>
        <a href="{{ route('admin.perangkat-desa.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i>Kembali
        </a>
        @if($perangkatDesa->file_sk)
            <a href="{{ route('admin.perangkat-desa.cetak-sk', $perangkatDesa) }}" class="btn btn-success">
                <i class="fas fa-download me-2"></i>Download SK
            </a>
        @endif
        @if($perangkatDesa->tanda_tangan)
            <a href="{{ \App\Helpers\ImageHelper::getImageUrl($perangkatDesa->tanda_tangan) }}" target="_blank" class="btn btn-info">
                <i class="fas fa-signature me-2"></i>Lihat TTD
            </a>
        @endif
    </div>

    <div class="row">
        <!-- Personal Information -->
        <div class="col-lg-6 mb-4">
            <div class="card info-card h-100">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-user me-2"></i>Informasi Personal
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <div class="info-label">Nama Lengkap</div>
                            <div class="info-value">{{ $perangkatDesa->nama }}</div>
                        </div>
                        @if($perangkatDesa->penduduk)
                        <div class="col-12">
                            <div class="info-label">NIK</div>
                            <div class="info-value">{{ $perangkatDesa->nik }}</div>
                        </div>
                        @endif
                        @if($perangkatDesa->nip)
                        <div class="col-12">
                            <div class="info-label">NIP</div>
                            <div class="info-value">{{ $perangkatDesa->nip }}</div>
                        </div>
                        @endif
                        @if($perangkatDesa->no_hp)
                        <div class="col-12">
                            <div class="info-label">No. HP</div>
                            <div class="info-value">
                                <i class="fas fa-phone me-2 text-success"></i>
                                <a href="tel:{{ $perangkatDesa->no_hp }}" class="text-decoration-none">
                                    {{ $perangkatDesa->no_hp }}
                                </a>
                            </div>
                        </div>
                        @endif
                        @if($perangkatDesa->email)
                        <div class="col-12">
                            <div class="info-label">Email</div>
                            <div class="info-value">
                                <i class="fas fa-envelope me-2 text-info"></i>
                                <a href="mailto:{{ $perangkatDesa->email }}" class="text-decoration-none">
                                    {{ $perangkatDesa->email }}
                                </a>
                            </div>
                        </div>
                        @endif
                        @if($perangkatDesa->alamat)
                        <div class="col-12">
                            <div class="info-label">Alamat</div>
                            <div class="info-value">{{ $perangkatDesa->alamat }}</div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Job Information -->
        <div class="col-lg-6 mb-4">
            <div class="card info-card h-100">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-briefcase me-2"></i>Informasi Jabatan
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <div class="info-label">Jabatan</div>
                            <div class="info-value">{{ $perangkatDesa->jabatan }}</div>
                        </div>
                        @if($perangkatDesa->bidang_tugas)
                        <div class="col-12">
                            <div class="info-label">Bidang Tugas</div>
                            <div class="info-value">{{ $perangkatDesa->bidang_tugas }}</div>
                        </div>
                        @endif
                        @if($perangkatDesa->wilayah_kerja)
                        <div class="col-12">
                            <div class="info-label">Wilayah Kerja</div>
                            <div class="info-value">{{ $perangkatDesa->wilayah_kerja }}</div>
                        </div>
                        @endif
                        <div class="col-12">
                            <div class="info-label">Status</div>
                            <div class="info-value">
                                @if($perangkatDesa->status == 'Aktif')
                                    <span class="badge bg-success">
                                        <i class="fas fa-check-circle me-1"></i>Aktif
                                    </span>
                                @elseif($perangkatDesa->status == 'Tidak Aktif')
                                    <span class="badge bg-warning">
                                        <i class="fas fa-pause-circle me-1"></i>Tidak Aktif
                                    </span>
                                @elseif($perangkatDesa->status == 'Pensiun')
                                    <span class="badge bg-info">
                                        <i class="fas fa-clock me-1"></i>Pensiun
                                    </span>
                                @else
                                    <span class="badge bg-secondary">
                                        <i class="fas fa-exchange-alt me-1"></i>Mutasi
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="info-label">Mulai Tugas</div>
                            <div class="info-value">
                                <i class="fas fa-calendar-alt me-2 text-primary"></i>
                                {{ \Carbon\Carbon::parse($perangkatDesa->mulai_tugas)->format('d/m/Y') }}
                            </div>
                        </div>
                        @if($perangkatDesa->selesai_tugas)
                        <div class="col-6">
                            <div class="info-label">Selesai Tugas</div>
                            <div class="info-value">
                                <i class="fas fa-calendar-alt me-2 text-danger"></i>
                                {{ \Carbon\Carbon::parse($perangkatDesa->selesai_tugas)->format('d/m/Y') }}
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Tasks and Responsibilities -->
        @if($perangkatDesa->tugas_tanggung_jawab)
        <div class="col-12 mb-4">
            <div class="card info-card">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-tasks me-2"></i>Tugas & Tanggung Jawab
                    </h5>
                </div>
                <div class="card-body">
                    <div class="info-value">
                        {!! nl2br(e($perangkatDesa->tugas_tanggung_jawab)) !!}
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Files Section -->
        @if($perangkatDesa->file_sk || $perangkatDesa->tanda_tangan)
        <div class="col-12 mb-4">
            <div class="card info-card">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-file-alt me-2"></i>Dokumen
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @if($perangkatDesa->file_sk)
                        <div class="col-md-6 mb-3">
                            <div class="text-center">
                                <i class="fas fa-file-pdf fa-3x text-danger mb-2"></i>
                                <h6>Surat Keputusan</h6>
                                <a href="{{ route('admin.perangkat-desa.cetak-sk', $perangkatDesa) }}" 
                                   class="btn btn-outline-danger btn-sm">
                                    <i class="fas fa-download me-1"></i>Download
                                </a>
                            </div>
                        </div>
                        @endif
                        
                        @if($perangkatDesa->tanda_tangan)
                        <div class="col-md-6 mb-3">
                            <div class="text-center">
                                <h6>Tanda Tangan</h6>
                                <img src="{{ \App\Helpers\ImageHelper::getImageUrl($perangkatDesa->tanda_tangan) }}" 
                                     class="file-preview mb-2" 
                                     style="max-height: 100px;"
                                     alt="Tanda Tangan">
                                <br>
                                <a href="{{ \App\Helpers\ImageHelper::getImageUrl($perangkatDesa->tanda_tangan) }}" 
                                   target="_blank" 
                                   class="btn btn-outline-info btn-sm">
                                    <i class="fas fa-external-link-alt me-1"></i>Lihat
                                </a>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Related Penduduk Data -->
        @if($perangkatDesa->penduduk)
        <div class="col-12 mb-4">
            <div class="card info-card">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-id-card me-2"></i>Data Penduduk Terkait
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="info-label">NIK</div>
                            <div class="info-value">{{ $perangkatDesa->penduduk->nik }}</div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-label">Nama Lengkap</div>
                            <div class="info-value">{{ $perangkatDesa->penduduk->nama }}</div>
                        </div>
                        @if($perangkatDesa->penduduk->tempat_lahir && $perangkatDesa->penduduk->tanggal_lahir)
                        <div class="col-md-6">
                            <div class="info-label">Tempat, Tanggal Lahir</div>
                            <div class="info-value">
                                {{ $perangkatDesa->penduduk->tempat_lahir }}, 
                                {{ \Carbon\Carbon::parse($perangkatDesa->penduduk->tanggal_lahir)->format('d/m/Y') }}
                            </div>
                        </div>
                        @endif
                        @if($perangkatDesa->penduduk->jenis_kelamin)
                        <div class="col-md-6">
                            <div class="info-label">Jenis Kelamin</div>
                            <div class="info-value">{{ $perangkatDesa->penduduk->jenis_kelamin }}</div>
                        </div>
                        @endif
                        @if($perangkatDesa->penduduk->alamat)
                        <div class="col-12">
                            <div class="info-label">Alamat</div>
                            <div class="info-value">{{ $perangkatDesa->penduduk->alamat }}</div>
                        </div>
                        @endif
                        <div class="col-12 text-end">
                            <a href="{{ route('admin.penduduk.show', $perangkatDesa->penduduk) }}" 
                               class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-external-link-alt me-1"></i>Lihat Detail Penduduk
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Add smooth animations
    $('.info-card').each(function(index) {
        $(this).css('animation-delay', (index * 0.1) + 's');
        $(this).addClass('animate__animated animate__fadeInUp');
    });
});
</script>
@endpush 