@extends('layouts.app')

@section('title', 'Detail Pohon Keluarga - ' . $penduduk->nama)

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.pohon-keluarga.index') }}">Pohon Keluarga</a></li>
    <li class="breadcrumb-item active">{{ $penduduk->nama }}</li>
@endsection

@section('content')
<div class="row">
    <!-- Main Person Card -->
    <div class="col-12 mb-4">
        <div class="card border-0 shadow-lg">
            <div class="card-header bg-gradient-primary text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-user-circle me-2"></i>
                        Detail Pohon Keluarga
                    </h5>
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.pohon-keluarga.edit', $penduduk->nik) }}" 
                           class="btn btn-warning btn-sm">
                            <i class="fas fa-edit me-1"></i>Edit Relasi
                        </a>
                        <a href="{{ route('admin.pohon-keluarga.visualisasi', $penduduk->nik) }}" 
                           class="btn btn-info btn-sm">
                            <i class="fas fa-project-diagram me-1"></i>Visualisasi
                        </a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-2 text-center">
                        <div class="avatar-large {{ $penduduk->jenis_kelamin == 'L' ? 'bg-primary' : 'bg-pink' }} mb-3">
                            <i class="fas fa-{{ $penduduk->jenis_kelamin == 'L' ? 'male' : 'female' }} text-white"></i>
                        </div>
                    </div>
                    <div class="col-md-10">
                        <h4 class="fw-bold mb-2">{{ $penduduk->nama }}</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>NIK:</strong> {{ $penduduk->nik }}</p>
                                <p class="mb-1"><strong>No. KK:</strong> {{ $penduduk->no_kk }}</p>
                                <p class="mb-1"><strong>Jenis Kelamin:</strong> 
                                    <span class="badge {{ $penduduk->jenis_kelamin == 'L' ? 'bg-primary' : 'bg-pink' }}">
                                        {{ $penduduk->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }}
                                    </span>
                                </p>
                            </div>
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Tanggal Lahir:</strong> 
                                    {{ $penduduk->tanggal_lahir ? $penduduk->tanggal_lahir->format('d F Y') : '-' }}
                                </p>
                                <p class="mb-1"><strong>Umur:</strong> {{ $penduduk->umur }} tahun</p>
                                <p class="mb-1"><strong>Status Keluarga:</strong> 
                                    <span class="badge bg-info">{{ $penduduk->status_keluarga ?? 'Belum ditetapkan' }}</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Family Summary Cards -->
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-info h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-users"></i>
                </div>
                <div>
                    <div class="fs-3 fw-bold">{{ count($keluargaSummary['orangtua'] ?? []) }}</div>
                    <div class="small">Orang Tua</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-success h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-child"></i>
                </div>
                <div>
                    <div class="fs-3 fw-bold">{{ count($keluargaSummary['anak'] ?? []) }}</div>
                    <div class="small">Anak</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-warning h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-user-friends"></i>
                </div>
                <div>
                    <div class="fs-3 fw-bold">{{ count($keluargaSummary['saudara'] ?? []) }}</div>
                    <div class="small">Saudara</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-danger h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-baby"></i>
                </div>
                <div>
                    <div class="fs-3 fw-bold">{{ count($keluargaSummary['cucu'] ?? []) }}</div>
                    <div class="small">Cucu</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Parents Section -->
    @if(!empty($keluargaSummary['orangtua']))
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-users text-primary me-2"></i>
                    Orang Tua
                </h6>
            </div>
            <div class="card-body">
                @foreach($keluargaSummary['orangtua'] as $orangtua)
                <div class="d-flex align-items-center mb-3 p-3 bg-light rounded">
                    <div class="avatar-sm {{ $orangtua->jenis_kelamin == 'L' ? 'bg-primary' : 'bg-pink' }} me-3">
                        <i class="fas fa-{{ $orangtua->jenis_kelamin == 'L' ? 'male' : 'female' }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">{{ $orangtua->nama }}</h6>
                        <small class="text-muted">
                            {{ $orangtua->jenis_kelamin == 'L' ? 'Ayah' : 'Ibu' }} • 
                            {{ $orangtua->umur }} tahun •
                            NIK: {{ $orangtua->nik }}
                        </small>
                    </div>
                    <div>
                        <a href="{{ route('admin.pohon-keluarga.show', $orangtua->nik) }}" 
                           class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-eye"></i>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Grandparents Section -->
    @if(!empty($keluargaSummary['kakek_nenek']))
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-crown text-warning me-2"></i>
                    Kakek & Nenek
                </h6>
            </div>
            <div class="card-body">
                @foreach($keluargaSummary['kakek_nenek'] as $kakekNenek)
                <div class="d-flex align-items-center mb-3 p-3 bg-light rounded">
                    <div class="avatar-sm {{ $kakekNenek->jenis_kelamin == 'L' ? 'bg-warning' : 'bg-info' }} me-3">
                        <i class="fas fa-{{ $kakekNenek->jenis_kelamin == 'L' ? 'male' : 'female' }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">{{ $kakekNenek->nama }}</h6>
                        <small class="text-muted">
                            {{ $kakekNenek->jenis_kelamin == 'L' ? 'Kakek' : 'Nenek' }} • 
                            {{ $kakekNenek->umur }} tahun •
                            NIK: {{ $kakekNenek->nik }}
                        </small>
                    </div>
                    <div>
                        <a href="{{ route('admin.pohon-keluarga.show', $kakekNenek->nik) }}" 
                           class="btn btn-sm btn-outline-warning">
                            <i class="fas fa-eye"></i>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Siblings Section -->
    @if(!empty($keluargaSummary['saudara']))
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-user-friends text-info me-2"></i>
                    Saudara Kandung
                </h6>
            </div>
            <div class="card-body">
                @foreach($keluargaSummary['saudara'] as $saudara)
                <div class="d-flex align-items-center mb-3 p-3 bg-light rounded">
                    <div class="avatar-sm {{ $saudara->jenis_kelamin == 'L' ? 'bg-info' : 'bg-pink' }} me-3">
                        <i class="fas fa-{{ $saudara->jenis_kelamin == 'L' ? 'male' : 'female' }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">{{ $saudara->nama }}</h6>
                        <small class="text-muted">
                            {{ $saudara->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }} • 
                            {{ $saudara->umur }} tahun •
                            NIK: {{ $saudara->nik }}
                        </small>
                    </div>
                    <div>
                        <a href="{{ route('admin.pohon-keluarga.show', $saudara->nik) }}" 
                           class="btn btn-sm btn-outline-info">
                            <i class="fas fa-eye"></i>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Children Section -->
    @if(!empty($keluargaSummary['anak']))
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-child text-success me-2"></i>
                    Anak
                </h6>
            </div>
            <div class="card-body">
                @foreach($keluargaSummary['anak'] as $anak)
                <div class="d-flex align-items-center mb-3 p-3 bg-light rounded">
                    <div class="avatar-sm {{ $anak->jenis_kelamin == 'L' ? 'bg-success' : 'bg-pink' }} me-3">
                        <i class="fas fa-{{ $anak->jenis_kelamin == 'L' ? 'male' : 'female' }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">{{ $anak->nama }}</h6>
                        <small class="text-muted">
                            {{ $anak->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }} • 
                            {{ $anak->umur }} tahun •
                            NIK: {{ $anak->nik }}
                        </small>
                    </div>
                    <div>
                        <a href="{{ route('admin.pohon-keluarga.show', $anak->nik) }}" 
                           class="btn btn-sm btn-outline-success">
                            <i class="fas fa-eye"></i>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Grandchildren Section -->
    @if(!empty($keluargaSummary['cucu']))
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-baby text-danger me-2"></i>
                    Cucu
                </h6>
            </div>
            <div class="card-body">
                @foreach($keluargaSummary['cucu'] as $cucu)
                <div class="d-flex align-items-center mb-3 p-3 bg-light rounded">
                    <div class="avatar-sm {{ $cucu->jenis_kelamin == 'L' ? 'bg-danger' : 'bg-pink' }} me-3">
                        <i class="fas fa-{{ $cucu->jenis_kelamin == 'L' ? 'male' : 'female' }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">{{ $cucu->nama }}</h6>
                        <small class="text-muted">
                            {{ $cucu->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan' }} • 
                            {{ $cucu->umur }} tahun •
                            NIK: {{ $cucu->nik }}
                        </small>
                    </div>
                    <div>
                        <a href="{{ route('admin.pohon-keluarga.show', $cucu->nik) }}" 
                           class="btn btn-sm btn-outline-danger">
                            <i class="fas fa-eye"></i>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    <!-- Family Tree Visualization -->
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h6 class="mb-0">
                    <i class="fas fa-project-diagram text-primary me-2"></i>
                    Diagram Pohon Keluarga
                </h6>
                <a href="{{ route('admin.pohon-keluarga.visualisasi', $penduduk->nik) }}" 
                   class="btn btn-sm btn-primary">
                    <i class="fas fa-expand me-1"></i>Lihat Full Screen
                </a>
            </div>
            <div class="card-body">
                <div id="family-tree-container" style="min-height: 400px;">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <p class="mt-3 text-muted">Memuat diagram pohon keluarga...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="col-12">
        <div class="d-flex justify-content-between">
            <a href="{{ route('admin.pohon-keluarga.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali ke Daftar
            </a>
            <div class="d-flex gap-2">
                <a href="{{ route('admin.pohon-keluarga.edit', $penduduk->nik) }}" 
                   class="btn btn-warning">
                    <i class="fas fa-edit me-2"></i>Edit Relasi
                </a>
                <a href="{{ route('admin.pohon-keluarga.visualisasi', $penduduk->nik) }}" 
                   class="btn btn-info">
                    <i class="fas fa-project-diagram me-2"></i>Visualisasi Interaktif
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.avatar-large {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 32px;
    margin: 0 auto;
}

.avatar-sm {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.bg-pink {
    background-color: #e91e63 !important;
}

.text-pink {
    color: #e91e63 !important;
}

.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

.card-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.card-gradient-info {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    color: white;
}

.card-gradient-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
}

.card-gradient-warning {
    background: linear-gradient(135deg, #ffc107 0%, #fd7e14 100%);
    color: white;
}

.card-gradient-danger {
    background: linear-gradient(135deg, #dc3545 0%, #e83e8c 100%);
    color: white;
}

.card {
    border: none;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    transition: all 0.3s ease;
}

.card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    transform: translateY(-2px);
}

#family-tree-container {
    background: #f8f9fa;
    border-radius: 8px;
    border: 2px dashed #dee2e6;
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Load family tree visualization
    loadFamilyTreePreview();
});

function loadFamilyTreePreview() {
    // Simulate loading family tree data
    setTimeout(function() {
        const container = document.getElementById('family-tree-container');
        container.innerHTML = `
            <div class="text-center py-4">
                <div class="row justify-content-center">
                    <div class="col-md-8">
                        <div class="family-tree-preview">
                            <h6 class="text-muted mb-3">Pratinjau Pohon Keluarga</h6>
                            <p class="text-muted">
                                <i class="fas fa-info-circle me-2"></i>
                                Diagram pohon keluarga menampilkan hubungan antar anggota keluarga. 
                                Klik "Lihat Full Screen" untuk visualisasi interaktif yang lebih detail.
                            </p>
                            <div class="mt-3">
                                <a href="{{ route('admin.pohon-keluarga.visualisasi', $penduduk->nik) }}" 
                                   class="btn btn-primary">
                                    <i class="fas fa-project-diagram me-2"></i>
                                    Buka Visualisasi Interaktif
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `;
    }, 1500);
}
</script>
@endpush
