@extends('layouts.app')

@section('title', 'Statistik Pohon Keluarga')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.pohon-keluarga.index') }}">Pohon Keluarga</a></li>
    <li class="breadcrumb-item active">Statistik</li>
@endsection

@section('content')
<div class="row">
    <!-- Header Card -->
    <div class="col-12 mb-4">
        <div class="card border-0 shadow">
            <div class="card-header bg-gradient-primary text-white">
                <h5 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Statistik Pohon Keluarga Multigenerasi
                </h5>
            </div>
            <div class="card-body">
                <p class="mb-0 text-muted">
                    Dashboard analisis data kependudukan berdasarkan relasi keluarga dan struktur pohon keluarga multigenerasi.
                </p>
            </div>
        </div>
    </div>

    <!-- Generation Statistics -->
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-primary h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-layer-group"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['generasi']['generasi_1'] ?? 0 }}</div>
                    <div class="small">Generasi Pertama</div>
                    <div class="small opacity-75">Founder Families</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-success h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-users"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['generasi']['generasi_2'] ?? 0 }}</div>
                    <div class="small">Generasi Kedua+</div>
                    <div class="small opacity-75">Memiliki Relasi Orang Tua</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-warning h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-home"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['keluarga_besar']['keluarga_terbesar']['jumlah_anak'] ?? 0 }}</div>
                    <div class="small">Keluarga Terbesar</div>
                    <div class="small opacity-75">Jumlah Anak</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-info h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-percentage"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ number_format($stats['keluarga_besar']['rata_rata_anak_per_keluarga'] ?? 0, 1) }}</div>
                    <div class="small">Rata-rata Anak</div>
                    <div class="small opacity-75">Per Keluarga</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Age Statistics -->
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-birthday-cake text-primary me-2"></i>
                    Statistik Umur Orang Tua
                </h6>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6">
                        <div class="border-end">
                            <div class="display-6 text-primary">
                                {{ number_format($stats['umur_rata_rata']['rata_rata_umur_ayah'] ?? 0, 0) }}
                            </div>
                            <small class="text-muted">Rata-rata Umur Ayah</small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="display-6 text-pink">
                            {{ number_format($stats['umur_rata_rata']['rata_rata_umur_ibu'] ?? 0, 0) }}
                        </div>
                        <small class="text-muted">Rata-rata Umur Ibu</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Largest Family Info -->
    <div class="col-md-6 mb-4">
        <div class="card">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-crown text-warning me-2"></i>
                    Keluarga Terbesar
                </h6>
            </div>
            <div class="card-body">
                @if(isset($stats['keluarga_besar']['keluarga_terbesar']) && $stats['keluarga_besar']['keluarga_terbesar'])
                    <div class="d-flex align-items-center">
                        <div class="avatar-lg bg-warning bg-opacity-20 me-3">
                            <i class="fas fa-male text-warning"></i>
                        </div>
                        <div>
                            <h5 class="mb-1">{{ $stats['keluarga_besar']['keluarga_terbesar']['nama_ayah'] }}</h5>
                            <p class="text-muted mb-0">
                                Memiliki <strong>{{ $stats['keluarga_besar']['keluarga_terbesar']['jumlah_anak'] }} anak</strong>
                            </p>
                        </div>
                    </div>
                @else
                    <div class="text-center text-muted py-3">
                        <i class="fas fa-info-circle mb-2"></i>
                        <p class="mb-0">Data keluarga terbesar tidak tersedia</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Family Distribution Chart -->
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h6 class="mb-0">
                    <i class="fas fa-chart-pie text-success me-2"></i>
                    Distribusi Jumlah Anak per Keluarga
                </h6>
                <div class="dropdown">
                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" 
                            data-bs-toggle="dropdown">
                        <i class="fas fa-filter me-1"></i>Filter
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#" onclick="filterChart('all')">Semua</a></li>
                        <li><a class="dropdown-item" href="#" onclick="filterChart('0-2')">0-2 Anak</a></li>
                        <li><a class="dropdown-item" href="#" onclick="filterChart('3-5')">3-5 Anak</a></li>
                        <li><a class="dropdown-item" href="#" onclick="filterChart('6+')">6+ Anak</a></li>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <canvas id="familyDistributionChart" width="400" height="200"></canvas>
            </div>
        </div>
    </div>

    <!-- Generation Overview -->
    <div class="col-lg-4 mb-4">
        <div class="card h-100">
            <div class="card-header bg-light">
                <h6 class="mb-0">
                    <i class="fas fa-sitemap text-info me-2"></i>
                    Ikhtisar Generasi
                </h6>
            </div>
            <div class="card-body">
                <div class="generation-overview">
                    <div class="generation-item mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <div class="generation-icon bg-primary bg-opacity-20 me-3">
                                    <i class="fas fa-crown text-primary"></i>
                                </div>
                                <div>
                                    <div class="fw-bold">Generasi 1</div>
                                    <small class="text-muted">Pendiri Keluarga</small>
                                </div>
                            </div>
                            <span class="badge bg-primary">{{ $stats['generasi']['generasi_1'] ?? 0 }}</span>
                        </div>
                    </div>

                    <div class="generation-item mb-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="d-flex align-items-center">
                                <div class="generation-icon bg-success bg-opacity-20 me-3">
                                    <i class="fas fa-users text-success"></i>
                                </div>
                                <div>
                                    <div class="fw-bold">Generasi 2+</div>
                                    <small class="text-muted">Keturunan</small>
                                </div>
                            </div>
                            <span class="badge bg-success">{{ $stats['generasi']['generasi_2'] ?? 0 }}</span>
                        </div>
                    </div>

                    <hr>
                    
                    <div class="text-center">
                        <div class="fw-bold text-primary">Total Populasi</div>
                        <div class="display-6 text-primary">
                            {{ ($stats['generasi']['generasi_1'] ?? 0) + ($stats['generasi']['generasi_2'] ?? 0) }}
                        </div>
                        <small class="text-muted">Orang</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Statistics Table -->
    <div class="col-12 mb-4">
        <div class="card">
            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                <h6 class="mb-0">
                    <i class="fas fa-table text-dark me-2"></i>
                    Data Detail Distribusi Anak
                </h6>
                <button class="btn btn-sm btn-primary" onclick="exportTable()">
                    <i class="fas fa-download me-1"></i>Export Excel
                </button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover" id="distributionTable">
                        <thead class="table-dark">
                            <tr>
                                <th>No</th>
                                <th>Jumlah Anak</th>
                                <th>Jumlah Keluarga</th>
                                <th>Persentase</th>
                                <th>Grafik</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(isset($stats['distribusi_anak']) && count($stats['distribusi_anak']) > 0)
                                @php
                                    $total_families = collect($stats['distribusi_anak'])->sum('jumlah_keluarga');
                                @endphp
                                @foreach($stats['distribusi_anak'] as $index => $item)
                                    @php
                                        $percentage = $total_families > 0 ? ($item->jumlah_keluarga / $total_families) * 100 : 0;
                                    @endphp
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>
                                            <span class="badge bg-primary">{{ $item->jumlah_anak }}</span>
                                        </td>
                                        <td>{{ $item->jumlah_keluarga }}</td>
                                        <td>{{ number_format($percentage, 1) }}%</td>
                                        <td>
                                            <div class="progress" style="height: 20px;">
                                                <div class="progress-bar bg-success" role="progressbar" 
                                                     style="width: {{ $percentage }}%" 
                                                     aria-valuenow="{{ $percentage }}" 
                                                     aria-valuemin="0" 
                                                     aria-valuemax="100">
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-4">
                                        <i class="fas fa-info-circle me-2"></i>
                                        Data distribusi anak tidak tersedia
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="col-12">
        <div class="d-flex justify-content-between">
            <a href="{{ route('admin.pohon-keluarga.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali ke Pohon Keluarga
            </a>
            <div class="d-flex gap-2">
                <button class="btn btn-success" onclick="printStatistics()">
                    <i class="fas fa-print me-2"></i>Cetak Laporan
                </button>
                <button class="btn btn-info" onclick="refreshData()">
                    <i class="fas fa-sync me-2"></i>Refresh Data
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.stats-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

.avatar-lg {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

.generation-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
}

.bg-pink {
    background-color: #e91e63 !important;
}

.text-pink {
    color: #e91e63 !important;
}

.card-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.card-gradient-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
}

.card-gradient-warning {
    background: linear-gradient(135deg, #ffc107 0%, #fd7e14 100%);
    color: white;
}

.card-gradient-info {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
    color: white;
}

.card {
    border: none;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    transition: all 0.3s ease;
}

.card:hover {
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    transform: translateY(-2px);
}

.generation-overview {
    max-height: 300px;
    overflow-y: auto;
}

.table th {
    border-top: none;
    font-weight: 600;
}

.progress {
    background-color: rgba(0, 0, 0, 0.1);
}

@media print {
    .btn, .dropdown, .card-header .d-flex {
        display: none !important;
    }
    
    .card {
        box-shadow: none !important;
        border: 1px solid #dee2e6 !important;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
let familyChart;

$(document).ready(function() {
    initializeFamilyDistributionChart();
});

function initializeFamilyDistributionChart() {
    const ctx = document.getElementById('familyDistributionChart').getContext('2d');
    
    // Prepare data from backend
    const distributionData = @json($stats['distribusi_anak'] ?? []);
    
    const labels = distributionData.map(item => `${item.jumlah_anak} Anak`);
    const data = distributionData.map(item => item.jumlah_keluarga);
    
    familyChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: labels,
            datasets: [{
                data: data,
                backgroundColor: [
                    '#007bff',
                    '#28a745',
                    '#ffc107',
                    '#dc3545',
                    '#6f42c1',
                    '#fd7e14',
                    '#20c997',
                    '#6c757d'
                ],
                borderWidth: 2,
                borderColor: '#ffffff'
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        padding: 20
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = ((context.parsed / total) * 100).toFixed(1);
                            return `${context.label}: ${context.parsed} keluarga (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });
}

function filterChart(filter) {
    // This would filter the chart data based on the selected filter
    // For now, we'll just show a message
    console.log('Filtering chart by:', filter);
    
    // You could implement actual filtering logic here
    // by updating the chart data and calling familyChart.update()
}

function exportTable() {
    // Simple CSV export functionality
    const table = document.getElementById('distributionTable');
    let csv = [];
    
    // Get headers
    const headers = Array.from(table.querySelectorAll('thead th')).map(th => th.textContent);
    csv.push(headers.join(','));
    
    // Get data rows
    const rows = table.querySelectorAll('tbody tr');
    rows.forEach(row => {
        const cols = Array.from(row.querySelectorAll('td')).map(td => {
            // Clean up the text content
            return td.textContent.replace(/,/g, ';').trim();
        });
        if (cols.length > 0 && !cols[0].includes('tidak tersedia')) {
            csv.push(cols.join(','));
        }
    });
    
    // Download CSV
    const csvContent = csv.join('\n');
    const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
    const link = document.createElement('a');
    const url = URL.createObjectURL(blob);
    link.setAttribute('href', url);
    link.setAttribute('download', `statistik-pohon-keluarga-${new Date().toISOString().split('T')[0]}.csv`);
    link.style.visibility = 'hidden';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

function printStatistics() {
    window.print();
}

function refreshData() {
    location.reload();
}

// Add animation to statistics cards
$(document).ready(function() {
    $('.card-gradient-primary, .card-gradient-success, .card-gradient-warning, .card-gradient-info').each(function(index) {
        $(this).hide().delay(index * 200).fadeIn(500);
    });
});
</script>
@endpush
