@extends('layouts.app')

@section('title', 'PPOB Settings')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.ppob.index') }}">PPOB Management</a></li>
<li class="breadcrumb-item active">Settings</li>
@endsection

@section('content')
<div class="container-fluid">
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-cog me-2"></i>
                            Pengaturan PPOB
                        </h5>
                        <div class="btn-group">
                            <button type="button" class="btn btn-success" onclick="saveAllSettings()">
                                <i class="fas fa-save me-1"></i>
                                Simpan Semua
                            </button>
                            <button type="button" class="btn btn-secondary" onclick="resetToDefault()">
                                <i class="fas fa-undo me-1"></i>
                                Reset Default
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    
                    <form id="ppobSettingsForm" method="POST" action="{{ route('admin.ppob.settings.update') }}">
                        @csrf
                        
                        <!-- Settings Tabs -->
                        <ul class="nav nav-tabs mb-4" id="settingsTabs" role="tablist">
                            @forelse($settings as $category => $categorySettings)
                            <li class="nav-item" role="presentation">
                                <button class="nav-link {{ $loop->first ? 'active' : '' }}" 
                                        id="{{ $category }}-tab" 
                                        data-bs-toggle="tab" 
                                        data-bs-target="#{{ $category }}-tab-pane" 
                                        type="button" 
                                        role="tab">
                                    <i class="fas fa-{{ $category === 'general' ? 'cog' : ($category === 'fees' ? 'coins' : ($category === 'limits' ? 'shield-alt' : ($category === 'products' ? 'mobile-alt' : ($category === 'notifications' ? 'bell' : 'lock')))) }} me-2"></i>
                                    {{ ucfirst(str_replace('_', ' ', $category)) }}
                                </button>
                            </li>
                            @empty
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="default-tab" data-bs-toggle="tab" data-bs-target="#default-tab-pane" type="button" role="tab">
                                    <i class="fas fa-cog me-2"></i>
                                    Default Settings
                                </button>
                            </li>
                            @endforelse
                        </ul>

                        <!-- Settings Content -->
                        <div class="tab-content" id="settingsTabContent">
                            @forelse($settings as $category => $categorySettings)
                            <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" 
                                 id="{{ $category }}-tab-pane" 
                                 role="tabpanel">
                                
                                <div class="row">
                                    @foreach($categorySettings as $setting)
                                    <div class="col-lg-6 mb-4">
                                        <div class="setting-card">
                                            <div class="setting-header">
                                                <label for="setting_{{ $setting->key }}" class="form-label fw-bold">
                                                    {{ ucwords(str_replace('_', ' ', $setting->key)) }}
                                                </label>
                                                @if($setting->description)
                                                <small class="text-muted d-block">{{ $setting->description }}</small>
                                                @endif
                                            </div>
                                            <div class="setting-input">
                                                @if($setting->type === 'boolean')
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" 
                                                               type="checkbox" 
                                                               id="setting_{{ $setting->key }}"
                                                               name="settings[{{ $loop->parent->index }}][value]"
                                                               value="1"
                                                               {{ $setting->value ? 'checked' : '' }}>
                                                        <label class="form-check-label" for="setting_{{ $setting->key }}">
                                                            {{ $setting->value ? 'Aktif' : 'Nonaktif' }}
                                                        </label>
                                                    </div>
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][key]" value="{{ $setting->key }}">
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][type]" value="{{ $setting->type }}">
                                                    
                                                @elseif($setting->type === 'number')
                                                    <div class="input-group">
                                                        @if(str_contains($setting->key, 'fee') || str_contains($setting->key, 'amount') || str_contains($setting->key, 'limit'))
                                                        <span class="input-group-text">Rp</span>
                                                        @endif
                                                        <input type="number" 
                                                               class="form-control" 
                                                               id="setting_{{ $setting->key }}"
                                                               name="settings[{{ $loop->parent->index }}][value]"
                                                               value="{{ $setting->value }}"
                                                               step="{{ str_contains($setting->key, 'percentage') ? '0.01' : '1' }}"
                                                               min="0">
                                                        @if(str_contains($setting->key, 'percentage'))
                                                        <span class="input-group-text">%</span>
                                                        @endif
                                                    </div>
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][key]" value="{{ $setting->key }}">
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][type]" value="{{ $setting->type }}">
                                                    
                                                @elseif($setting->type === 'array' && $setting->key === 'enabled_products')
                                                    <div class="product-checkboxes">
                                                        @php
                                                            $products = ['pulsa', 'paket_data', 'pln', 'pbb', 'bpjs', 'tv_kabel', 'internet', 'finance'];
                                                            $enabledProducts = is_array($setting->value) ? $setting->value : [];
                                                        @endphp
                                                        @foreach($products as $product)
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" 
                                                                   type="checkbox" 
                                                                   id="product_{{ $product }}"
                                                                   name="enabled_products[]"
                                                                   value="{{ $product }}"
                                                                   {{ in_array($product, $enabledProducts) ? 'checked' : '' }}>
                                                            <label class="form-check-label" for="product_{{ $product }}">
                                                                {{ strtoupper($product) }}
                                                            </label>
                                                        </div>
                                                        @endforeach
                                                    </div>
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][key]" value="{{ $setting->key }}">
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][type]" value="{{ $setting->type }}">
                                                    <input type="hidden" id="enabled_products_value" name="settings[{{ $loop->parent->index }}][value]" value="{{ json_encode($enabledProducts) }}">
                                                    
                                                @elseif($setting->type === 'array' && $setting->key === 'featured_products')
                                                    <div class="product-checkboxes">
                                                        @php
                                                            $products = ['pulsa', 'paket_data', 'pln', 'pbb', 'bpjs', 'tv_kabel', 'internet', 'finance'];
                                                            $featuredProducts = is_array($setting->value) ? $setting->value : [];
                                                        @endphp
                                                        @foreach($products as $product)
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input" 
                                                                   type="checkbox" 
                                                                   id="featured_{{ $product }}"
                                                                   name="featured_products[]"
                                                                   value="{{ $product }}"
                                                                   {{ in_array($product, $featuredProducts) ? 'checked' : '' }}>
                                                            <label class="form-check-label" for="featured_{{ $product }}">
                                                                {{ strtoupper($product) }}
                                                            </label>
                                                        </div>
                                                        @endforeach
                                                    </div>
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][key]" value="{{ $setting->key }}">
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][type]" value="{{ $setting->type }}">
                                                    <input type="hidden" id="featured_products_value" name="settings[{{ $loop->parent->index }}][value]" value="{{ json_encode($featuredProducts) }}">
                                                    
                                                @else
                                                    <input type="text" 
                                                           class="form-control" 
                                                           id="setting_{{ $setting->key }}"
                                                           name="settings[{{ $loop->parent->index }}][value]"
                                                           value="{{ is_array($setting->value) ? json_encode($setting->value) : $setting->value }}">
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][key]" value="{{ $setting->key }}">
                                                    <input type="hidden" name="settings[{{ $loop->parent->index }}][type]" value="{{ $setting->type }}">
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                
                            </div>
                            @empty
                            <div class="tab-pane fade show active" id="default-tab-pane" role="tabpanel">
                                <div class="text-center py-5">
                                    <i class="fas fa-cog fa-3x text-muted mb-3"></i>
                                    <h5>Belum Ada Pengaturan PPOB</h5>
                                    <p class="text-muted">Pengaturan default akan dibuat otomatis saat pertama kali mengakses halaman ini.</p>
                                    <button type="button" class="btn btn-primary" onclick="createDefaultSettings()">
                                        <i class="fas fa-plus me-1"></i>
                                        Buat Pengaturan Default
                                    </button>
                                </div>
                            </div>
                            @endforelse
                        </div>
                        
                    </form>
                    
                </div>
            </div>
        </div>
    </div>

    <!-- API Test Section -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-plug me-2"></i>
                        Test Koneksi OttoPay
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <button type="button" class="btn btn-primary" onclick="testOttopayConnection()">
                                <i class="fas fa-wifi me-2"></i>
                                Test Koneksi API
                            </button>
                            <button type="button" class="btn btn-info ms-2" onclick="testPpobProducts()">
                                <i class="fas fa-list me-2"></i>
                                Test Load Products
                            </button>
                        </div>
                        <div class="col-lg-6">
                            <div id="testResults" class="mt-3"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
.setting-card {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 20px;
    height: 100%;
}

.setting-header {
    margin-bottom: 15px;
}

.setting-input {
    flex: 1;
}

.product-checkboxes {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
}

.form-check-inline {
    margin-right: 15px;
    margin-bottom: 10px;
}

.nav-tabs {
    border-bottom: 2px solid #e9ecef;
}

.nav-tabs .nav-link {
    border-radius: 8px 8px 0 0;
    border: 1px solid #dee2e6;
    margin-right: 3px;
    background-color: #6f42c1;
    color: white;
    font-weight: 500;
    padding: 12px 20px;
    transition: none;
    position: relative;
    cursor: default;
    opacity: 0.7;
}

.nav-tabs .nav-link:hover {
    background-color: #6f42c1;
    color: white;
    border-color: #dee2e6;
    opacity: 0.7;
    cursor: default;
}

.nav-tabs .nav-link.active {
    background-color: #6f42c1;
    color: white;
    border-color: #6f42c1;
    opacity: 1;
    cursor: default;
}

.nav-tabs .nav-link.active::after {
    content: '';
    position: absolute;
    bottom: -2px;
    left: 0;
    right: 0;
    height: 3px;
    background-color: #ffffff;
}

.tab-pane {
    min-height: 400px;
}

#testResults {
    font-family: 'Courier New', monospace;
    font-size: 12px;
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 4px;
    padding: 10px;
    max-height: 200px;
    overflow-y: auto;
}
</style>

@endsection

@push('scripts')
<script>
// Update array values when checkboxes change
document.addEventListener('DOMContentLoaded', function() {
    // Enabled products
    const enabledCheckboxes = document.querySelectorAll('input[name="enabled_products[]"]');
    enabledCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateEnabledProducts);
    });
    
    // Featured products
    const featuredCheckboxes = document.querySelectorAll('input[name="featured_products[]"]');
    featuredCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateFeaturedProducts);
    });
    
    // Boolean switches
    const booleanSwitches = document.querySelectorAll('.form-check-input[type="checkbox"]:not([name*="products"])');
    booleanSwitches.forEach(switchEl => {
        switchEl.addEventListener('change', function() {
            const label = this.nextElementSibling;
            label.textContent = this.checked ? 'Aktif' : 'Nonaktif';
        });
    });
});

function updateEnabledProducts() {
    const checkboxes = document.querySelectorAll('input[name="enabled_products[]"]:checked');
    const values = Array.from(checkboxes).map(cb => cb.value);
    const hiddenInput = document.getElementById('enabled_products_value');
    if (hiddenInput) {
        hiddenInput.value = JSON.stringify(values);
    }
}

function updateFeaturedProducts() {
    const checkboxes = document.querySelectorAll('input[name="featured_products[]"]:checked');
    const values = Array.from(checkboxes).map(cb => cb.value);
    const hiddenInput = document.getElementById('featured_products_value');
    if (hiddenInput) {
        hiddenInput.value = JSON.stringify(values);
    }
}

function saveAllSettings() {
    // Update array values before submitting
    updateEnabledProducts();
    updateFeaturedProducts();
    
    // Show loading
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Menyimpan...';
    btn.disabled = true;
    
    // Submit form
    document.getElementById('ppobSettingsForm').submit();
}

function resetToDefault() {
    if (confirm('Reset semua pengaturan ke default? Perubahan yang belum disimpan akan hilang.')) {
        location.reload();
    }
}

function createDefaultSettings() {
    if (confirm('Buat pengaturan default untuk PPOB?')) {
        const btn = event.target;
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Membuat...';
        btn.disabled = true;
        
        // Just reload the page, the controller will create default settings
        location.reload();
    }
}

function testOttopayConnection() {
    const resultsDiv = document.getElementById('testResults');
    resultsDiv.innerHTML = '<div class="text-info">Testing OttoPay connection...</div>';
    
    fetch('{{ route("admin.pengaturan.test-ottopay") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            resultsDiv.innerHTML = `
                <div class="text-success">✓ Koneksi OttoPay berhasil</div>
                <pre class="mt-2">${JSON.stringify(data.data, null, 2)}</pre>
            `;
        } else {
            resultsDiv.innerHTML = `
                <div class="text-danger">✗ Koneksi gagal: ${data.message}</div>
            `;
        }
    })
    .catch(error => {
        resultsDiv.innerHTML = `
            <div class="text-danger">✗ Error: ${error.message}</div>
        `;
    });
}

function testPpobProducts() {
    const resultsDiv = document.getElementById('testResults');
    resultsDiv.innerHTML = '<div class="text-info">Loading PPOB products...</div>';
    
    fetch('/ppob/api/products/pulsa', {
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            resultsDiv.innerHTML = `
                <div class="text-success">✓ Products loaded successfully</div>
                <div class="mt-2">Found ${data.data.length} products</div>
                <pre class="mt-2">${JSON.stringify(data.data.slice(0, 3), null, 2)}...</pre>
            `;
        } else {
            resultsDiv.innerHTML = `
                <div class="text-danger">✗ Failed to load products: ${data.message}</div>
            `;
        }
    })
    .catch(error => {
        resultsDiv.innerHTML = `
            <div class="text-danger">✗ Error: ${error.message}</div>
        `;
    });
}
</script>
@endpush