@extends('layouts.app')

@section('title', 'Edit Produk UMKM')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Produk UMKM</h1>
        <a href="{{ route('admin.produk-umkm.show', $produk->id) }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <form action="{{ route('admin.produk-umkm.update', $produk->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        
        <div class="row">
            <!-- Main Form -->
            <div class="col-lg-8">
                <!-- Basic Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Produk</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_produk">Nama Produk <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('nama_produk') is-invalid @enderror" 
                                           id="nama_produk" name="nama_produk" value="{{ old('nama_produk', $produk->nama_produk) }}" required>
                                    @error('nama_produk')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kategori">Kategori <span class="text-danger">*</span></label>
                                    <select class="form-control @error('kategori') is-invalid @enderror" 
                                            id="kategori" name="kategori" required>
                                        <option value="">Pilih Kategori</option>
                                        <option value="makanan" {{ old('kategori', $produk->kategori) == 'makanan' ? 'selected' : '' }}>Makanan</option>
                                        <option value="minuman" {{ old('kategori', $produk->kategori) == 'minuman' ? 'selected' : '' }}>Minuman</option>
                                        <option value="kerajinan" {{ old('kategori', $produk->kategori) == 'kerajinan' ? 'selected' : '' }}>Kerajinan</option>
                                        <option value="fashion" {{ old('kategori', $produk->kategori) == 'fashion' ? 'selected' : '' }}>Fashion</option>
                                        <option value="pertanian" {{ old('kategori', $produk->kategori) == 'pertanian' ? 'selected' : '' }}>Pertanian</option>
                                        <option value="jasa" {{ old('kategori', $produk->kategori) == 'jasa' ? 'selected' : '' }}>Jasa</option>
                                        <option value="lainnya" {{ old('kategori', $produk->kategori) == 'lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('kategori')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="deskripsi">Deskripsi Produk <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                      id="deskripsi" name="deskripsi" rows="4" required>{{ old('deskripsi', $produk->deskripsi) }}</textarea>
                            @error('deskripsi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="harga">Harga (Rp) <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control @error('harga') is-invalid @enderror" 
                                           id="harga" name="harga" value="{{ old('harga', $produk->harga) }}" required min="0">
                                    @error('harga')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="stok">Stok <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control @error('stok') is-invalid @enderror" 
                                           id="stok" name="stok" value="{{ old('stok', $produk->stok) }}" required min="0">
                                    @error('stok')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="berat">Berat (gram)</label>
                                    <input type="number" class="form-control @error('berat') is-invalid @enderror" 
                                           id="berat" name="berat" value="{{ old('berat', $produk->berat) }}" min="0">
                                    @error('berat')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kondisi">Kondisi</label>
                                    <select class="form-control @error('kondisi') is-invalid @enderror" 
                                            id="kondisi" name="kondisi">
                                        <option value="baru" {{ old('kondisi', $produk->kondisi) == 'baru' ? 'selected' : '' }}>Baru</option>
                                        <option value="bekas" {{ old('kondisi', $produk->kondisi) == 'bekas' ? 'selected' : '' }}>Bekas</option>
                                    </select>
                                    @error('kondisi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="minimal_order">Minimal Order</label>
                                    <input type="number" class="form-control @error('minimal_order') is-invalid @enderror" 
                                           id="minimal_order" name="minimal_order" 
                                           value="{{ old('minimal_order', $produk->minimal_order) }}" min="1">
                                    @error('minimal_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="waktu_produksi">Waktu Produksi</label>
                            <input type="text" class="form-control @error('waktu_produksi') is-invalid @enderror" 
                                   id="waktu_produksi" name="waktu_produksi" 
                                   value="{{ old('waktu_produksi', $produk->waktu_produksi) }}"
                                   placeholder="Contoh: 1-2 hari kerja">
                            @error('waktu_produksi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Varian Produk -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Varian Produk</h6>
                    </div>
                    <div class="card-body">
                        <div id="varian-container">
                            @php
                                $varian = old('varian', $produk->varian ? (is_array($produk->varian) ? $produk->varian : json_decode($produk->varian, true)) : []);
                            @endphp
                            @if($varian && count($varian) > 0)
                                @foreach($varian as $index => $item)
                                    <div class="row mb-2 varian-item">
                                        <div class="col-md-4">
                                            <input type="text" class="form-control" name="varian[{{ $index }}][nama]" 
                                                   value="{{ $item['nama'] ?? '' }}" placeholder="Nama varian">
                                        </div>
                                        <div class="col-md-3">
                                            <input type="number" class="form-control" name="varian[{{ $index }}][harga]" 
                                                   value="{{ $item['harga'] ?? '' }}" placeholder="Harga" min="0">
                                        </div>
                                        <div class="col-md-3">
                                            <input type="number" class="form-control" name="varian[{{ $index }}][stok]" 
                                                   value="{{ $item['stok'] ?? '' }}" placeholder="Stok" min="0">
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-danger btn-sm btn-remove-varian">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        <button type="button" class="btn btn-success btn-sm mt-2" id="btn-add-varian">
                            <i class="fas fa-plus"></i> Tambah Varian
                        </button>
                    </div>
                </div>

                <!-- Tags -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Tags</h6>
                    </div>
                    <div class="card-body">
                        <div id="tags-container">
                            @php
                                $tags = old('tags', $produk->tags ? (is_array($produk->tags) ? $produk->tags : json_decode($produk->tags, true)) : []);
                            @endphp
                            @if($tags && count($tags) > 0)
                                @foreach($tags as $tag)
                                    <div class="input-group mb-2 tag-item">
                                        <input type="text" class="form-control" name="tags[]" 
                                               value="{{ $tag }}" placeholder="Masukkan tag">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-danger btn-remove-tag">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="input-group mb-2 tag-item">
                                    <input type="text" class="form-control" name="tags[]" placeholder="Masukkan tag">
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-danger btn-remove-tag">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <button type="button" class="btn btn-success btn-sm mt-2" id="btn-add-tag">
                            <i class="fas fa-plus"></i> Tambah Tag
                        </button>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- UMKM Selection -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">UMKM</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="umkm_id">Pilih UMKM <span class="text-danger">*</span></label>
                            <select class="form-control @error('umkm_id') is-invalid @enderror" 
                                    id="umkm_id" name="umkm_id" required>
                                <option value="">Pilih UMKM</option>
                                @foreach($umkmList as $umkm)
                                    <option value="{{ $umkm->id }}" {{ old('umkm_id', $produk->umkm_id) == $umkm->id ? 'selected' : '' }}>
                                        {{ $umkm->nama_umkm }}
                                    </option>
                                @endforeach
                            </select>
                            @error('umkm_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Photos -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Foto Produk</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="foto_utama">Foto Utama</label>
                            <input type="file" class="form-control-file @error('foto_utama') is-invalid @enderror" 
                                   id="foto_utama" name="foto_utama" accept="image/*">
                            <small class="text-muted">Format: JPG, PNG, WebP. Maksimal 2MB</small>
                            @error('foto_utama')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            
                            @if($produk->foto_utama)
                                <div class="mt-2">
                                    <label class="small text-muted">Foto saat ini:</label><br>
                                    <img src="{{ $produk->foto_utama_url }}" 
                                         alt="Current Photo" 
                                         class="img-thumbnail"
                                         style="max-width: 150px;">
                                </div>
                            @endif
                        </div>

                        <div class="form-group">
                            <label for="galeri_foto">Galeri Foto</label>
                            <input type="file" class="form-control-file @error('galeri_foto') is-invalid @enderror" 
                                   id="galeri_foto" name="galeri_foto[]" accept="image/*" multiple>
                            <small class="text-muted">Pilih beberapa foto sekaligus. Maksimal 5 foto</small>
                            @error('galeri_foto')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror

                            @if($produk->galeri_foto)
                                @php
                                    $galeri = is_array($produk->galeri_foto) ? $produk->galeri_foto : json_decode($produk->galeri_foto, true);
                                @endphp
                                @if($galeri && count($galeri) > 0)
                                    <div class="mt-2">
                                        <label class="small text-muted">Galeri saat ini:</label>
                                        <div class="row">
                                            @foreach($galeri as $foto)
                                                <div class="col-6 mb-2">
                                                    <img src="{{ \App\Helpers\SharedHostingHelper::getFileUrl('produk/galeri/' . $foto) }}" 
                                                         alt="Gallery" 
                                                         class="img-thumbnail"
                                                         style="width: 100%; height: 80px; object-fit: cover;">
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Status -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Status</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="status">Status Produk</label>
                            <select class="form-control @error('status') is-invalid @enderror" 
                                    id="status" name="status">
                                <option value="aktif" {{ old('status', $produk->status) == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="nonaktif" {{ old('status', $produk->status) == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                <option value="pending" {{ old('status', $produk->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Produk
                            </button>
                            <a href="{{ route('admin.produk-umkm.show', $produk->id) }}" 
                               class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    let varianIndex = {{ count($varian ?? []) }};

    // Add new varian
    $('#btn-add-varian').click(function() {
        var newItem = `
            <div class="row mb-2 varian-item">
                <div class="col-md-4">
                    <input type="text" class="form-control" name="varian[${varianIndex}][nama]" placeholder="Nama varian">
                </div>
                <div class="col-md-3">
                    <input type="number" class="form-control" name="varian[${varianIndex}][harga]" placeholder="Harga" min="0">
                </div>
                <div class="col-md-3">
                    <input type="number" class="form-control" name="varian[${varianIndex}][stok]" placeholder="Stok" min="0">
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-danger btn-sm btn-remove-varian">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        $('#varian-container').append(newItem);
        varianIndex++;
    });

    // Remove varian
    $(document).on('click', '.btn-remove-varian', function() {
        if ($('.varian-item').length > 1) {
            $(this).closest('.varian-item').remove();
        }
    });

    // Add new tag
    $('#btn-add-tag').click(function() {
        var newItem = `
            <div class="input-group mb-2 tag-item">
                <input type="text" class="form-control" name="tags[]" placeholder="Masukkan tag">
                <div class="input-group-append">
                    <button type="button" class="btn btn-danger btn-remove-tag">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        $('#tags-container').append(newItem);
    });

    // Remove tag
    $(document).on('click', '.btn-remove-tag', function() {
        if ($('.tag-item').length > 1) {
            $(this).closest('.tag-item').remove();
        }
    });
});
</script>
@endpush 
