@extends('layouts.app')

@section('title', 'Role Management')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-user-shield me-2 text-primary"></i>Role Management
            </h2>
            <p class="text-muted mb-0">Kelola peran dan hak akses pengguna</p>
        </div>
        <div>
            <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Tambah Role
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="rolesTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Role</th>
                            <th>Display Name</th>
                            <th>Deskripsi</th>
                            <th>Jumlah User</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($roles ?? [] as $role)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                <span class="badge bg-secondary">{{ $role->name }}</span>
                            </td>
                            <td class="fw-bold">{{ $role->display_name }}</td>
                            <td>{{ Str::limit($role->description, 50) }}</td>
                            <td>
                                <span class="badge bg-info">{{ $role->users_count }} User</span>
                            </td>
                            <td>
                                @if($role->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-danger">Non-aktif</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.roles.show', $role->id) }}" 
                                       class="btn btn-sm btn-outline-info" title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.roles.edit', $role->id) }}" 
                                       class="btn btn-sm btn-outline-warning" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" 
                                            onclick="toggleStatus({{ $role->id }})" title="Toggle Status">
                                        <i class="fas fa-toggle-{{ $role->is_active ? 'on' : 'off' }}"></i>
                                    </button>
                                    @if($role->users_count == 0)
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="deleteRole({{ $role->id }})" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#rolesTable').DataTable({
        responsive: true,
        language: {
            url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json'
        }
    });
});

function toggleStatus(roleId) {
    fetch(`/admin/roles/${roleId}/toggle-status`, {
        method: 'PUT',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Status role berhasil diubah', 'success');
            location.reload();
        } else {
            showToast(data.message || 'Gagal mengubah status', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
}

function deleteRole(roleId) {
    if (confirm('Apakah Anda yakin ingin menghapus role ini?')) {
        fetch(`/admin/roles/${roleId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Role berhasil dihapus', 'success');
                location.reload();
            } else {
                showToast(data.message || 'Gagal menghapus role', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        });
    }
}
</script>
@endpush 
