@extends('layouts.app')

@section('title', 'Pengaturan Desa')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-cog me-2 text-primary"></i>Pengaturan Desa
            </h2>
            <p class="text-muted mb-0">Kelola informasi dan konfigurasi desa</p>
        </div>
    </div>

    <form id="settingsForm" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        
        <div class="row">
            <div class="col-lg-8">
                <!-- Informasi Dasar -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-home me-2"></i>Informasi Dasar Desa</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required">Nama Desa</label>
                                    <input type="text" class="form-control" name="nama_desa" required
                                           value="{{ $setting->nama_desa ?? '' }}" placeholder="Nama Desa">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Kode Desa</label>
                                    <input type="text" class="form-control" name="kode_desa"
                                           value="{{ $setting->kode_desa ?? '' }}" placeholder="Kode Desa">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label required">Kecamatan</label>
                                    <input type="text" class="form-control" name="kecamatan" required
                                           value="{{ $setting->kecamatan ?? '' }}" placeholder="Kecamatan">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label required">Kabupaten</label>
                                    <input type="text" class="form-control" name="kabupaten" required
                                           value="{{ $setting->kabupaten ?? '' }}" placeholder="Kabupaten">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label required">Provinsi</label>
                                    <input type="text" class="form-control" name="provinsi" required
                                           value="{{ $setting->provinsi ?? '' }}" placeholder="Provinsi">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label class="form-label required">Alamat Kantor Desa</label>
                                    <textarea class="form-control" name="alamat_kantor" rows="3" required
                                              placeholder="Alamat lengkap kantor desa">{{ $setting->alamat_kantor ?? '' }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Kode Pos</label>
                                    <input type="text" class="form-control" name="kode_pos"
                                           value="{{ $setting->kode_pos ?? '' }}" placeholder="12345">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Kontak -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-phone me-2"></i>Informasi Kontak</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Telepon</label>
                                    <input type="text" class="form-control" name="telepon"
                                           value="{{ $setting->telepon ?? '' }}" placeholder="(021) 1234567">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email"
                                           value="{{ $setting->email ?? '' }}" placeholder="desa@example.com">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Website</label>
                                    <input type="url" class="form-control" name="website"
                                           value="{{ $setting->website ?? '' }}" placeholder="https://desa.example.com">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Pejabat -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-user-tie me-2"></i>Pejabat Desa</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Informasi:</strong> Data perangkat desa sekarang dikelola di fitur 
                            <a href="{{ route('admin.perangkat-desa.index') }}" class="alert-link">Perangkat Desa</a>. 
                            Data di bawah ini hanya sebagai fallback jika belum ada data di fitur perangkat desa.
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Kepala Desa (Fallback)</label>
                                    <input type="text" class="form-control" name="kepala_desa"
                                           value="{{ $setting->kepala_desa ?? '' }}" placeholder="Nama Kepala Desa">
                                    <small class="form-text text-muted">Akan digunakan jika belum ada data di fitur Perangkat Desa</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">NIP Kepala Desa (Fallback)</label>
                                    <input type="text" class="form-control" name="nip_kepala_desa"
                                           value="{{ $setting->nip_kepala_desa ?? '' }}" placeholder="NIP Kepala Desa">
                                    <small class="form-text text-muted">Akan digunakan jika belum ada data di fitur Perangkat Desa</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Sekretaris Desa (Fallback)</label>
                                    <input type="text" class="form-control" name="sekretaris_desa"
                                           value="{{ $setting->sekretaris_desa ?? '' }}" placeholder="Nama Sekretaris Desa">
                                    <small class="form-text text-muted">Akan digunakan jika belum ada data di fitur Perangkat Desa</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">NIP Sekretaris (Fallback)</label>
                                    <input type="text" class="form-control" name="nip_sekretaris"
                                           value="{{ $setting->nip_sekretaris ?? '' }}" placeholder="NIP Sekretaris Desa">
                                    <small class="form-text text-muted">Akan digunakan jika belum ada data di fitur Perangkat Desa</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Visi Misi -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-bullseye me-2"></i>Visi & Misi</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Visi</label>
                            <textarea class="form-control" name="visi" rows="3"
                                      placeholder="Tuliskan visi desa...">{{ $setting->visi ?? '' }}</textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Misi</label>
                            <textarea class="form-control" name="misi" rows="5"
                                      placeholder="Tuliskan misi desa...">{{ $setting->misi ?? '' }}</textarea>
                        </div>
                    </div>
                </div>
                
                <!-- Sejarah -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-history me-2"></i>Sejarah Desa</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Sejarah Desa</label>
                            <textarea class="form-control" name="sejarah_desa" rows="6"
                                      placeholder="Tuliskan sejarah singkat desa...">{{ $setting->sejarah_desa ?? '' }}</textarea>
                        </div>
                    </div>
                </div>
                
                <!-- Konfigurasi Payment Gateway -->
                <div class="row mt-4">
                    <!-- Konfigurasi Tripay -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h6 class="mb-0"><i class="fas fa-credit-card me-2"></i>Konfigurasi Tripay</h6>
                                <button type="button" class="btn btn-sm btn-outline-primary" onclick="testTripayConnection()">
                                    <i class="fas fa-wifi me-1"></i>Test
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">API Key</label>
                                    <input type="password" class="form-control form-control-sm" name="tripay_api_key" 
                                           value="{{ $setting->tripay_api_key ?? '' }}"
                                           placeholder="Masukkan API Key Tripay">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Private Key</label>
                                    <input type="password" class="form-control form-control-sm" name="tripay_private_key" 
                                           value="{{ $setting->tripay_private_key ?? '' }}"
                                           placeholder="Masukkan Private Key Tripay">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Merchant Code</label>
                                    <input type="text" class="form-control form-control-sm" name="tripay_merchant_code" 
                                           value="{{ $setting->tripay_merchant_code ?? '' }}"
                                           placeholder="Masukkan Merchant Code Tripay">
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label">Mode</label>
                                            <select class="form-control form-control-sm" name="tripay_mode">
                                                <option value="sandbox" {{ ($setting->tripay_mode ?? 'sandbox') == 'sandbox' ? 'selected' : '' }}>Sandbox</option>
                                                <option value="production" {{ ($setting->tripay_mode ?? 'sandbox') == 'production' ? 'selected' : '' }}>Production</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label">Expire (jam)</label>
                                            <input type="number" class="form-control form-control-sm" name="tripay_expiry_time" 
                                                   value="{{ $setting->tripay_expiry_time ?? 24 }}" min="1" max="168">
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Biaya Ditanggung</label>
                                    <select class="form-control form-control-sm" name="tripay_fee_customer">
                                        <option value="0" {{ ($setting->tripay_fee_customer ?? false) ? '' : 'selected' }}>Merchant</option>
                                        <option value="1" {{ ($setting->tripay_fee_customer ?? false) ? 'selected' : '' }}>Customer</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Metode Pembayaran</label>
                                    @php
                                        $tripayChannels = $setting->tripay_channels ?? ['BRIVA', 'BCAVA', 'BNIVA', 'OVO', 'DANA'];
                                    @endphp
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="tripay_channels[]" 
                                                       value="BRIVA" id="tripay_briva" {{ in_array('BRIVA', $tripayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="tripay_briva">BRI VA</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="tripay_channels[]" 
                                                       value="BCAVA" id="tripay_bcava" {{ in_array('BCAVA', $tripayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="tripay_bcava">BCA VA</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="tripay_channels[]" 
                                                       value="BNIVA" id="tripay_bniva" {{ in_array('BNIVA', $tripayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="tripay_bniva">BNI VA</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="tripay_channels[]" 
                                                       value="OVO" id="tripay_ovo" {{ in_array('OVO', $tripayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="tripay_ovo">OVO</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="tripay_channels[]" 
                                                       value="DANA" id="tripay_dana" {{ in_array('DANA', $tripayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="tripay_dana">DANA</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="tripay_channels[]" 
                                                       value="SHOPEEPAY" id="tripay_shopee" {{ in_array('SHOPEEPAY', $tripayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="tripay_shopee">ShopeePay</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="alert alert-info alert-sm">
                                    <small>
                                        <strong>Biaya:</strong><br>
                                        • VA: Rp 4.000-5.000<br>
                                        • E-Wallet: 2-2.5%
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Konfigurasi OttoPay -->
                    <div class="col-md-6">
                        <div class="card h-100">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h6 class="mb-0"><i class="fas fa-credit-card me-2"></i>Konfigurasi OttoPay</h6>
                                <button type="button" class="btn btn-sm btn-outline-primary" onclick="testOttopayConnection()">
                                    <i class="fas fa-wifi me-1"></i>Test
                                </button>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">API Key</label>
                                    <input type="password" class="form-control form-control-sm" name="ottopay_api_key" 
                                           value="{{ $setting->ottopay_api_key ?? '' }}"
                                           placeholder="Masukkan API Key OttoPay">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Secret Key</label>
                                    <input type="password" class="form-control form-control-sm" name="ottopay_secret_key" 
                                           value="{{ $setting->ottopay_secret_key ?? '' }}"
                                           placeholder="Masukkan Secret Key OttoPay">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Merchant Code</label>
                                    <input type="text" class="form-control form-control-sm" name="ottopay_merchant_code" 
                                           value="{{ $setting->ottopay_merchant_code ?? '' }}"
                                           placeholder="Masukkan Merchant Code OttoPay">
                                </div>
                                <div class="row">
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label">Mode</label>
                                            <select class="form-control form-control-sm" name="ottopay_mode">
                                                <option value="sandbox" {{ ($setting->ottopay_mode ?? 'sandbox') == 'sandbox' ? 'selected' : '' }}>Sandbox</option>
                                                <option value="production" {{ ($setting->ottopay_mode ?? 'sandbox') == 'production' ? 'selected' : '' }}>Production</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label">Expire (jam)</label>
                                            <input type="number" class="form-control form-control-sm" name="ottopay_expiry_time" 
                                                   value="{{ $setting->ottopay_expiry_time ?? 24 }}" min="1" max="168">
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Biaya Ditanggung</label>
                                    <select class="form-control form-control-sm" name="ottopay_fee_customer">
                                        <option value="0" {{ ($setting->ottopay_fee_customer ?? false) ? '' : 'selected' }}>Merchant</option>
                                        <option value="1" {{ ($setting->ottopay_fee_customer ?? false) ? 'selected' : '' }}>Customer</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Metode Pembayaran</label>
                                    @php
                                        $ottopayChannels = $setting->ottopay_channels ?? ['VA', 'QRIS', 'EWALLET'];
                                    @endphp
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="ottopay_channels[]" 
                                                       value="VA" id="ottopay_va" {{ in_array('VA', $ottopayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="ottopay_va">Virtual Account</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="ottopay_channels[]" 
                                                       value="QRIS" id="ottopay_qris" {{ in_array('QRIS', $ottopayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="ottopay_qris">QRIS</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="ottopay_channels[]" 
                                                       value="EWALLET" id="ottopay_ewallet" {{ in_array('EWALLET', $ottopayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="ottopay_ewallet">E-Wallet</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-check form-check-sm">
                                                <input class="form-check-input" type="checkbox" name="ottopay_channels[]" 
                                                       value="CREDIT_CARD" id="ottopay_cc" {{ in_array('CREDIT_CARD', $ottopayChannels) ? 'checked' : '' }}>
                                                <label class="form-check-label small" for="ottopay_cc">Kartu Kredit</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="alert alert-info alert-sm">
                                    <small>
                                        <strong>Biaya:</strong><br>
                                        • VA: Rp 4.000<br>
                                        • QRIS: 0.7%<br>
                                        • E-Wallet: 2%<br>
                                        • Kartu Kredit: 2.9%
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                

            </div>
            
            <div class="col-lg-4">
                <!-- Logo Desa -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-image me-2"></i>Logo Desa</h6>
                    </div>
                    <div class="card-body text-center">
                        <div class="mb-3">
                            @if($setting->logo ?? false)
                            <img src="{{ Storage::url($setting->logo) }}" alt="Logo Desa" 
                                 class="img-fluid rounded" style="max-height: 200px;" id="logoPreview">
                            @else
                            <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                 style="height: 200px;" id="logoPlaceholder">
                                <div class="text-center text-muted">
                                    <i class="fas fa-image fa-3x mb-2"></i>
                                    <p>Belum ada logo</p>
                                </div>
                            </div>
                            @endif
                        </div>
                        
                        <input type="file" class="form-control" name="logo" accept="image/*" id="logoInput">
                        <small class="text-muted">Format: JPG, PNG. Maksimal 2MB</small>
                        
                        @if($setting->logo ?? false)
                        <div class="mt-2">
                            <button type="button" class="btn btn-sm btn-danger" onclick="deleteLogo()">
                                <i class="fas fa-trash me-1"></i>Hapus Logo
                            </button>
                        </div>
                        @endif
                    </div>
                </div>
                
                <!-- Statistik Wilayah -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-chart-bar me-2"></i>Data Wilayah</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label class="form-label">Luas Wilayah (km²)</label>
                                    <input type="number" class="form-control" name="luas_wilayah" step="0.01"
                                           value="{{ $setting->luas_wilayah ?? '' }}" placeholder="0.00">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah Dusun</label>
                                    <input type="number" class="form-control" name="jumlah_dusun"
                                           value="{{ $setting->jumlah_dusun ?? '' }}" placeholder="0">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah RT</label>
                                    <input type="number" class="form-control" name="jumlah_rt"
                                           value="{{ $setting->jumlah_rt ?? '' }}" placeholder="0">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah RW</label>
                                    <input type="number" class="form-control" name="jumlah_rw"
                                           value="{{ $setting->jumlah_rw ?? '' }}" placeholder="0">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-6">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah Penduduk</label>
                                    <input type="number" class="form-control" name="jumlah_penduduk"
                                           value="{{ $setting->jumlah_penduduk ?? '' }}" placeholder="0">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah KK</label>
                                    <input type="number" class="form-control" name="jumlah_kk"
                                           value="{{ $setting->jumlah_kk ?? '' }}" placeholder="0">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Koordinat -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-map-marker-alt me-2"></i>Koordinat Desa</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Latitude</label>
                            <input type="number" class="form-control" name="latitude" step="0.00000001"
                                   value="{{ $setting->latitude ?? '' }}" placeholder="-6.200000">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Longitude</label>
                            <input type="number" class="form-control" name="longitude" step="0.00000001"
                                   value="{{ $setting->longitude ?? '' }}" placeholder="106.816666">
                        </div>
                        
                        <button type="button" class="btn btn-sm btn-outline-primary" onclick="getCurrentLocation()">
                            <i class="fas fa-location-arrow me-1"></i>Dapatkan Lokasi Saat Ini
                        </button>
                    </div>
                </div>
                
                <!-- Actions -->
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan Pengaturan
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('styles')
<style>
.required::after {
    content: ' *';
    color: #dc3545;
}
</style>
@endpush

@push('scripts')
<script>
document.getElementById('settingsForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    showLoading();
    
    fetch('{{ route("admin.pengaturan.update") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Pengaturan berhasil disimpan', 'success');
        } else {
            showToast(data.message || 'Gagal menyimpan pengaturan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});

// Logo preview
document.getElementById('logoInput').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            const placeholder = document.getElementById('logoPlaceholder');
            const preview = document.getElementById('logoPreview');
            
            if (placeholder) {
                placeholder.style.display = 'none';
            }
            
            if (preview) {
                preview.src = e.target.result;
                preview.style.display = 'block';
            } else {
                const newPreview = document.createElement('img');
                newPreview.src = e.target.result;
                newPreview.alt = 'Logo Desa';
                newPreview.className = 'img-fluid rounded';
                newPreview.style.maxHeight = '200px';
                newPreview.id = 'logoPreview';
                
                if (placeholder) {
                    placeholder.parentNode.insertBefore(newPreview, placeholder);
                }
            }
        };
        reader.readAsDataURL(file);
    }
});

function deleteLogo() {
    if (confirm('Apakah Anda yakin ingin menghapus logo?')) {
        fetch('{{ route("admin.pengaturan.delete-logo") }}', {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Logo berhasil dihapus', 'success');
                location.reload();
            } else {
                showToast(data.message || 'Gagal menghapus logo', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        });
    }
}

function getCurrentLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            document.querySelector('input[name="latitude"]').value = position.coords.latitude;
            document.querySelector('input[name="longitude"]').value = position.coords.longitude;
            showToast('Koordinat berhasil diperbarui', 'success');
        }, function(error) {
            showToast('Gagal mendapatkan lokasi', 'error');
        });
    } else {
        showToast('Browser tidak mendukung geolocation', 'error');
    }
}

// Test Tripay Connection
function testTripayConnection() {
    const apiKey = document.querySelector('input[name="tripay_api_key"]').value;
    const privateKey = document.querySelector('input[name="tripay_private_key"]').value;
    const merchantCode = document.querySelector('input[name="tripay_merchant_code"]').value;
    const mode = document.querySelector('select[name="tripay_mode"]').value;
    
    if (!apiKey || !privateKey || !merchantCode) {
        showToast('Mohon lengkapi API Key, Private Key, dan Merchant Code terlebih dahulu', 'warning');
        return;
    }
    
    showLoading();
    
    fetch('{{ route("admin.pengaturan.test-tripay") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            api_key: apiKey,
            private_key: privateKey,
            merchant_code: merchantCode,
            mode: mode
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Koneksi Tripay berhasil! ' + data.message, 'success');
        } else {
            showToast('Koneksi Tripay gagal: ' + (data.message || 'Unknown error'), 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan saat test koneksi', 'error');
    })
    .finally(() => {
        hideLoading();
    });
}

// Test OttoPay Connection
function testOttopayConnection() {
    const apiKey = document.querySelector('input[name="ottopay_api_key"]').value;
    const secretKey = document.querySelector('input[name="ottopay_secret_key"]').value;
    const merchantCode = document.querySelector('input[name="ottopay_merchant_code"]').value;
    const mode = document.querySelector('select[name="ottopay_mode"]').value;
    
    if (!apiKey || !secretKey || !merchantCode) {
        showToast('Mohon lengkapi API Key, Secret Key, dan Merchant Code terlebih dahulu', 'warning');
        return;
    }
    
    showLoading();
    
    fetch('{{ route("admin.pengaturan.test-ottopay") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            api_key: apiKey,
            secret_key: secretKey,
            merchant_code: merchantCode,
            mode: mode
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Koneksi OttoPay berhasil! ' + data.message, 'success');
        } else {
            showToast('Koneksi OttoPay gagal: ' + (data.message || 'Unknown error'), 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan saat test koneksi', 'error');
    })
    .finally(() => {
        hideLoading();
    });
}
</script>
@endpush 
