@extends('layouts.app')

@section('title', 'Tambah Struktur Organisasi')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">
                            <i class="fas fa-plus me-2"></i>
                            Tambah Struktur Organisasi
                        </h3>
                        <a href="{{ route('admin.struktur-organisasi.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i>
                            Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.struktur-organisasi.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <!-- Kategori Lembaga -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="kategori_lembaga" class="form-label">Kategori Lembaga <span class="text-danger">*</span></label>
                                    <select class="form-select @error('kategori_lembaga') is-invalid @enderror" 
                                            name="kategori_lembaga" id="kategori_lembaga" required>
                                        <option value="">Pilih Kategori Lembaga</option>
                                        @foreach($kategoriOptions as $key => $value)
                                            <option value="{{ $key }}" {{ old('kategori_lembaga') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('kategori_lembaga')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Nama Lembaga -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nama_lembaga" class="form-label">Nama Lembaga <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('nama_lembaga') is-invalid @enderror" 
                                           id="nama_lembaga" 
                                           name="nama_lembaga" 
                                           value="{{ old('nama_lembaga') }}" 
                                           required>
                                    @error('nama_lembaga')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Nama Pengurus -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nama_pengurus" class="form-label">Nama Pengurus <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('nama_pengurus') is-invalid @enderror" 
                                           id="nama_pengurus" 
                                           name="nama_pengurus" 
                                           value="{{ old('nama_pengurus') }}" 
                                           required>
                                    @error('nama_pengurus')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Jabatan -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="jabatan" class="form-label">Jabatan <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('jabatan') is-invalid @enderror" 
                                           id="jabatan" 
                                           name="jabatan" 
                                           value="{{ old('jabatan') }}" 
                                           required>
                                    @error('jabatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- NIK -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nik" class="form-label">NIK</label>
                                    <input type="text" 
                                           class="form-control @error('nik') is-invalid @enderror" 
                                           id="nik" 
                                           name="nik" 
                                           value="{{ old('nik') }}" 
                                           maxlength="16"
                                           pattern="[0-9]{16}"
                                           title="NIK harus 16 digit angka">
                                    @error('nik')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Jenis Kelamin -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                                    <select class="form-select @error('jenis_kelamin') is-invalid @enderror" 
                                            name="jenis_kelamin" id="jenis_kelamin">
                                        <option value="">Pilih Jenis Kelamin</option>
                                        @foreach($jenisKelaminOptions as $key => $value)
                                            <option value="{{ $key }}" {{ old('jenis_kelamin') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('jenis_kelamin')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Tempat Lahir -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tempat_lahir" class="form-label">Tempat Lahir</label>
                                    <input type="text" 
                                           class="form-control @error('tempat_lahir') is-invalid @enderror" 
                                           id="tempat_lahir" 
                                           name="tempat_lahir" 
                                           value="{{ old('tempat_lahir') }}">
                                    @error('tempat_lahir')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Tanggal Lahir -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                                    <input type="date" 
                                           class="form-control @error('tanggal_lahir') is-invalid @enderror" 
                                           id="tanggal_lahir" 
                                           name="tanggal_lahir" 
                                           value="{{ old('tanggal_lahir') }}">
                                    @error('tanggal_lahir')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Pendidikan -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="pendidikan" class="form-label">Pendidikan</label>
                                    <select class="form-select @error('pendidikan') is-invalid @enderror" 
                                            name="pendidikan" id="pendidikan">
                                        <option value="">Pilih Pendidikan</option>
                                        @foreach($pendidikanOptions as $key => $value)
                                            <option value="{{ $key }}" {{ old('pendidikan') == $key ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('pendidikan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Pekerjaan -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="pekerjaan" class="form-label">Pekerjaan</label>
                                    <input type="text" 
                                           class="form-control @error('pekerjaan') is-invalid @enderror" 
                                           id="pekerjaan" 
                                           name="pekerjaan" 
                                           value="{{ old('pekerjaan') }}">
                                    @error('pekerjaan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Nomor HP -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nomor_hp" class="form-label">Nomor HP</label>
                                    <input type="text" 
                                           class="form-control @error('nomor_hp') is-invalid @enderror" 
                                           id="nomor_hp" 
                                           name="nomor_hp" 
                                           value="{{ old('nomor_hp') }}" 
                                           maxlength="15">
                                    @error('nomor_hp')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" 
                                           class="form-control @error('email') is-invalid @enderror" 
                                           id="email" 
                                           name="email" 
                                           value="{{ old('email') }}">
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Tanggal Mulai Jabatan -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_mulai_jabatan" class="form-label">Tanggal Mulai Jabatan <span class="text-danger">*</span></label>
                                    <input type="date" 
                                           class="form-control @error('tanggal_mulai_jabatan') is-invalid @enderror" 
                                           id="tanggal_mulai_jabatan" 
                                           name="tanggal_mulai_jabatan" 
                                           value="{{ old('tanggal_mulai_jabatan') }}" 
                                           required>
                                    @error('tanggal_mulai_jabatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Tanggal Selesai Jabatan -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_selesai_jabatan" class="form-label">Tanggal Selesai Jabatan</label>
                                    <input type="date" 
                                           class="form-control @error('tanggal_selesai_jabatan') is-invalid @enderror" 
                                           id="tanggal_selesai_jabatan" 
                                           name="tanggal_selesai_jabatan" 
                                           value="{{ old('tanggal_selesai_jabatan') }}">
                                    @error('tanggal_selesai_jabatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Urutan Tampil -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="urutan_tampil" class="form-label">Urutan Tampil</label>
                                    <input type="number" 
                                           class="form-control @error('urutan_tampil') is-invalid @enderror" 
                                           id="urutan_tampil" 
                                           name="urutan_tampil" 
                                           value="{{ old('urutan_tampil', 1) }}" 
                                           min="0">
                                    @error('urutan_tampil')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Foto -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="foto" class="form-label">Foto</label>
                                    <input type="file" 
                                           class="form-control @error('foto') is-invalid @enderror" 
                                           id="foto" 
                                           name="foto" 
                                           accept=".jpg,.jpeg,.png">
                                    <small class="text-muted">Format: JPG, JPEG, PNG (Max: 2MB)</small>
                                    @error('foto')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Alamat -->
                        <div class="mb-3">
                            <label for="alamat" class="form-label">Alamat</label>
                            <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                      id="alamat" 
                                      name="alamat" 
                                      rows="3">{{ old('alamat') }}</textarea>
                            @error('alamat')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex justify-content-end">
                            <a href="{{ route('admin.struktur-organisasi.index') }}" class="btn btn-secondary me-2">
                                <i class="fas fa-times me-1"></i>
                                Batal
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i>
                                Simpan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-generate nama lembaga based on kategori
    $('#kategori_lembaga').on('change', function() {
        const kategori = $(this).val();
        const namaLembaga = $('#nama_lembaga');
        
        const suggestions = {
            'perangkat_desa': 'Pemerintah Desa',
            'bpd': 'Badan Permusyawaratan Desa',
            'lpm': 'Lembaga Pemberdayaan Masyarakat',
            'karang_taruna': 'Karang Taruna',
            'pkk': 'Pemberdayaan Kesejahteraan Keluarga',
            'rt_rw': 'RT/RW',
            'tokoh_agama': 'Tokoh Agama',
            'tokoh_masyarakat': 'Tokoh Masyarakat'
        };
        
        if (suggestions[kategori] && !namaLembaga.val()) {
            namaLembaga.val(suggestions[kategori]);
        }
    });
    
    // NIK validation
    $('#nik').on('input', function() {
        let value = $(this).val();
        // Remove non-digit characters
        value = value.replace(/[^\d]/g, '');
        $(this).val(value);
        
        if (value.length > 0 && value.length !== 16) {
            $(this).addClass('is-invalid');
            if (!$(this).siblings('.invalid-feedback').length) {
                $(this).after('<div class="invalid-feedback">NIK harus 16 digit</div>');
            }
        } else {
            $(this).removeClass('is-invalid');
            $(this).siblings('.invalid-feedback').remove();
        }
    });
    
    // Phone number validation
    $('#nomor_hp').on('input', function() {
        let value = $(this).val();
        // Remove non-digit characters except + and -
        value = value.replace(/[^\d+-]/g, '');
        $(this).val(value);
    });
});
</script>
@endpush
