@extends('layouts.app')

@section('title', 'Template Surat')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Template Surat</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-file-contract me-2 text-primary"></i>
            Template Surat
        </h2>
        <p class="text-muted mb-0">Kelola template surat untuk mempercepat pembuatan dokumen</p>
    </div>
    <div>
        <a href="{{ route('admin.template-surat.create') }}" class="btn btn-gradient-primary">
            <i class="fas fa-plus me-2"></i>
            Tambah Template
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-primary me-3">
                    <i class="fas fa-file-contract"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $templates->total() }}</h4>
                    <small class="text-muted">Total Template</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $templates->where('aktif', true)->count() }}</h4>
                    <small class="text-muted">Template Aktif</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-warning me-3">
                    <i class="fas fa-pause-circle"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $templates->where('aktif', false)->count() }}</h4>
                    <small class="text-muted">Non-aktif</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-layer-group"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $templates->groupBy('jenis_surat')->count() }}</h4>
                    <small class="text-muted">Jenis Surat</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Pencarian</label>
                <form method="GET" action="{{ route('admin.template-surat.index') }}">
                    <div class="input-group">
                        <input type="text" class="form-control" name="search" 
                               placeholder="Cari template..." value="{{ request('search') }}">
                        <button class="btn btn-outline-secondary" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                    </div>
                    <input type="hidden" name="jenis_surat" value="{{ request('jenis_surat') }}">
                    <input type="hidden" name="aktif" value="{{ request('aktif') }}">
                </form>
            </div>
            <div class="col-md-3">
                <label class="form-label">Jenis Surat</label>
                <form method="GET" action="{{ route('admin.template-surat.index') }}">
                    <select name="jenis_surat" class="form-select" onchange="this.form.submit()">
                        <option value="">Semua Jenis</option>
                        <option value="Surat Keterangan" {{ request('jenis_surat') == 'Surat Keterangan' ? 'selected' : '' }}>Surat Keterangan</option>
                        <option value="Surat Pengantar" {{ request('jenis_surat') == 'Surat Pengantar' ? 'selected' : '' }}>Surat Pengantar</option>
                        <option value="Surat Izin" {{ request('jenis_surat') == 'Surat Izin' ? 'selected' : '' }}>Surat Izin</option>
                    </select>
                    <input type="hidden" name="search" value="{{ request('search') }}">
                    <input type="hidden" name="aktif" value="{{ request('aktif') }}">
                </form>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <form method="GET" action="{{ route('admin.template-surat.index') }}">
                    <select name="aktif" class="form-select" onchange="this.form.submit()">
                        <option value="">Semua Status</option>
                        <option value="1" {{ request('aktif') == '1' ? 'selected' : '' }}>Aktif</option>
                        <option value="0" {{ request('aktif') == '0' ? 'selected' : '' }}>Non-aktif</option>
                    </select>
                    <input type="hidden" name="search" value="{{ request('search') }}">
                    <input type="hidden" name="jenis_surat" value="{{ request('jenis_surat') }}">
                </form>
            </div>
            <div class="col-md-4">
                <label class="form-label">&nbsp;</label>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-success btn-sm" onclick="bulkActivate()">
                        <i class="fas fa-check me-1"></i> Aktifkan Terpilih
                    </button>
                    <button type="button" class="btn btn-warning btn-sm" onclick="bulkDeactivate()">
                        <i class="fas fa-times me-1"></i> Non-aktifkan Terpilih
                    </button>
                    <a href="{{ route('admin.template-surat.index') }}" class="btn btn-outline-secondary btn-sm">
                        <i class="fas fa-refresh me-1"></i> Reset
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Main Table -->
<div class="card">
    <div class="card-header bg-light">
        <h5 class="card-title mb-0">
            <i class="fas fa-table me-2"></i>
            Daftar Template Surat
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover table-striped">
                <thead class="table-light">
                    <tr>
                        <th width="3%">
                            <input type="checkbox" id="selectAll" class="form-check-input">
                        </th>
                        <th width="25%">Nama Template</th>
                        <th width="15%">Jenis Surat</th>
                        <th width="20%">Deskripsi</th>
                        <th width="10%" class="text-center">Status</th>
                        <th width="12%">Dibuat</th>
                        <th width="15%" class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($templates as $template)
                    <tr>
                        <td>
                            <input type="checkbox" class="form-check-input template-checkbox" value="{{ $template->id }}">
                        </td>
                        <td>
                            <div class="fw-semibold">{{ $template->nama_template }}</div>
                            @if($template->format_nomor)
                            <small class="text-muted">{{ $template->format_nomor }}</small>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-info">{{ $template->jenis_surat }}</span>
                        </td>
                        <td>
                            @if($template->deskripsi)
                                <span title="{{ $template->deskripsi }}">{{ Str::limit($template->deskripsi, 80) }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td class="text-center">
                            @if($template->aktif)
                                <span class="badge bg-success">Aktif</span>
                            @else
                                <span class="badge bg-secondary">Non-aktif</span>
                            @endif
                        </td>
                        <td>
                            <div class="fw-semibold">{{ $template->created_at->format('d/m/Y') }}</div>
                            <small class="text-muted">{{ $template->created_at->format('H:i') }}</small>
                        </td>
                        <td class="text-center">
                            <div class="btn-group" role="group">
                                <a href="{{ route('admin.template-surat.show', $template) }}" 
                                   class="btn btn-soft-info btn-sm" title="Lihat" data-bs-toggle="tooltip">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" class="btn btn-soft-secondary btn-sm" 
                                        onclick="previewTemplate({{ $template->id }})" title="Preview" data-bs-toggle="tooltip">
                                    <i class="fas fa-search"></i>
                                </button>
                                <a href="{{ route('admin.template-surat.edit', $template) }}" 
                                   class="btn btn-soft-warning btn-sm" title="Edit" data-bs-toggle="tooltip">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button type="button" class="btn btn-soft-success btn-sm" 
                                        onclick="duplicateTemplate({{ $template->id }})" title="Duplikasi" data-bs-toggle="tooltip">
                                    <i class="fas fa-copy"></i>
                                </button>
                                <button type="button" class="btn btn-soft-danger btn-sm" 
                                        onclick="deleteTemplate({{ $template->id }})" title="Hapus" data-bs-toggle="tooltip">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-4">
                            <div class="text-muted">
                                <i class="fas fa-file-contract fa-3x mb-3"></i>
                                <div>Tidak ada template ditemukan</div>
                                <small>Silakan tambah template baru</small>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($templates->hasPages())
        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-4">
            <div class="text-muted">
                Menampilkan {{ $templates->firstItem() ?? 0 }} sampai {{ $templates->lastItem() ?? 0 }} 
                dari {{ $templates->total() }} entri
            </div>
            <div>
                {{ $templates->appends(request()->query())->links() }}
            </div>
        </div>
        @endif
    </div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-search me-2"></i>
                    Preview Template
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="preview-content">
                    <div class="text-center">
                        <i class="fas fa-spinner fa-spin fa-2x mb-3"></i>
                        <div>Memuat preview...</div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Tutup
                </button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Initialize tooltips
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Select all checkbox
    const selectAllCheckbox = document.getElementById('selectAll');
    const templateCheckboxes = document.querySelectorAll('.template-checkbox');

    selectAllCheckbox.addEventListener('change', function() {
        templateCheckboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
    });

    // Individual checkbox change
    templateCheckboxes.forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            if (!this.checked) {
                selectAllCheckbox.checked = false;
            } else {
                // Check if all checkboxes are checked
                const allChecked = Array.from(templateCheckboxes).every(cb => cb.checked);
                selectAllCheckbox.checked = allChecked;
            }
        });
    });
});

function previewTemplate(id) {
    const modal = new bootstrap.Modal(document.getElementById('previewModal'));
    modal.show();
    
    // Reset content
    document.getElementById('preview-content').innerHTML = `
        <div class="text-center">
            <i class="fas fa-spinner fa-spin fa-2x mb-3"></i>
            <div>Memuat preview...</div>
        </div>
    `;
    
    // Load preview content
    fetch(`/admin/template-surat/${id}/preview`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json',
        }
    })
    .then(response => response.text())
    .then(html => {
        document.getElementById('preview-content').innerHTML = html;
    })
    .catch(error => {
        document.getElementById('preview-content').innerHTML = `
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Gagal memuat preview: ${error.message}
            </div>
        `;
    });
}

function duplicateTemplate(id) {
    if (confirm('Apakah Anda yakin ingin menduplikasi template ini?')) {
        fetch(`/admin/template-surat/${id}/duplicate`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                window.location.href = data.redirect;
            } else {
                alert('Gagal menduplikasi template');
            }
        })
        .catch(error => {
            alert('Terjadi kesalahan: ' + error.message);
        });
    }
}

function deleteTemplate(id) {
    if (confirm('Apakah Anda yakin ingin menghapus template ini? Tindakan ini tidak dapat dibatalkan.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/template-surat/${id}`;
        form.innerHTML = `
            <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').content}">
            <input type="hidden" name="_method" value="DELETE">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

function bulkActivate() {
    const selectedIds = getSelectedIds();
    if (selectedIds.length === 0) {
        alert('Pilih minimal satu template');
        return;
    }
    
    if (confirm(`Aktifkan ${selectedIds.length} template terpilih?`)) {
        fetch('/admin/template-surat/bulk-activate', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ template_ids: selectedIds })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal mengaktifkan template');
            }
        });
    }
}

function bulkDeactivate() {
    const selectedIds = getSelectedIds();
    if (selectedIds.length === 0) {
        alert('Pilih minimal satu template');
        return;
    }
    
    if (confirm(`Non-aktifkan ${selectedIds.length} template terpilih?`)) {
        fetch('/admin/template-surat/bulk-deactivate', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ template_ids: selectedIds })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal menonaktifkan template');
            }
        });
    }
}

function getSelectedIds() {
    return Array.from(document.querySelectorAll('.template-checkbox:checked'))
                .map(checkbox => parseInt(checkbox.value));
}
</script>
@endpush
@endsection 