@extends('layouts.app')

@section('title', 'Detail Booking Tiket')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Detail Booking Tiket</h1>
        <a href="{{ route('admin.tiket-wisata.index') }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Booking Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Booking</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Kode Booking</strong></td>
                                    <td>: {{ $tiket->kode_booking }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Nama Pemesan</strong></td>
                                    <td>: {{ $tiket->nama_pemesan }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Email</strong></td>
                                    <td>: {{ $tiket->email }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Telepon</strong></td>
                                    <td>: {{ $tiket->telepon }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Tanggal Kunjungan</strong></td>
                                    <td>: {{ $tiket->tanggal_kunjungan->format('d/m/Y') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Jumlah Dewasa</strong></td>
                                    <td>: {{ $tiket->jumlah_dewasa }} orang</td>
                                </tr>
                                <tr>
                                    <td><strong>Jumlah Anak</strong></td>
                                    <td>: {{ $tiket->jumlah_anak }} orang</td>
                                </tr>
                                <tr>
                                    <td><strong>Total Pengunjung</strong></td>
                                    <td>: <strong>{{ $tiket->jumlah_dewasa + $tiket->jumlah_anak }} orang</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tourism Object Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Objek Wisata</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h5>{{ $tiket->objekWisata->nama }}</h5>
                            <p class="text-muted">{{ $tiket->objekWisata->deskripsi }}</p>
                            <p><strong>Alamat:</strong> {{ $tiket->objekWisata->alamat }}, {{ $tiket->objekWisata->desa }}, {{ $tiket->objekWisata->kecamatan }}</p>
                        </div>
                        <div class="col-md-4">
                            @if($tiket->objekWisata->foto_utama)
                                <img src="{{ Storage::url($tiket->objekWisata->foto_utama) }}" 
                                     alt="{{ $tiket->objekWisata->nama }}" 
                                     class="img-fluid rounded">
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Pembayaran</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Harga Dewasa</strong></td>
                                    <td>: Rp {{ number_format($tiket->harga_dewasa) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Harga Anak</strong></td>
                                    <td>: Rp {{ number_format($tiket->harga_anak) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Total Harga</strong></td>
                                    <td>: <strong class="text-primary">Rp {{ number_format($tiket->total_harga) }}</strong></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Status Pembayaran</strong></td>
                                    <td>: 
                                        @if($tiket->status_tiket === 'paid')
                                            <span class="badge badge-success">Lunas</span>
                                        @elseif($tiket->status_tiket === 'pending_payment')
                                            <span class="badge badge-warning">Pending</span>
                                        @else
                                            <span class="badge badge-danger">Belum Bayar</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Metode Pembayaran</strong></td>
                                    <td>: {{ $tiket->metode_pembayaran ?? '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal Pembayaran</strong></td>
                                    <td>: {{ $tiket->tanggal_pembayaran ? $tiket->tanggal_pembayaran->format('d/m/Y H:i') : '-' }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Check-in Information -->
            @if($tiket->status_checkin === 'checkin')
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Check-in</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>Waktu Check-in:</strong> {{ $tiket->waktu_checkin->format('d/m/Y H:i') }}</p>
                                <p><strong>Status:</strong> <span class="badge badge-success">Sudah Check-in</span></p>
                            </div>
                            <div class="col-md-6">
                                @if($tiket->foto_checkin)
                                    <p><strong>Foto Check-in:</strong></p>
                                    <img src="{{ Storage::url($tiket->foto_checkin) }}" 
                                         alt="Check-in Photo" 
                                         class="img-fluid rounded"
                                         style="max-width: 200px;">
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- QR Code -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">QR Code Tiket</h6>
                </div>
                <div class="card-body text-center">
                    @if($tiket->qr_code)
                        <img src="{{ Storage::url($tiket->qr_code) }}" 
                             alt="QR Code" 
                             class="img-fluid"
                             style="max-width: 200px;">
                        <p class="mt-2 small text-muted">Scan QR Code untuk check-in</p>
                    @else
                        <p class="text-muted">QR Code belum tersedia</p>
                    @endif
                </div>
            </div>

            <!-- Status -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Status Booking</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="small text-muted">Status Booking</label>
                        <div>
                            @if($tiket->status === 'aktif')
                                <span class="badge badge-success">Aktif</span>
                            @elseif($tiket->status === 'pending_payment')
                                <span class="badge badge-warning">Pending</span>
                            @elseif($tiket->status === 'dibatalkan')
                                <span class="badge badge-danger">Dibatalkan</span>
                            @else
                                <span class="badge badge-secondary">Expired</span>
                            @endif
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="small text-muted">Status Check-in</label>
                        <div>
                            @if($tiket->status_checkin === 'checkin')
                                <span class="badge badge-success">Sudah Check-in</span>
                            @else
                                <span class="badge badge-secondary">Belum Check-in</span>
                            @endif
                        </div>
                    </div>

                    <div>
                        <label class="small text-muted">Dibuat pada</label>
                        <div>{{ $tiket->created_at->format('d/m/Y H:i') }}</div>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        @if($tiket->status === 'pending_payment')
                            <button class="btn btn-success btn-sm" onclick="confirmBooking()">
                                <i class="fas fa-check"></i> Konfirmasi Booking
                            </button>
                        @endif
                        
                        @if($tiket->status === 'aktif' && $tiket->status_checkin !== 'checkin')
                            <button class="btn btn-info btn-sm" onclick="manualCheckin()">
                                <i class="fas fa-qrcode"></i> Check-in Manual
                            </button>
                        @endif

                        @if($tiket->status !== 'dibatalkan')
                            <button class="btn btn-warning btn-sm" onclick="cancelBooking()">
                                <i class="fas fa-times"></i> Batalkan Booking
                            </button>
                        @endif

                        <a href="{{ route('admin.tiket-wisata.print', $tiket->id) }}" 
                           class="btn btn-secondary btn-sm" target="_blank">
                            <i class="fas fa-print"></i> Print Tiket
                        </a>

                        <a href="{{ route('admin.objek-wisata.show', $tiket->objek_wisata_id) }}" 
                           class="btn btn-info btn-sm">
                            <i class="fas fa-eye"></i> Lihat Objek Wisata
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function confirmBooking() {
    if (confirm('Konfirmasi booking ini?')) {
        // Create form to confirm booking
        var form = $('<form>', {
            'method': 'POST',
            'action': '{{ route("admin.tiket-wisata.confirm", $tiket->id) }}'
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': '{{ csrf_token() }}'}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        $('body').append(form);
        form.submit();
    }
}

function manualCheckin() {
    if (confirm('Lakukan check-in manual untuk booking ini?')) {
        // Create form to manual checkin
        var form = $('<form>', {
            'method': 'POST',
            'action': '{{ route("admin.tiket-wisata.manual-checkin", $tiket->id) }}'
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': '{{ csrf_token() }}'}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        $('body').append(form);
        form.submit();
    }
}

function cancelBooking() {
    if (confirm('Batalkan booking ini? Tindakan ini tidak dapat dibatalkan.')) {
        // Create form to cancel booking
        var form = $('<form>', {
            'method': 'POST',
            'action': '{{ route("admin.tiket-wisata.cancel", $tiket->id) }}'
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': '{{ csrf_token() }}'}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        $('body').append(form);
        form.submit();
    }
}
</script>
@endpush 
