@extends('layouts.app')

@section('title', 'Edit UMKM')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.umkm.index') }}">UMKM</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.umkm.show', $umkm->id) }}">{{ $umkm->nama_umkm }}</a></li>
<li class="breadcrumb-item active">Edit</li>
@endsection

@section('content')
<div class="container-fluid">
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-edit text-primary me-2"></i>
                Edit UMKM: {{ $umkm->nama_umkm }}
            </h1>
            <p class="text-muted mb-0">Ubah informasi UMKM</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.umkm.show', $umkm->id) }}" class="btn btn-info">
                <i class="fas fa-eye me-2"></i>Lihat Detail
            </a>
            <a href="{{ route('admin.umkm.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <!-- Form Section -->
    <div class="card shadow">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Form Edit UMKM</h6>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.umkm.update', $umkm->id) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row">
                    <!-- Basic Information -->
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Informasi Dasar</h6>
                        
                        <div class="mb-3">
                            <label for="nama_umkm" class="form-label">Nama UMKM <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('nama_umkm') is-invalid @enderror" 
                                   id="nama_umkm" name="nama_umkm" value="{{ old('nama_umkm', $umkm->nama_umkm) }}" required>
                            @error('nama_umkm')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-control @error('kategori') is-invalid @enderror" id="kategori" name="kategori" required>
                                <option value="">Pilih Kategori</option>
                                @foreach($kategoris as $key => $label)
                                    <option value="{{ $key }}" {{ old('kategori', $umkm->kategori) == $key ? 'selected' : '' }}>{{ $label }}</option>
                                @endforeach
                            </select>
                            @error('kategori')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="pemilik_id" class="form-label">Pemilik <span class="text-danger">*</span></label>
                            <select class="form-control @error('pemilik_id') is-invalid @enderror" id="pemilik_id" name="pemilik_id" required>
                                <option value="">Pilih Pemilik</option>
                                @foreach($penduduk as $p)
                                    <option value="{{ $p->id }}" {{ old('pemilik_id', $umkm->pemilik_id) == $p->id ? 'selected' : '' }}>{{ $p->nama }} ({{ $p->nik }})</option>
                                @endforeach
                            </select>
                            @error('pemilik_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="skala_usaha" class="form-label">Skala Usaha <span class="text-danger">*</span></label>
                            <select class="form-control @error('skala_usaha') is-invalid @enderror" id="skala_usaha" name="skala_usaha" required>
                                <option value="">Pilih Skala</option>
                                <option value="mikro" {{ old('skala_usaha', $umkm->skala_usaha) == 'mikro' ? 'selected' : '' }}>Mikro</option>
                                <option value="kecil" {{ old('skala_usaha', $umkm->skala_usaha) == 'kecil' ? 'selected' : '' }}>Kecil</option>
                                <option value="menengah" {{ old('skala_usaha', $umkm->skala_usaha) == 'menengah' ? 'selected' : '' }}>Menengah</option>
                            </select>
                            @error('skala_usaha')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                <option value="aktif" {{ old('status', $umkm->status) == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="nonaktif" {{ old('status', $umkm->status) == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                <option value="pending_verifikasi" {{ old('status', $umkm->status) == 'pending_verifikasi' ? 'selected' : '' }}>Pending Verifikasi</option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="deskripsi" class="form-label">Deskripsi <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                      id="deskripsi" name="deskripsi" rows="4" required>{{ old('deskripsi', $umkm->deskripsi) }}</textarea>
                            @error('deskripsi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <!-- Contact & Location -->
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Kontak & Lokasi</h6>
                        
                        <div class="mb-3">
                            <label for="alamat" class="form-label">Alamat <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                      id="alamat" name="alamat" rows="3" required>{{ old('alamat', $umkm->alamat) }}</textarea>
                            @error('alamat')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nomor_telepon" class="form-label">Nomor Telepon</label>
                                    <input type="text" class="form-control @error('nomor_telepon') is-invalid @enderror" 
                                           id="nomor_telepon" name="nomor_telepon" value="{{ old('nomor_telepon', $umkm->nomor_telepon) }}">
                                    @error('nomor_telepon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="whatsapp" class="form-label">WhatsApp</label>
                                    <input type="text" class="form-control @error('whatsapp') is-invalid @enderror" 
                                           id="whatsapp" name="whatsapp" value="{{ old('whatsapp', $umkm->whatsapp) }}">
                                    @error('whatsapp')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                   id="email" name="email" value="{{ old('email', $umkm->email) }}">
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="website" class="form-label">Website</label>
                            <input type="url" class="form-control @error('website') is-invalid @enderror" 
                                   id="website" name="website" value="{{ old('website', $umkm->website) }}">
                            @error('website')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="latitude" class="form-label">Latitude</label>
                                    <input type="number" step="any" class="form-control @error('latitude') is-invalid @enderror" 
                                           id="latitude" name="latitude" value="{{ old('latitude', $umkm->latitude) }}">
                                    @error('latitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="longitude" class="form-label">Longitude</label>
                                    <input type="number" step="any" class="form-control @error('longitude') is-invalid @enderror" 
                                           id="longitude" name="longitude" value="{{ old('longitude', $umkm->longitude) }}">
                                    @error('longitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Media Upload -->
                <div class="row mt-4">
                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Media</h6>
                        
                        <!-- Current Logo -->
                        @if($umkm->logo)
                        <div class="mb-3">
                            <label class="form-label">Logo Saat Ini:</label>
                            <div class="d-flex align-items-center gap-3">
                                <img src="{{ \App\Helpers\SharedHostingHelper::getUmkmLogoUrl($umkm->logo) }}" 
                                     alt="Current Logo" 
                                     class="img-thumbnail" 
                                     style="width: 100px; height: 100px; object-fit: cover;"
                                     onerror="this.src='{{ asset('images/default-umkm-logo.png') }}'; this.onerror=null;">
                                <div>
                                    <button type="button" class="btn btn-sm btn-danger" onclick="removeCurrentLogo()">
                                        <i class="fas fa-trash"></i> Hapus Logo
                                    </button>
                                    <input type="hidden" id="remove_logo" name="remove_logo" value="0">
                                </div>
                            </div>
                        </div>
                        @endif
                        
                        <div class="mb-3">
                            <label for="logo" class="form-label">
                                {{ $umkm->logo ? 'Ganti Logo UMKM' : 'Logo UMKM' }}
                            </label>
                            <input type="file" class="form-control @error('logo') is-invalid @enderror" 
                                   id="logo" name="logo" accept="image/*">
                            <small class="text-muted">Format: JPG, PNG. Maksimal 2MB</small>
                            @error('logo')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Current Gallery -->
                        @if($umkm->galeri_foto && count($umkm->galeri_foto) > 0)
                        <div class="mb-3">
                            <label class="form-label">Galeri Saat Ini:</label>
                            <div class="row">
                                @foreach($umkm->galeri_foto as $index => $foto)
                                <div class="col-3 mb-2">
                                    <div class="position-relative">
                                        <img src="{{ \App\Helpers\SharedHostingHelper::getUmkmGalleryUrl($foto) }}" 
                                             alt="Gallery {{ $index + 1 }}" 
                                             class="img-thumbnail"
                                             onerror="this.src='{{ asset('images/default-umkm-logo.png') }}'; this.onerror=null;" 
                                             style="width: 100%; height: 80px; object-fit: cover;">
                                        <button type="button" class="btn btn-sm btn-danger position-absolute top-0 end-0" 
                                                onclick="removeGalleryPhoto({{ $index }})" style="transform: translate(50%, -50%);">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <input type="hidden" id="remove_gallery" name="remove_gallery" value="">
                        </div>
                        @endif

                        <div class="mb-3">
                            <label for="galeri_foto" class="form-label">Tambah Galeri Foto</label>
                            <input type="file" class="form-control @error('galeri_foto.*') is-invalid @enderror" 
                                   id="galeri_foto" name="galeri_foto[]" accept="image/*" multiple>
                            <small class="text-muted">Bisa pilih beberapa foto sekaligus</small>
                            @error('galeri_foto.*')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <h6 class="text-primary mb-3">Pengaturan</h6>
                        
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_verified" 
                                       name="is_verified" value="1" {{ old('is_verified', $umkm->is_verified) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_verified">
                                    Terverifikasi
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="aktif_marketplace" 
                                       name="aktif_marketplace" value="1" {{ old('aktif_marketplace', $umkm->aktif_marketplace) ? 'checked' : '' }}>
                                <label class="form-check-label" for="aktif_marketplace">
                                    Aktifkan di Marketplace
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="bisa_cod" 
                                       name="bisa_cod" value="1" {{ old('bisa_cod', $umkm->bisa_cod) ? 'checked' : '' }}>
                                <label class="form-check-label" for="bisa_cod">
                                    Terima COD (Cash on Delivery)
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="bisa_transfer" 
                                       name="bisa_transfer" value="1" {{ old('bisa_transfer', $umkm->bisa_transfer) ? 'checked' : '' }}>
                                <label class="form-check-label" for="bisa_transfer">
                                    Terima Transfer
                                </label>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="tags" class="form-label">Tags</label>
                            <input type="text" class="form-control @error('tags') is-invalid @enderror" 
                                   id="tags" name="tags" 
                                   placeholder="organik, halal, handmade (pisahkan dengan koma)" 
                                   value="{{ old('tags', is_array($umkm->tags) ? implode(', ', $umkm->tags) : $umkm->tags) }}">
                            @error('tags')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="d-flex justify-content-end gap-2">
                            <a href="{{ route('admin.umkm.show', $umkm->id) }}" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>Batal
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Update UMKM
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Enhanced image fallback for shared hosting
function handleImageError(img) {
    const defaultImage = '{{ asset("images/default-umkm-logo.png") }}';
    const currentSrc = img.src;
    
    // If already showing default image, don't change
    if (currentSrc.includes('default-umkm-logo.png')) {
        return;
    }
    
    // Try alternative paths for shared hosting
    const alternativePaths = [
        currentSrc.replace('/storage/umkm/logo/', '/admin/umkm/logo/'),
        currentSrc.replace('/storage/umkm/galeri/', '/admin/umkm/galeri/'),
        currentSrc.replace('/storage/', '/storage/app/public/'),
        currentSrc.replace('/storage/umkm/', '/storage/umkm/'),
        defaultImage
    ];
    
    let pathIndex = 0;
    
    function tryNextPath() {
        if (pathIndex < alternativePaths.length) {
            img.src = alternativePaths[pathIndex];
            pathIndex++;
        } else {
            // All paths failed, use default
            img.src = defaultImage;
            img.onerror = null; // Prevent infinite loop
        }
    }
    
    // Set up error handler for next attempt
    img.onerror = tryNextPath;
    
    // Try first alternative
    tryNextPath();
}

$(document).ready(function() {
    // Form validation
    $('form').on('submit', function(e) {
        const submitBtn = $(this).find('button[type="submit"]');
        const originalText = submitBtn.html();
        
        // Disable submit button and show loading
        submitBtn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin me-2"></i>Menyimpan...');
        
        // Re-enable after 5 seconds as fallback
        setTimeout(function() {
            submitBtn.prop('disabled', false).html(originalText);
        }, 5000);
    });
    
    // Enhanced image error handling for all UMKM images
    $('img[src*="storage/umkm"]').each(function() {
        const img = this;
        img.onerror = function() {
            handleImageError(img);
        };
    });
});

function removeCurrentLogo() {
    if (confirm('Apakah Anda yakin ingin menghapus logo saat ini?')) {
        document.getElementById('remove_logo').value = '1';
        document.querySelector('.img-thumbnail').style.opacity = '0.5';
        document.querySelector('button[onclick="removeCurrentLogo()"]').innerHTML = '<i class="fas fa-undo"></i> Batalkan';
        document.querySelector('button[onclick="removeCurrentLogo()"]').setAttribute('onclick', 'restoreCurrentLogo()');
    }
}

function restoreCurrentLogo() {
    document.getElementById('remove_logo').value = '0';
    document.querySelector('.img-thumbnail').style.opacity = '1';
    document.querySelector('button[onclick="restoreCurrentLogo()"]').innerHTML = '<i class="fas fa-trash"></i> Hapus Logo';
    document.querySelector('button[onclick="restoreCurrentLogo()"]').setAttribute('onclick', 'removeCurrentLogo()');
}

function removeGalleryPhoto(index) {
    if (confirm('Apakah Anda yakin ingin menghapus foto ini?')) {
        const removeGallery = document.getElementById('remove_gallery');
        const currentValue = removeGallery.value;
        const newValue = currentValue ? currentValue + ',' + index : index;
        removeGallery.value = newValue;
        
        // Hide the photo
        event.target.closest('.col-3').style.display = 'none';
    }
}
</script>
@endpush
