@extends('layouts.app')

@section('title', 'Detail UMKM')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.umkm.index') }}">UMKM</a></li>
<li class="breadcrumb-item active">Detail UMKM</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-store text-primary me-2"></i>
                Detail UMKM
            </h1>
            <p class="text-muted mb-0">Informasi lengkap tentang {{ $umkm->nama_umkm }}</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('admin.umkm.edit', $umkm->id) }}" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
            <a href="{{ route('admin.umkm.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Main Information -->
        <div class="col-lg-8">
            <!-- Basic Information Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Dasar</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Nama UMKM:</strong></td>
                                    <td>{{ $umkm->nama_umkm }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Kategori:</strong></td>
                                    <td>
                                        <span class="badge bg-info">{{ $umkm->kategori_label }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Skala Usaha:</strong></td>
                                    <td>
                                        <span class="badge bg-secondary">{{ ucfirst($umkm->skala_usaha) }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>{!! $umkm->status_badge !!}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Pemilik:</strong></td>
                                    <td>{{ $umkm->pemilik->nama ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>NIK Pemilik:</strong></td>
                                    <td>{{ $umkm->pemilik->nik ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Verifikasi:</strong></td>
                                    <td>
                                        @if($umkm->is_verified)
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle"></i> Terverifikasi
                                            </span>
                                        @else
                                            <span class="badge bg-warning">
                                                <i class="fas fa-clock"></i> Belum Verifikasi
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Marketplace:</strong></td>
                                    <td>
                                        @if($umkm->aktif_marketplace)
                                            <span class="badge bg-success">Aktif</span>
                                        @else
                                            <span class="badge bg-secondary">Tidak Aktif</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <div class="mt-3">
                        <strong>Deskripsi:</strong>
                        <p class="mt-2">{{ $umkm->deskripsi }}</p>
                    </div>
                </div>
            </div>

            <!-- Contact Information Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Kontak & Lokasi</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Alamat:</strong></td>
                                    <td>{{ $umkm->alamat }}</td>
                                </tr>
                                @if($umkm->nomor_telepon)
                                <tr>
                                    <td><strong>Telepon:</strong></td>
                                    <td>
                                        <i class="fas fa-phone text-primary me-1"></i>
                                        {{ $umkm->nomor_telepon }}
                                    </td>
                                </tr>
                                @endif
                                @if($umkm->whatsapp)
                                <tr>
                                    <td><strong>WhatsApp:</strong></td>
                                    <td>
                                        <i class="fab fa-whatsapp text-success me-1"></i>
                                        {{ $umkm->whatsapp }}
                                    </td>
                                </tr>
                                @endif
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                @if($umkm->email)
                                <tr>
                                    <td><strong>Email:</strong></td>
                                    <td>
                                        <i class="fas fa-envelope text-primary me-1"></i>
                                        {{ $umkm->email }}
                                    </td>
                                </tr>
                                @endif
                                @if($umkm->website)
                                <tr>
                                    <td><strong>Website:</strong></td>
                                    <td>
                                        <i class="fas fa-globe text-primary me-1"></i>
                                        <a href="{{ $umkm->website }}" target="_blank">{{ $umkm->website }}</a>
                                    </td>
                                </tr>
                                @endif
                                @if($umkm->latitude && $umkm->longitude)
                                <tr>
                                    <td><strong>Koordinat:</strong></td>
                                    <td>
                                        <i class="fas fa-map-marker-alt text-danger me-1"></i>
                                        {{ $umkm->latitude }}, {{ $umkm->longitude }}
                                    </td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Pengaturan</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Metode Pembayaran:</h6>
                            <ul class="list-unstyled">
                                @if($umkm->bisa_cod)
                                    <li><i class="fas fa-check text-success me-2"></i>Cash on Delivery (COD)</li>
                                @endif
                                @if($umkm->bisa_transfer)
                                    <li><i class="fas fa-check text-success me-2"></i>Transfer Bank</li>
                                @endif
                            </ul>
                        </div>
                        <div class="col-md-6">
                            @if($umkm->tags && count($umkm->tags) > 0)
                            <h6>Tags:</h6>
                            <div class="d-flex flex-wrap gap-1">
                                @foreach($umkm->tags as $tag)
                                    <span class="badge bg-light text-dark border">{{ $tag }}</span>
                                @endforeach
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Logo Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Logo UMKM</h6>
                </div>
                <div class="card-body text-center">
                    @if($umkm->logo)
                        <img src="{{ $umkm->logo_url }}" alt="Logo {{ $umkm->nama_umkm }}" 
                             class="img-fluid rounded" style="max-height: 200px;"
                             onerror="this.src='{{ asset('images/default-umkm-logo.png') }}'">
                    @else
                        <div class="text-muted">
                            <i class="fas fa-image fa-3x mb-3"></i>
                            <p>Belum ada logo</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Statistics Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Statistik</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-primary">{{ $umkm->rating_rata_rata ?? 0 }}</h4>
                                <small class="text-muted">Rating</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-success">{{ $umkm->jumlah_ulasan ?? 0 }}</h4>
                            <small class="text-muted">Ulasan</small>
                        </div>
                    </div>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-info">{{ $umkm->jumlah_produk ?? 0 }}</h4>
                                <small class="text-muted">Produk</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-warning">{{ $umkm->jumlah_view ?? 0 }}</h4>
                            <small class="text-muted">Views</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gallery Card -->
            @if($umkm->galeri_foto && count($umkm->galeri_foto) > 0)
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Galeri Foto</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($umkm->galeri_foto_urls as $index => $fotoUrl)
                            @if($index < 6) <!-- Show max 6 photos -->
                            <div class="col-6 mb-2">
                                <img src="{{ $fotoUrl }}" 
                                     alt="Galeri {{ $index + 1 }}" 
                                     class="img-fluid rounded" 
                                     style="height: 80px; width: 100%; object-fit: cover;"
                                     data-bs-toggle="modal" 
                                     data-bs-target="#galleryModal"
                                     onclick="showGallery({{ $index }})"
                                     onerror="this.src='{{ asset('images/default-umkm-logo.png') }}'">
                            </div>
                            @endif
                        @endforeach
                    </div>
                    @if(count($umkm->galeri_foto) > 6)
                        <div class="text-center mt-2">
                            <small class="text-muted">+{{ count($umkm->galeri_foto) - 6 }} foto lainnya</small>
                        </div>
                    @endif
                </div>
            </div>
            @endif

            <!-- Actions Card -->
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.umkm.edit', $umkm->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i>Edit UMKM
                        </a>
                        
                        @if($umkm->status == 'pending_verifikasi')
                            <button type="button" class="btn btn-success" onclick="verifyUmkm({{ $umkm->id }})">
                                <i class="fas fa-check me-2"></i>Verifikasi
                            </button>
                        @endif
                        
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="marketplaceToggle" 
                                   {{ $umkm->aktif_marketplace ? 'checked' : '' }}
                                   onchange="toggleMarketplace({{ $umkm->id }})">
                            <label class="form-check-label" for="marketplaceToggle">
                                Aktifkan Marketplace
                            </label>
                        </div>
                        
                        <button type="button" class="btn btn-danger" onclick="deleteUmkm({{ $umkm->id }})">
                            <i class="fas fa-trash me-2"></i>Hapus UMKM
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Gallery Modal -->
@if($umkm->galeri_foto && count($umkm->galeri_foto) > 0)
<div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="galleryModalLabel">Galeri Foto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="galleryCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        @foreach($umkm->galeri_foto_urls as $index => $fotoUrl)
                        <div class="carousel-item {{ $index == 0 ? 'active' : '' }}">
                            <img src="{{ $fotoUrl }}" 
                                 class="d-block w-100" alt="Galeri {{ $index + 1 }}"
                                 onerror="this.src='{{ asset('images/default-umkm-logo.png') }}'">
                        </div>
                        @endforeach
                    </div>
                    @if(count($umkm->galeri_foto) > 1)
                    <button class="carousel-control-prev" type="button" data-bs-target="#galleryCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Previous</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#galleryCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Next</span>
                    </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@endsection

@push('scripts')
<script>
function showGallery(index) {
    // Set active carousel item
    const carousel = document.getElementById('galleryCarousel');
    const items = carousel.querySelectorAll('.carousel-item');
    items.forEach((item, i) => {
        item.classList.toggle('active', i === index);
    });
}

function verifyUmkm(id) {
    Swal.fire({
        title: 'Verifikasi UMKM',
        html: `
            <div class="mb-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-control" id="verify-status">
                    <option value="aktif">Aktif</option>
                    <option value="nonaktif">Non-aktif</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="catatan" class="form-label">Catatan Verifikasi</label>
                <textarea class="form-control" id="verify-catatan" rows="3"></textarea>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Verifikasi',
        cancelButtonText: 'Batal',
        preConfirm: () => {
            const status = document.getElementById('verify-status').value;
            const catatan = document.getElementById('verify-catatan').value;
            
            return { status, catatan };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/umkm/${id}/verify`,
                method: 'PUT',
                data: {
                    _token: '{{ csrf_token() }}',
                    status: result.value.status,
                    catatan_verifikasi: result.value.catatan
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr) {
                    let message = 'Terjadi kesalahan!';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: message
                    });
                }
            });
        }
    });
}

function toggleMarketplace(id) {
    $.ajax({
        url: `/admin/umkm/${id}/toggle-marketplace`,
        method: 'PUT',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });
            }
        },
        error: function(xhr) {
            let message = 'Terjadi kesalahan!';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: message
            });
        }
    });
}

function deleteUmkm(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data UMKM akan dihapus permanen!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/admin/umkm/${id}`;
            form.innerHTML = `
                @csrf
                @method('DELETE')
            `;
            document.body.appendChild(form);
            form.submit();
        }
    });
}
</script>
@endpush
