@extends('layouts.app')

@section('title', 'Tambah User')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-plus me-2 text-primary"></i>Tambah User
            </h2>
            <p class="text-muted mb-0">Buat pengguna baru dengan akses sistem</p>
        </div>
        <div>
            <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <form id="createUserForm">
        @csrf
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-user me-2"></i>Informasi User</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label required">Nama Lengkap</label>
                            <input type="text" class="form-control" name="name" required
                                   placeholder="Masukkan nama lengkap">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label required">Email</label>
                            <input type="email" class="form-control" name="email" required
                                   placeholder="Masukkan alamat email">
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required">Password</label>
                                    <input type="password" class="form-control" name="password" required minlength="8"
                                           placeholder="Minimum 8 karakter">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required">Konfirmasi Password</label>
                                    <input type="password" class="form-control" name="password_confirmation" required minlength="8"
                                           placeholder="Ulangi password">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label required">Role</label>
                            <select class="form-select" name="role_id" required>
                                <option value="">Pilih Role</option>
                                @foreach($roles ?? [] as $role)
                                    <option value="{{ $role->id }}">{{ $role->display_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_active" id="isActive" checked>
                            <label class="form-check-label" for="isActive">
                                User aktif
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Panduan</h6>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <h6 class="alert-heading">
                                <i class="fas fa-lightbulb me-2"></i>Tips Membuat User
                            </h6>
                            <ul class="mb-0 small">
                                <li>Email harus unik dan valid</li>
                                <li>Password minimal 8 karakter</li>
                                <li>Pilih role sesuai kebutuhan akses</li>
                                <li>User dapat dinonaktifkan tanpa menghapus data</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan User
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('styles')
<style>
.required::after {
    content: ' *';
    color: #dc3545;
}
</style>
@endpush

@push('scripts')
<script>
document.getElementById('createUserForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    // Check password confirmation
    const password = formData.get('password');
    const confirmation = formData.get('password_confirmation');
    
    if (password !== confirmation) {
        showToast('Password dan konfirmasi password tidak cocok', 'error');
        return;
    }
    
    showLoading();
    
    fetch('{{ route("admin.users.store") }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        hideLoading();
        
        if (data.success) {
            showToast('User berhasil ditambahkan', 'success');
            setTimeout(() => {
                window.location.href = '{{ route("admin.users.index") }}';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal menambahkan user', 'error');
        }
    })
    .catch(error => {
        hideLoading();
        console.error('Error:', error);
        showToast('Terjadi kesalahan sistem', 'error');
    });
});
</script>
@endpush 
