@extends('layouts.app')

@section('title', 'Detail Wilayah Administratif')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.wilayah-administratif.index') }}">Wilayah Administratif</a></li>
<li class="breadcrumb-item active">Detail</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">
                            Detail {{ strtoupper($wilayah->jenis_wilayah) }} {{ $wilayah->nama_wilayah }}
                        </h4>
                        <div>
                            <a href="{{ route('admin.wilayah-administratif.edit', $wilayah->id) }}" 
                               class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <a href="{{ route('admin.wilayah-administratif.index') }}" 
                               class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="text-primary">Informasi Dasar</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="150"><strong>Kode Wilayah:</strong></td>
                                    <td>{{ $wilayah->kode_wilayah }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Nama Wilayah:</strong></td>
                                    <td>{{ $wilayah->nama_wilayah }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Jenis Wilayah:</strong></td>
                                    <td>
                                        <span class="badge bg-primary">{{ strtoupper($wilayah->jenis_wilayah) }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td>
                                        <span class="badge bg-{{ $wilayah->status == 'aktif' ? 'success' : 'secondary' }}">
                                            {{ ucfirst($wilayah->status) }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Urutan Tampil:</strong></td>
                                    <td>{{ $wilayah->urutan_tampil }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="text-primary">Informasi Kepala Wilayah</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="150"><strong>Nama Kepala:</strong></td>
                                    <td>{{ $wilayah->kepala_wilayah ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>NIK Kepala:</strong></td>
                                    <td>{{ $wilayah->nik_kepala ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>No. HP:</strong></td>
                                    <td>{{ $wilayah->nomor_hp_kepala ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Alamat Kantor:</strong></td>
                                    <td>{{ $wilayah->alamat_kantor ?: '-' }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <hr>

                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="text-primary">Statistik</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="150"><strong>Jumlah KK:</strong></td>
                                    <td>{{ number_format($wilayah->jumlah_kk) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Jumlah Penduduk:</strong></td>
                                    <td>{{ number_format($wilayah->jumlah_penduduk) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Luas Wilayah:</strong></td>
                                    <td>{{ $wilayah->luas_wilayah ? number_format($wilayah->luas_wilayah, 2) . ' Ha' : '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Kepadatan:</strong></td>
                                    <td>
                                        @if($wilayah->luas_wilayah > 0)
                                            {{ number_format($wilayah->jumlah_penduduk / $wilayah->luas_wilayah, 2) }} jiwa/Ha
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5 class="text-primary">Koordinat & Batas</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="150"><strong>Latitude:</strong></td>
                                    <td>{{ $wilayah->latitude ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Longitude:</strong></td>
                                    <td>{{ $wilayah->longitude ?: '-' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Batas Wilayah:</strong></td>
                                    <td>{{ $wilayah->batas_wilayah ?: '-' }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($wilayah->parent)
                    <hr>
                    <div class="row">
                        <div class="col-12">
                            <h5 class="text-primary">Wilayah Induk</h5>
                            <div class="alert alert-info">
                                <strong>{{ strtoupper($wilayah->parent->jenis_wilayah) }} {{ $wilayah->parent->nama_wilayah }}</strong>
                                <br>
                                <small>Kode: {{ $wilayah->parent->kode_wilayah }}</small>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($wilayah->children->count() > 0)
                    <hr>
                    <div class="row">
                        <div class="col-12">
                            <h5 class="text-primary">Wilayah di Bawahnya</h5>
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Kode</th>
                                            <th>Nama</th>
                                            <th>Jenis</th>
                                            <th>Status</th>
                                            <th>Jumlah KK</th>
                                            <th>Jumlah Penduduk</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($wilayah->children as $child)
                                        <tr>
                                            <td>{{ $child->kode_wilayah }}</td>
                                            <td>{{ $child->nama_wilayah }}</td>
                                            <td>
                                                <span class="badge bg-{{ $child->jenis_wilayah == 'dusun' ? 'primary' : ($child->jenis_wilayah == 'rw' ? 'info' : 'warning') }}">
                                                    {{ strtoupper($child->jenis_wilayah) }}
                                                </span>
                                            </td>
                                            <td>
                                                <span class="badge bg-{{ $child->status == 'aktif' ? 'success' : 'secondary' }}">
                                                    {{ ucfirst($child->status) }}
                                                </span>
                                            </td>
                                            <td>{{ number_format($child->jumlah_kk) }}</td>
                                            <td>{{ number_format($child->jumlah_penduduk) }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($wilayah->keterangan)
                    <hr>
                    <div class="row">
                        <div class="col-12">
                            <h5 class="text-primary">Keterangan</h5>
                            <div class="alert alert-light">
                                {{ $wilayah->keterangan }}
                            </div>
                        </div>
                    </div>
                    @endif

                    <hr>
                    <div class="row">
                        <div class="col-12">
                            <h5 class="text-primary">Informasi Sistem</h5>
                            <table class="table table-borderless">
                                <tr>
                                    <td width="150"><strong>Dibuat oleh:</strong></td>
                                    <td>{{ $wilayah->user->name ?? 'System' }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal dibuat:</strong></td>
                                    <td>{{ $wilayah->created_at->format('d/m/Y H:i:s') }}</td>
                                </tr>
                                <tr>
                                    <td><strong>Terakhir diupdate:</strong></td>
                                    <td>{{ $wilayah->updated_at->format('d/m/Y H:i:s') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Add any additional JavaScript functionality here
document.addEventListener('DOMContentLoaded', function() {
    // Initialize any components or event handlers
});
</script>
@endpush
