<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal Berita - Sistem Informasi Desa</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#3B82F6">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    <link rel="manifest" href="/manifest.json">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: white;
            border-radius: 12px;
            padding: 12px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
            border: 1px solid #f1f5f9;
            transition: all 0.3s ease;
        }
        
        .mobile-card:hover {
            transform: translateY(-1px);
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.12);
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .article-card {
            background: white;
            border-radius: 12px;
            padding: 12px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.08);
            border: 1px solid #f1f5f9;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .article-card:hover {
            transform: translateY(-1px);
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.12);
        }
        
        .category-badge {
            display: inline-block;
            padding: 0.2rem 0.6rem;
            font-size: 0.7rem;
            font-weight: 600;
            border-radius: 9999px;
        }
        
        .category-pengumuman { background-color: #fef2f2; color: #991b1b; }
        .category-berita { background-color: #eff6ff; color: #1e40af; }
        .category-kegiatan { background-color: #f0fdf4; color: #166534; }
        .category-kesehatan { background-color: #ecfdf5; color: #065f46; }
        .category-umkm { background-color: #fef3c7; color: #92400e; }
        .category-pembangunan { background-color: #fef3e2; color: #ea580c; }
        .category-sosial { background-color: #f3e8ff; color: #7c3aed; }
        .category-pendidikan { background-color: #ecfeff; color: #0891b2; }
        .category-keamanan { background-color: #fefce8; color: #ca8a04; }
        .category-lainnya { background-color: #f1f5f9; color: #475569; }
        .category-default { background-color: #f9fafb; color: #374151; }
        
        .line-clamp-2 {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        
        .stat-card {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            border-radius: 16px;
            padding: 16px;
            color: white;
            text-align: center;
        }
        
        .search-container {
            background: white;
            border-radius: 10px;
            padding: 8px;
            box-shadow: 0 1px 6px rgba(0,0,0,0.05);
            margin-bottom: 12px;
        }
        
        .filter-button {
            background: #f8f9ff;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 4px 8px;
            margin: 2px;
            font-size: 11px;
            font-weight: 500;
            color: #374151;
            transition: all 0.3s ease;
        }
        
        .filter-button.active {
            background: #3b82f6;
            border-color: #3b82f6;
            color: white;
        }
        
        /* FontAwesome fallback with !important for navigation */
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        
        /* Additional common icons */
        .fas.fa-search:before, .fa.fa-search:before { content: "🔍" !important; font-family: system-ui !important; }
        .fas.fa-filter:before, .fa.fa-filter:before { content: "🔽" !important; font-family: system-ui !important; }
        .fas.fa-heart:before, .fa.fa-heart:before { content: "❤️" !important; font-family: system-ui !important; }
        .far.fa-heart:before, .fa.fa-heart-o:before { content: "🤍" !important; font-family: system-ui !important; }
        .fas.fa-share:before, .fa.fa-share:before { content: "📤" !important; font-family: system-ui !important; }
        .fas.fa-comment:before, .fa.fa-comment:before { content: "💬" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header/Status Bar -->
        <div class="gradient-bg text-white px-6 py-6 relative overflow-hidden">
           <!-- Background Pattern -->
           <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center space-x-3">
                        <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                            <span class="text-lg">⬅️</span>
                        </button>
                        <div>
                            <h1 class="text-xl font-bold">Portal Berita</h1>
                            <p class="text-white/80 text-sm">Informasi terkini desa</p>
                        </div>
                    </div>
                    
                    <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                        <span class="text-lg">📰</span>
                    </div>
                </div>
                
                <!-- Service Info -->
                <div class="text-center">
                    <h2 class="text-lg font-semibold mb-2">Portal Berita Desa</h2>
                    <p class="text-white/90 text-sm">Informasi terkini dari desa</p>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="px-6 -mt-6 relative z-20">
            
            <!-- Statistik -->
            <div class="grid grid-cols-3 gap-3 mb-4">
                <div class="stat-card">
                    <div class="text-xl font-bold">{{ $totalBerita ?? 0 }}</div>
                    <div class="text-xs opacity-90">Total Berita</div>
                </div>
                <div class="stat-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                    <div class="text-xl font-bold">{{ $beritaBulanIni ?? 0 }}</div>
                    <div class="text-xs opacity-90">Bulan Ini</div>
                </div>
                <div class="stat-card" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                    <div class="text-xl font-bold">{{ $totalViews ?? 0 }}</div>
                    <div class="text-xs opacity-90">Pembaca</div>
                </div>
            </div>

            <!-- Search & Filter -->
            <div class="search-container">
                <div class="relative mb-2">
                    <input type="text" id="searchInput" 
                           placeholder="Cari berita, pengumuman..." 
                           class="w-full pl-8 pr-3 py-2 text-xs border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                    <span class="absolute left-2.5 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm">🔍</span>
                </div>
                
                <!-- Filter Categories -->
                <div class="flex flex-wrap justify-center gap-1">
                    <button onclick="filterByCategory('all')" class="filter-button active">Semua</button>
                    <button onclick="filterByCategory('pengumuman')" class="filter-button">Pengumuman</button>
                    <button onclick="filterByCategory('kegiatan')" class="filter-button">Kegiatan</button>
                    <button onclick="filterByCategory('pembangunan')" class="filter-button">Pembangunan</button>
                    <button onclick="filterByCategory('kesehatan')" class="filter-button">Kesehatan</button>
                    <button onclick="filterByCategory('umkm')" class="filter-button">UMKM</button>
                </div>
            </div>

            <!-- Sort Options -->
            <div class="flex items-center justify-between mb-2">
                <h3 class="text-sm font-medium text-gray-800">Berita Terbaru</h3>
                <select id="sortSelect" onchange="sortNews(this.value)" class="text-xs border border-gray-200 rounded-md px-2 py-0.5 focus:outline-none focus:ring-1 focus:ring-primary-500">
                    <option value="terbaru">Terbaru</option>
                    <option value="terpopuler">Terpopuler</option>
                    <option value="az">A-Z</option>
                </select>
            </div>

            <!-- News List -->
            <div id="newsList" class="space-y-2 mb-3">
                @forelse($beritaList ?? [] as $berita)
                <div class="article-card news-item" 
                     data-category="{{ strtolower($berita->kategori) }}" 
                     data-date="{{ $berita->created_at->timestamp }}"
                     data-views="{{ $berita->views ?? 0 }}"
                     onclick="openArticle('{{ $berita->slug }}')">
                    
                    <div class="flex space-x-3">
                        @if($berita->gambar)
                        <img src="{{ asset('storage/' . $berita->gambar) }}" 
                             alt="{{ $berita->judul }}" 
                             class="w-16 h-12 object-cover rounded-lg flex-shrink-0">
                        @else
                        <div class="w-16 h-12 bg-gray-200 rounded-lg flex-shrink-0 flex items-center justify-center">
                            <span class="text-gray-400 text-lg">🖼️</span>
                        </div>
                        @endif
                        
                        <div class="flex-1">
                            <div class="flex items-start justify-between mb-1.5">
                                <span class="category-badge category-{{ strtolower($berita->kategori) }}">
                                    {{ ucfirst($berita->kategori) }}
                                </span>
                                <span class="text-xs text-gray-400">{{ $berita->created_at->diffForHumans() }}</span>
                            </div>
                            
                            <h4 class="font-medium text-gray-800 text-sm mb-1 line-clamp-2">
                                {{ $berita->judul }}
                            </h4>
                            
                            <p class="text-gray-600 text-xs mb-1.5 line-clamp-2">
                                {{ Str::limit(strip_tags($berita->konten), 80) }}
                            </p>
                            
                            <div class="flex items-center justify-between text-xs text-gray-500">
                                <div class="flex items-center space-x-2">
                                    <span class="flex items-center">
                                        <span class="mr-1 text-xs">👁️</span>
                                        {{ $berita->views ?? 0 }}
                                    </span>
                                </div>
                                <span class="font-medium text-xs">{{ $berita->penulis ?? 'Admin' }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="text-center py-6">
                    <span class="text-4xl text-gray-300 block mb-3">📰</span>
                    <p class="text-gray-500 text-xs">Belum ada berita tersedia</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>
        
        <!-- Spacer for bottom navigation -->
        <div class="h-24"></div>
    </div>

    <!-- JavaScript -->
    <script>
        function filterByCategory(category) {
            // Update active button
            document.querySelectorAll('.filter-button').forEach(btn => {
                btn.classList.remove('active');
            });
            
            event.target.classList.add('active');
            
            // Filter news items
            const newsItems = document.querySelectorAll('.news-item');
            newsItems.forEach(item => {
                if (category === 'all' || item.dataset.category === category) {
                    item.style.display = 'block';
                } else {
                    item.style.display = 'none';
                }
            });
        }
        
        function sortNews(sortType) {
            const newsList = document.getElementById('newsList');
            const newsItems = Array.from(newsList.querySelectorAll('.news-item'));
            
            newsItems.sort((a, b) => {
                switch(sortType) {
                    case 'terbaru':
                        return parseInt(b.dataset.date) - parseInt(a.dataset.date);
                    case 'terpopuler':
                        return parseInt(b.dataset.views) - parseInt(a.dataset.views);
                    case 'az':
                        const titleA = a.querySelector('h4').textContent.toLowerCase();
                        const titleB = b.querySelector('h4').textContent.toLowerCase();
                        return titleA.localeCompare(titleB);
                    default:
                        return 0;
                }
            });
            
            newsItems.forEach(item => newsList.appendChild(item));
        }

        function performSearch(query) {
            const newsItems = document.querySelectorAll('.news-item');
            query = query.toLowerCase();
            
            newsItems.forEach(item => {
                const title = item.querySelector('h4').textContent.toLowerCase();
                const content = item.querySelector('p').textContent.toLowerCase();
                
                if (query === '' || title.includes(query) || content.includes(query)) {
                    item.style.display = 'block';
                } else {
                    item.style.display = 'none';
                }
            });
        }

        function openArticle(slug) {
            window.location.href = `/berita/${slug}`;
        }

        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                case 'demografi':
                    window.location.href = '/demografi';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'ppob':
                    window.location.href = '/ppob';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }

        // Search functionality
        document.getElementById('searchInput')?.addEventListener('input', function(e) {
            performSearch(e.target.value);
        });
        
        // Service Worker Registration
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('/sw.js')
                    .then(registration => {
                        console.log('SW registered: ', registration);
                    })
                    .catch(registrationError => {
                        console.log('SW registration failed: ', registrationError);
                    });
            });
        }
        
        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Berita PWA loaded');
            
            // Simple check FontAwesome - will fallback to CSS emoji if needed
            setTimeout(() => {
                console.log('✅ Berita page loaded with FontAwesome + CSS emoji fallback');
            }, 1000);
        });
        

    </script>
</body>
</html> 