<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Personal - Portal Layanan Mandiri</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .info-card {
            transition: all 0.3s ease;
        }
        
        .info-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-pending { background: #fef3c7; color: #92400e; }
        .status-process { background: #dbeafe; color: #1e40af; }
        .status-done { background: #d1fae5; color: #065f46; }
        .status-rejected { background: #fee2e2; color: #991b1b; }

        /* Prevent navbar jump when SweetAlert2 opens */
        body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown) {
            padding-right: 0 !important;
            overflow-y: scroll !important;
        }
        
        .swal2-popup {
            padding-right: 0 !important;
        }
        
        .swal2-container {
            padding-right: 0 !important;
            -webkit-backdrop-filter: blur(4px);
            backdrop-filter: blur(4px);
            z-index: 9999 !important;
        }

        /* Ensure fixed elements stay in place */
        .fixed {
            padding-right: 0 !important;
        }

        /* Prevent navigation button shift */
        .max-w-md {
            padding-right: 0 !important;
        }

        /* Keep bottom navigation fixed */
        .bottom-navigation {
            padding-right: 0 !important;
            z-index: 40;
        }

        /* Prevent background shift */
        html.swal2-shown {
            overflow-y: scroll !important;
            position: fixed !important;
            width: 100% !important;
            padding-right: 0 !important;
        }

        /* Prevent content jump */
        .swal2-shown .max-w-md {
            transform: none !important;
        }
        
        /* FontAwesome fallback with !important for all icons */
        .fas.fa-user:before, .fa.fa-user:before { content: "👤" !important; font-family: system-ui !important; }
        .fas.fa-arrow-left:before, .fa.fa-arrow-left:before { content: "⬅️" !important; font-family: system-ui !important; }
        .fas.fa-tachometer-alt:before, .fa.fa-dashboard:before { content: "📊" !important; font-family: system-ui !important; }
        .fas.fa-id-card:before, .fa.fa-id-card:before { content: "🆔" !important; font-family: system-ui !important; }
        .fas.fa-calendar:before, .fa.fa-calendar:before { content: "📅" !important; font-family: system-ui !important; }
        .fas.fa-phone:before, .fa.fa-phone:before { content: "📞" !important; font-family: system-ui !important; }
        .fas.fa-envelope:before, .fa.fa-envelope:before { content: "📧" !important; font-family: system-ui !important; }
        .fas.fa-map-marker-alt:before, .fa.fa-map-marker:before { content: "📍" !important; font-family: system-ui !important; }
        .fas.fa-users:before, .fa.fa-users:before { content: "👥" !important; font-family: system-ui !important; }
        .fas.fa-heart:before, .fa.fa-heart:before { content: "❤️" !important; font-family: system-ui !important; }
        .fas.fa-graduation-cap:before, .fa.fa-graduation-cap:before { content: "🎓" !important; font-family: system-ui !important; }
        .fas.fa-briefcase:before, .fa.fa-briefcase:before { content: "💼" !important; font-family: system-ui !important; }
        .fas.fa-file-alt:before, .fa.fa-file:before { content: "📄" !important; font-family: system-ui !important; }
        .fas.fa-clock:before, .fa.fa-clock:before { content: "🕐" !important; font-family: system-ui !important; }
        .fas.fa-check-circle:before, .fa.fa-check-circle:before { content: "✅" !important; font-family: system-ui !important; }
        .fas.fa-times-circle:before, .fa.fa-times-circle:before { content: "❌" !important; font-family: system-ui !important; }
        .fas.fa-exclamation-circle:before, .fa.fa-exclamation-circle:before { content: "⚠️" !important; font-family: system-ui !important; }
        .fas.fa-eye:before, .fa.fa-eye:before { content: "👁️" !important; font-family: system-ui !important; }
        .fas.fa-edit:before, .fa.fa-edit:before { content: "✏️" !important; font-family: system-ui !important; }
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="gradient-bg px-6 py-6 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center space-x-3">
                    <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
                        <i class="fas fa-arrow-left text-white"></i>
                    </button>
                    <div>
                        <h1 class="text-lg font-bold text-white">Dashboard Personal</h1>
                        <p class="text-white/80 text-sm">Data Pribadi & Riwayat Layanan</p>
                    </div>
                </div>
                <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center overflow-hidden relative" id="avatarContainer">
                    <div id="userInitials" class="w-full h-full bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center">
                        <span class="text-white font-bold text-sm" id="initialsText">SW</span>
                    </div>
                </div>
            </div>

            <!-- Status Summary -->
            <div class="grid grid-cols-3 gap-3">
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white" id="totalSurat">-</div>
                    <div class="text-white/80 text-xs">Total Layanan</div>
                </div>
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white" id="suratProses">-</div>
                    <div class="text-white/80 text-xs">Dalam Proses</div>
                </div>
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white" id="suratSelesai">-</div>
                    <div class="text-white/80 text-xs">Selesai</div>
                </div>
            </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="px-6 -mt-6 relative z-20 mb-6">
            <!-- Personal Information Card -->
            <div class="mobile-card mb-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-base font-semibold text-gray-800">Informasi Pribadi</h3>
                    <button onclick="showEditProfile()" class="text-blue-600 text-sm font-medium">
                        <i class="fas fa-edit"></i> Edit
                    </button>
                </div>
                
                <div class="space-y-4">
                    <!-- NIK -->
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-id-card text-blue-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-xs text-gray-500">NIK</p>
                            <p class="font-semibold text-gray-800" id="userNIK">Loading...</p>
                        </div>
                    </div>

                    <!-- Nama Lengkap -->
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-user text-green-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-xs text-gray-500">Nama Lengkap</p>
                            <p class="font-semibold text-gray-800" id="userFullName">Loading...</p>
                        </div>
                    </div>

                    <!-- Tempat, Tanggal Lahir -->
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-calendar text-purple-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-xs text-gray-500">Tempat, Tanggal Lahir</p>
                            <p class="font-semibold text-gray-800" id="userBirth">Loading...</p>
                        </div>
                    </div>

                    <!-- Alamat -->
                    <div class="flex items-start space-x-3">
                        <div class="w-8 h-8 bg-orange-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-map-marker-alt text-orange-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-xs text-gray-500">Alamat</p>
                            <p class="font-semibold text-gray-800" id="userAddress">Loading...</p>
                        </div>
                    </div>

                    <!-- Status Perkawinan -->
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-pink-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-heart text-pink-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-xs text-gray-500">Status Perkawinan</p>
                            <p class="font-semibold text-gray-800" id="userMaritalStatus">Loading...</p>
                        </div>
                    </div>

                    <!-- Pekerjaan -->
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-indigo-100 rounded-lg flex items-center justify-center">
                            <i class="fas fa-briefcase text-indigo-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-xs text-gray-500">Pekerjaan</p>
                            <p class="font-semibold text-gray-800" id="userJob">Loading...</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Family Information Card -->
            <div class="mobile-card mb-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-base font-semibold text-gray-800">Informasi Keluarga</h3>
                    <button onclick="showFamilyDetails()" class="text-blue-600 text-sm font-medium">
                        <i class="fas fa-eye"></i> Detail
                    </button>
                </div>
                
                <div class="grid grid-cols-2 gap-4">
                    <div class="text-center">
                        <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-users text-blue-600"></i>
                        </div>
                        <p class="text-lg font-bold text-gray-800" id="familySize">-</p>
                        <p class="text-xs text-gray-500">Anggota Keluarga</p>
                    </div>
                    <div class="text-center">
                        <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-home text-green-600"></i>
                        </div>
                        <p class="text-lg font-bold text-gray-800" id="familyStatus">-</p>
                        <p class="text-xs text-gray-500">Status dalam KK</p>
                    </div>
                </div>
            </div>

            <!-- Service History Card -->
            <div class="mobile-card mb-6">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-base font-semibold text-gray-800">Riwayat Layanan</h3>
                    <button onclick="showAllHistory()" class="text-blue-600 text-sm font-medium">Lihat Semua</button>
                </div>
                
                <div class="space-y-3" id="serviceHistory">
                    <!-- Service history will be loaded here -->
                    <div class="text-center py-6">
                        <i class="fas fa-clock text-gray-400 text-2xl mb-2"></i>
                        <p class="text-gray-500 text-sm">Memuat riwayat layanan...</p>
                    </div>
                </div>
            </div>

            <!-- Quick Actions Card -->
            <div class="mobile-card">
                <h3 class="text-base font-semibold text-gray-800 mb-4">Aksi Cepat</h3>
                
                <div class="grid grid-cols-2 gap-3">
                    <button onclick="navigateToService('surat-online')" class="info-card mobile-card text-center p-3 border border-green-200 hover:border-green-300">
                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-file-alt text-green-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Surat Online</h4>
                        <p class="text-gray-500 text-xs mt-1">Ajukan surat</p>
                    </button>

                    <button onclick="navigateToService('tracking-status')" class="info-card mobile-card text-center p-3 border border-yellow-200 hover:border-yellow-300">
                        <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-clock text-yellow-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Tracking</h4>
                        <p class="text-gray-500 text-xs mt-1">Cek status</p>
                    </button>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95 bottom-navigation">
            <div class="flex justify-around items-center">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">Portal</span>
                </button>
            </div>
        </div>
        
        <!-- Spacer for bottom navigation -->
        <div class="h-24"></div>
    </div>

    <!-- JavaScript -->
    <script>
        // Global variables
        let currentUser = null;
        let serviceHistoryData = [];

        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            checkAuthentication();
            loadUserData();
            loadServiceHistory();
        });

        // Check if user is authenticated
        function checkAuthentication() {
            const token = localStorage.getItem('portal_token');
            const user = localStorage.getItem('portal_user');
            
            if (!token || !user) {
                showCustomAlert('warning', 'Akses Ditolak', 'Silakan login terlebih dahulu', function() {
                    window.location.href = '/layanan-mandiri';
                });
                return false;
            }
            
            try {
                currentUser = JSON.parse(user);
                return true;
            } catch (e) {
                showCustomAlert('error', 'Error', 'Data user tidak valid', function() {
                    window.location.href = '/layanan-mandiri';
                });
                return false;
            }
        }

        // Load user data
        function loadUserData() {
            if (!currentUser) return;

            // Load basic info
            document.getElementById('userNIK').textContent = currentUser.nik || 'Tidak tersedia';
            document.getElementById('userFullName').textContent = currentUser.nama || 'Tidak tersedia';
            
            // Load additional data from API
            fetchRealUserData();

            // Set user avatar/photo/initials
            setUserAvatar();

            // Load service statistics
            loadServiceStats();
        }

        // Set user avatar with photo or initials fallback (same as profil-warga.php)
        function setUserAvatar() {
            const avatarContainer = document.getElementById('avatarContainer');
            const userInitials = document.getElementById('userInitials');
            const initialsText = document.getElementById('initialsText');
            
            // Set user initials for fallback
            if (currentUser && currentUser.nama) {
                const initials = getInitials(currentUser.nama);
                initialsText.textContent = initials;
            } else {
                initialsText.textContent = 'SW'; // Default initials
            }
            
            // Fetch real user data from database (same as profil-warga.php)
            if (currentUser && currentUser.nik) {
                fetchUserPhotoData(currentUser.nik);
            }
        }
        
        // Fetch user photo data from API (same pattern as profil-warga.php)
        async function fetchUserPhotoData(nik) {
            try {
                const response = await fetch('/api/v1/portal/user-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    const realUserData = result.data;
                    const profilePhoto = realUserData.foto; // Real photo from database
                    
                    const avatarContainer = document.getElementById('avatarContainer');
                    
                                         if (profilePhoto && profilePhoto.trim() !== '') {
                         // Show photo with fallback to initials (same as profil-warga.php)
                         avatarContainer.innerHTML = `<img src="/storage/${profilePhoto}" alt="Foto Profil" class="w-full h-full object-cover rounded-full" onerror="this.style.display='none'; this.parentNode.innerHTML='<div class=&quot;w-full h-full bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center&quot;><span class=&quot;text-white font-bold text-sm&quot;>${getInitials(realUserData.nama || 'NN')}</span></div>';">`;
                     } else {
                         // Show initials (same as profil-warga.php)
                         const initials = getInitials(realUserData.nama || 'NN');
                         avatarContainer.innerHTML = `<div class="w-full h-full bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center"><span class="text-white font-bold text-sm">${initials}</span></div>`;
                     }
                } else {
                    console.error('Failed to fetch user photo data:', result.message);
                    // Keep default fallback
                }
            } catch (error) {
                console.error('Error fetching user photo data:', error);
                // Keep default fallback
            }
        }
        
        // Get initials from name (same as profil-warga.php)
        function getInitials(name) {
            return name.split(' ')
                      .map(word => word.charAt(0))
                      .join('')
                      .substring(0, 2)
                      .toUpperCase();
        }

        // Fetch real user data from API
        async function fetchRealUserData() {
            if (!currentUser || !currentUser.nik) return;
            
            try {
                const response = await fetch('/api/v1/portal/user-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: currentUser.nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    const realUserData = result.data;
                    
                    // Update personal information with real data
                    document.getElementById('userBirth').textContent = 
                        `${realUserData.tempat_lahir || 'Tidak tersedia'}, ${realUserData.tanggal_lahir || 'Tidak tersedia'}`;
                    document.getElementById('userAddress').textContent = 
                        realUserData.alamat || 'Tidak tersedia';
                    document.getElementById('userMaritalStatus').textContent = 
                        realUserData.status_perkawinan || 'Tidak tersedia';
                    document.getElementById('userJob').textContent = 
                        realUserData.pekerjaan || 'Tidak tersedia';
                    
                    // Load family data
                    fetchFamilyData(currentUser.nik);
                }
            } catch (error) {
                console.error('Error fetching real user data:', error);
                // Set fallback values
                document.getElementById('userBirth').textContent = 'Tidak tersedia';
                document.getElementById('userAddress').textContent = 'Tidak tersedia';
                document.getElementById('userMaritalStatus').textContent = 'Tidak tersedia';
                document.getElementById('userJob').textContent = 'Tidak tersedia';
                document.getElementById('familySize').textContent = '-';
                document.getElementById('familyStatus').textContent = '-';
            }
        }

        // Fetch family data from API
        async function fetchFamilyData(nik) {
            try {
                const response = await fetch('/api/v1/portal/family-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    const familyData = result.data;
                    document.getElementById('familySize').textContent = familyData.total_members || '-';
                    document.getElementById('familyStatus').textContent = familyData.relationship || '-';
                } else {
                    document.getElementById('familySize').textContent = '-';
                    document.getElementById('familyStatus').textContent = '-';
                }
            } catch (error) {
                console.error('Error fetching family data:', error);
                document.getElementById('familySize').textContent = '-';
                document.getElementById('familyStatus').textContent = '-';
            }
        }

        // Load family details data for modal
        async function loadFamilyDetailsData() {
            if (!currentUser || !currentUser.nik) return;
            
            try {
                const response = await fetch('/api/v1/portal/family-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: currentUser.nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data && result.data.members) {
                    displayFamilyMembers(result.data.members);
                } else {
                    displayNoFamilyData();
                }
            } catch (error) {
                console.error('Error loading family details:', error);
                displayNoFamilyData();
            }
        }

        // Display family members in modal
        function displayFamilyMembers(members) {
            const container = document.getElementById('familyMembersList');
            
            if (!members || members.length === 0) {
                displayNoFamilyData();
                return;
            }

            const colors = ['blue', 'pink', 'green', 'yellow', 'purple', 'indigo'];
            container.innerHTML = members.map((member, index) => {
                const color = colors[index % colors.length];
                return `
                    <div class="flex items-center space-x-3 p-3 bg-${color}-50 rounded-xl">
                        <div class="w-8 h-8 bg-${color}-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-user text-${color}-600 text-sm"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 text-sm">${member.nama || 'Tidak tersedia'}</h4>
                            <p class="text-gray-500 text-xs">${member.hubungan || 'Tidak tersedia'}</p>
                        </div>
                    </div>
                `;
            }).join('');
        }

        // Display no family data message
        function displayNoFamilyData() {
            const container = document.getElementById('familyMembersList');
            container.innerHTML = `
                <div class="text-center py-6">
                    <i class="fas fa-users text-gray-400 text-2xl mb-2"></i>
                    <p class="text-gray-500 text-sm">Data keluarga tidak tersedia</p>
                </div>
            `;
        }

        // Load service statistics from API
        async function loadServiceStats() {
            if (!currentUser || !currentUser.nik) return;
            
            try {
                const response = await fetch('/api/v1/portal/user-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: currentUser.nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    // For now, show placeholder values since we don't have service statistics in the API yet
                    document.getElementById('totalSurat').textContent = '-';
                    document.getElementById('suratProses').textContent = '-';
                    document.getElementById('suratSelesai').textContent = '-';
                }
            } catch (error) {
                console.error('Error loading service stats:', error);
                document.getElementById('totalSurat').textContent = '-';
                document.getElementById('suratProses').textContent = '-';
                document.getElementById('suratSelesai').textContent = '-';
            }
        }

        // Load service history from API
        async function loadServiceHistory() {
            if (!currentUser || !currentUser.nik) return;
            
            try {
                // For now, show empty state since we don't have service history API yet
                serviceHistoryData = [];
                displayServiceHistory([]);
            } catch (error) {
                console.error('Error loading service history:', error);
                serviceHistoryData = [];
                displayServiceHistory([]);
            }
        }

        // Display service history
        function displayServiceHistory(data) {
            const container = document.getElementById('serviceHistory');
            
            if (data.length === 0) {
                container.innerHTML = `
                    <div class="text-center py-6">
                        <i class="fas fa-clock text-gray-400 text-2xl mb-2"></i>
                        <p class="text-gray-500 text-sm">Belum ada riwayat layanan</p>
                    </div>
                `;
                return;
            }

            container.innerHTML = data.map(item => `
                <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl hover:bg-gray-100 cursor-pointer" onclick="showServiceDetail(${item.id})">
                    <div class="w-8 h-8 bg-${item.color}-100 rounded-full flex items-center justify-center">
                        <i class="${item.icon} text-${item.color}-600 text-sm"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-semibold text-gray-800 text-sm">${item.type}</h4>
                        <p class="text-gray-500 text-xs">${item.date}</p>
                    </div>
                    <span class="status-badge status-${item.status}">${item.statusText}</span>
                </div>
            `).join('');
        }

        // Navigation functions
        function navigateToService(service) {
            switch(service) {
                case '/':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/dashboard-warga';
                    break;
                case 'surat-online':
                    showCustomAlert('info', 'Dalam Pengembangan', 'Fitur surat online sedang dalam pengembangan');
                    break;
                case 'tracking-status':
                    showCustomAlert('info', 'Dalam Pengembangan', 'Fitur tracking status sedang dalam pengembangan');
                    break;
                default:
                    showCustomAlert('info', 'Dalam Pengembangan', 'Fitur ' + service + ' sedang dalam pengembangan');
            }
        }

        // Show edit profile modal
        function showEditProfile() {
            showCustomAlert('info', 'Segera Hadir', 'Fitur edit profil akan segera tersedia untuk memudahkan Anda mengupdate data pribadi.');
        }

        // Show family details modal
        function showFamilyDetails() {
            loadFamilyDetailsData();
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm max-h-96 overflow-y-auto mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-users text-blue-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Detail Keluarga</h3>
                        <p class="text-gray-600 text-sm">Informasi anggota keluarga</p>
                    </div>
                    
                    <div class="space-y-3" id="familyMembersList">
                        <div class="text-center py-6">
                            <i class="fas fa-clock text-gray-400 text-2xl mb-2"></i>
                            <p class="text-gray-500 text-sm">Memuat data keluarga...</p>
                        </div>
                    </div>
                    
                    <button onclick="closeModal()" class="w-full bg-blue-600 text-white py-3 rounded-xl font-semibold hover:bg-blue-700 transition-all mt-4">
                        Tutup
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Show all service history
        function showAllHistory() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            
            const allHistoryHTML = serviceHistoryData.map(item => `
                <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl hover:bg-gray-100 cursor-pointer" onclick="showServiceDetail(${item.id})">
                    <div class="w-8 h-8 bg-${item.color}-100 rounded-full flex items-center justify-center">
                        <i class="${item.icon} text-${item.color}-600 text-sm"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-semibold text-gray-800 text-sm">${item.type}</h4>
                        <p class="text-gray-500 text-xs">${item.date}</p>
                    </div>
                    <span class="status-badge status-${item.status}">${item.statusText}</span>
                </div>
            `).join('');

            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm max-h-96 overflow-y-auto mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Riwayat Lengkap</h3>
                        <p class="text-gray-600 text-sm">Semua aktivitas layanan Anda</p>
                    </div>
                    
                    <div class="space-y-3">
                        ${allHistoryHTML}
                    </div>
                    
                    <button onclick="closeModal()" class="w-full bg-gray-600 text-white py-3 rounded-xl font-semibold hover:bg-gray-700 transition-all mt-4">
                        Tutup
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Show service detail
        function showServiceDetail(serviceId) {
            const service = serviceHistoryData.find(s => s.id === serviceId);
            if (!service) return;

            closeModal(); // Close current modal first

            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-${service.color}-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="${service.icon} text-${service.color}-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${service.type}</h3>
                        <span class="status-badge status-${service.status}">${service.statusText}</span>
                    </div>
                    
                    <div class="space-y-4">
                        <div class="p-3 bg-gray-50 rounded-xl">
                            <h4 class="font-semibold text-gray-800 text-sm mb-2">Timeline Pengajuan:</h4>
                            <div class="space-y-2 text-xs text-gray-600">
                                <div class="flex items-center space-x-2">
                                    <div class="w-2 h-2 bg-green-500 rounded-full"></div>
                                    <span>Pengajuan diterima - ${service.date}</span>
                                </div>
                                ${service.status === 'process' ? `
                                    <div class="flex items-center space-x-2">
                                        <div class="w-2 h-2 bg-yellow-500 rounded-full"></div>
                                        <span>Sedang diproses - 1 hari lalu</span>
                                    </div>
                                ` : `
                                    <div class="flex items-center space-x-2">
                                        <div class="w-2 h-2 bg-green-500 rounded-full"></div>
                                        <span>Selesai diproses - 1 hari lalu</span>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <div class="w-2 h-2 bg-green-500 rounded-full"></div>
                                        <span>Siap diambil - ${service.date}</span>
                                    </div>
                                `}
                            </div>
                        </div>
                        
                        <div class="p-3 bg-blue-50 rounded-xl">
                            <p class="text-xs text-gray-700"><strong>Nomor Pengajuan:</strong> ${service.type.replace(/\s/g, '').toUpperCase()}${service.id.toString().padStart(3, '0')}</p>
                            <p class="text-xs text-gray-700"><strong>Estimasi Selesai:</strong> 3-5 hari kerja</p>
                            <p class="text-xs text-gray-700"><strong>Biaya:</strong> Gratis</p>
                        </div>
                        
                        <button onclick="closeModal()" class="w-full bg-${service.color}-600 text-white py-3 rounded-xl font-semibold hover:bg-${service.color}-700 transition-all">
                            Tutup
                        </button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Close Modal
        function closeModal() {
            const modals = document.querySelectorAll('.fixed.inset-0');
            modals.forEach(modal => {
                if (modal.classList.contains('bg-black')) {
                    modal.remove();
                }
            });
        }

        // Custom Alert Modal Function
        function showCustomAlert(type, title, message, callback) {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            
            let iconClass, iconColor, buttonColor;
            switch(type) {
                case 'warning':
                    iconClass = 'fas fa-exclamation-triangle';
                    iconColor = 'yellow';
                    buttonColor = 'yellow';
                    break;
                case 'error':
                    iconClass = 'fas fa-times-circle';
                    iconColor = 'red';
                    buttonColor = 'red';
                    break;
                case 'success':
                    iconClass = 'fas fa-check-circle';
                    iconColor = 'green';
                    buttonColor = 'green';
                    break;
                case 'info':
                default:
                    iconClass = 'fas fa-info-circle';
                    iconColor = 'blue';
                    buttonColor = 'blue';
                    break;
            }
            
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-${iconColor}-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="${iconClass} text-${iconColor}-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${title}</h3>
                        <p class="text-gray-600 text-sm">${message}</p>
                    </div>
                    
                    <button onclick="closeCustomAlert()" class="w-full bg-${buttonColor}-600 text-white py-3 rounded-xl font-semibold hover:bg-${buttonColor}-700 transition-all">
                        OK
                    </button>
                </div>
            `;
            
            modal.id = 'customAlertModal';
            document.body.appendChild(modal);
            
            // Store callback for when modal is closed
            window.customAlertCallback = callback;
        }

        // Close Custom Alert Modal
        function closeCustomAlert() {
            const modal = document.getElementById('customAlertModal');
            if (modal) {
                modal.remove();
            }
            
            // Execute callback if provided
            if (window.customAlertCallback) {
                window.customAlertCallback();
                window.customAlertCallback = null;
            }
        }
    </script>
</body>
</html> 