<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Warga - Portal Layanan Mandiri</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .service-card {
            transition: all 0.3s ease;
        }
        
        .service-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-pending { background: #fef3c7; color: #92400e; }
        .status-process { background: #dbeafe; color: #1e40af; }
        .status-done { background: #d1fae5; color: #065f46; }

        /* Prevent navbar jump when SweetAlert2 opens */
        body.swal2-shown:not(.swal2-no-backdrop):not(.swal2-toast-shown) {
            padding-right: 0 !important;
            overflow-y: scroll !important;
        }
        
        .swal2-popup {
            padding-right: 0 !important;
        }
        
        .swal2-container {
            padding-right: 0 !important;
            -webkit-backdrop-filter: blur(4px);
            backdrop-filter: blur(4px);
        }

        /* Ensure fixed elements stay in place */
        .fixed {
            padding-right: 0 !important;
        }

        /* Prevent navigation button shift */
        .max-w-md {
            padding-right: 0 !important;
        }

        /* Keep bottom navigation fixed */
        .bottom-navigation {
            padding-right: 0 !important;
            z-index: 40;
        }

        /* Ensure modal appears above navigation */
        .swal2-container {
            z-index: 9999 !important;
        }

        /* Prevent background shift */
        html.swal2-shown {
            overflow-y: scroll !important;
            position: fixed !important;
            width: 100% !important;
            padding-right: 0 !important;
        }

        /* Prevent content jump */
        .swal2-shown .max-w-md {
            transform: none !important;
        }
        
        /* FontAwesome fallback with !important for all icons */
        .fas.fa-user:before, .fa.fa-user:before { content: "👤" !important; font-family: system-ui !important; }
        .fas.fa-sign-out-alt:before, .fa.fa-sign-out:before { content: "🚪" !important; font-family: system-ui !important; }
        .fas.fa-tachometer-alt:before, .fa.fa-dashboard:before { content: "📊" !important; font-family: system-ui !important; }
        .fas.fa-file-alt:before, .fa.fa-file:before { content: "📄" !important; font-family: system-ui !important; }
        .fas.fa-search:before, .fa.fa-search:before { content: "🔍" !important; font-family: system-ui !important; }
        .fas.fa-exclamation-triangle:before, .fa.fa-warning:before { content: "⚠️" !important; font-family: system-ui !important; }
        .fas.fa-bell:before, .fa.fa-bell:before { content: "🔔" !important; font-family: system-ui !important; }
        .fas.fa-user-circle:before, .fa.fa-user-circle:before { content: "👤" !important; font-family: system-ui !important; }
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-chevron-right:before, .fa.fa-chevron-right:before { content: "▶️" !important; font-family: system-ui !important; }
        .fas.fa-briefcase:before, .fa.fa-briefcase:before { content: "💼" !important; font-family: system-ui !important; }
        .fas.fa-hand-holding-heart:before, .fa.fa-hand-holding-heart:before { content: "🤲" !important; font-family: system-ui !important; }
        .fas.fa-clock:before, .fa.fa-clock:before { content: "🕐" !important; font-family: system-ui !important; }
        .fas.fa-file-text:before, .fa.fa-file-text:before { content: "📝" !important; font-family: system-ui !important; }
        .fas.fa-key:before, .fa.fa-key:before { content: "🔑" !important; font-family: system-ui !important; }
        .fas.fa-check:before, .fa.fa-check:before { content: "✅" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fas.fa-times-circle:before, .fa.fa-times-circle:before { content: "❌" !important; font-family: system-ui !important; }
        .fas.fa-check-circle:before, .fa.fa-check-circle:before { content: "✅" !important; font-family: system-ui !important; }
        .fas.fa-info-circle:before, .fa.fa-info-circle:before { content: "ℹ️" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="gradient-bg px-6 py-6 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center overflow-hidden relative">
                        <img id="userAvatar" src="" alt="User Avatar" class="w-full h-full object-cover rounded-full hidden">
                        <div id="userInitials" class="w-full h-full bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center hidden">
                            <span class="text-white font-bold text-sm" id="initialsText"></span>
                        </div>
                        <i id="defaultIcon" class="fas fa-user text-white text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-lg font-bold text-white">Selamat Datang</h1>
                        <p class="text-white/80 text-sm" id="userName">Loading...</p>
                    </div>
                </div>
                <button onclick="logout()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
                    <i class="fas fa-sign-out-alt text-white"></i>
                </button>
            </div>

            <!-- Quick Stats -->
            <div class="grid grid-cols-3 gap-3">
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white" id="totalSurat">-</div>
                    <div class="text-white/80 text-xs">Surat Diajukan</div>
                </div>
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white" id="suratProses">-</div>
                    <div class="text-white/80 text-xs">Dalam Proses</div>
                </div>
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white" id="suratSelesai">-</div>
                    <div class="text-white/80 text-xs">Selesai</div>
                </div>
            </div>
            </div>
        </div>

        <!-- Services Menu -->
        <div class="px-6 -mt-6 relative z-20 mb-6">
            <div class="mobile-card">
                <h3 class="text-base font-semibold text-gray-800 mb-3">Layanan Portal Mandiri</h3>
                
                <div class="grid grid-cols-3 gap-2">
                    <!-- Dashboard Personal -->
                    <button onclick="navigateToService('dashboard-personal')" class="service-card mobile-card text-center p-3 border border-blue-200 hover:border-blue-300">
                        <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-tachometer-alt text-blue-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Dashboard</h4>
                        <p class="text-gray-500 text-xs mt-1 leading-tight">Data pribadi</p>
                    </button>

                    <!-- Surat Online -->
                    <button onclick="navigateToService('surat-online')" class="service-card mobile-card text-center p-3 border border-green-200 hover:border-green-300">
                        <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-file-alt text-green-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Surat Online</h4>
                        <p class="text-gray-500 text-xs mt-1 leading-tight">Tanpa antri</p>
                    </button>

                    <!-- Tracking Status -->
                    <button onclick="navigateToService('tracking-status')" class="service-card mobile-card text-center p-3 border border-yellow-200 hover:border-yellow-300">
                        <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-search text-yellow-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Tracking</h4>
                        <p class="text-gray-500 text-xs mt-1 leading-tight">Pantau status</p>
                    </button>

                    <!-- Pengaduan -->
                    <button onclick="navigateToService('pengaduan')" class="service-card mobile-card text-center p-3 border border-red-200 hover:border-red-300">
                        <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-exclamation-triangle text-red-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Pengaduan</h4>
                        <p class="text-gray-500 text-xs mt-1 leading-tight">Lapor masalah</p>
                    </button>

                    <!-- Notifikasi -->
                    <button onclick="navigateToService('notifikasi')" class="service-card mobile-card text-center p-3 border border-purple-200 hover:border-purple-300">
                        <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-bell text-purple-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Notifikasi</h4>
                        <p class="text-gray-500 text-xs mt-1 leading-tight">Update WA</p>
                    </button>

                    <!-- Profil Warga -->
                    <button onclick="navigateToService('profil-warga')" class="service-card mobile-card text-center p-3 border border-indigo-200 hover:border-indigo-300">
                        <div class="w-8 h-8 bg-indigo-100 rounded-lg flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-user-circle text-indigo-600 text-sm"></i>
                        </div>
                        <h4 class="font-semibold text-gray-800 text-xs">Profil</h4>
                        <p class="text-gray-500 text-xs mt-1 leading-tight">Data keluarga</p>
                    </button>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="px-6 mb-6">
            <div class="mobile-card">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Aksi Cepat</h3>
                
                <div class="grid grid-cols-1 gap-3">
                    <button onclick="navigateToService('surat-keterangan-domisili')" class="flex items-center space-x-3 p-3 bg-blue-50 rounded-xl hover:bg-blue-100 transition-colors">
                        <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-home text-blue-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Domisili</h4>
                            <p class="text-gray-500 text-xs">Ajukan surat domisili baru</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>

                    <button onclick="navigateToService('surat-keterangan-usaha')" class="flex items-center space-x-3 p-3 bg-green-50 rounded-xl hover:bg-green-100 transition-colors">
                        <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-briefcase text-green-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Usaha</h4>
                            <p class="text-gray-500 text-xs">Untuk keperluan usaha/bisnis</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>

                    <button onclick="navigateToService('surat-keterangan-tidak-mampu')" class="flex items-center space-x-3 p-3 bg-yellow-50 rounded-xl hover:bg-yellow-100 transition-colors">
                        <div class="w-10 h-10 bg-yellow-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-hand-holding-heart text-yellow-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Tidak Mampu</h4>
                            <p class="text-gray-500 text-xs">Untuk bantuan sosial</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Notifications -->
        <div class="px-6 mb-8">
            <div class="mobile-card bg-gradient-to-r from-blue-50 to-purple-50 border border-blue-200">
                <div class="flex items-start space-x-3">
                    <div class="w-10 h-10 bg-blue-100 rounded-xl flex items-center justify-center flex-shrink-0">
                        <i class="fas fa-bell text-blue-600"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-semibold text-gray-800 text-sm mb-2">Notifikasi Terbaru</h4>
                        <div class="space-y-2">
                            <div class="text-xs text-gray-600 bg-white/60 p-2 rounded-lg">
                                <strong>Surat Keterangan Domisili</strong> Anda sedang dalam proses verifikasi. Estimasi selesai: 2 hari kerja.
                            </div>
                            <div class="text-xs text-gray-600 bg-white/60 p-2 rounded-lg">
                                Sistem akan maintenance pada <strong>Sabtu, 25 Jan 2025</strong> pukul 01:00-03:00 WIB.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activities -->
        <div class="px-6 mb-6">
            <div class="mobile-card">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-semibold text-gray-800">Aktivitas Terbaru</h3>
                    <button onclick="navigateToService('riwayat-lengkap')" class="text-blue-600 text-sm font-medium">Lihat Semua</button>
                </div>
                
                <div class="space-y-3">
                    <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                        <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-file-alt text-blue-600"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Domisili</h4>
                            <p class="text-gray-500 text-xs">Diajukan 2 hari lalu</p>
                        </div>
                        <span class="px-2 py-1 bg-yellow-100 text-yellow-800 text-xs rounded-full font-medium">Proses</span>
                    </div>

                    <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                        <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-file-alt text-green-600"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Usaha</h4>
                            <p class="text-gray-500 text-xs">Selesai 5 hari lalu</p>
                        </div>
                        <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full font-medium">Selesai</span>
                    </div>

                    <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                        <div class="w-10 h-10 bg-red-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-exclamation-triangle text-red-600"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 text-sm">Pengaduan Jalan Rusak</h4>
                            <p class="text-gray-500 text-xs">Direspon 1 minggu lalu</p>
                        </div>
                        <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full font-medium">Selesai</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToHome()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToBerita()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToWisata()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToUmkm()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">Portal</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <script>
        // Check authentication and load user data
        document.addEventListener('DOMContentLoaded', function() {
            checkAuthentication();
            loadUserData();
            
            // Simple fade-in animation for cards
            const cards = document.querySelectorAll('.mobile-card');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                setTimeout(() => {
                    card.style.transition = 'all 0.5s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 100);
            });
        });
        
        // Check if user is authenticated
        function checkAuthentication() {
            const portalToken = localStorage.getItem('portal_token');
            const portalUser = localStorage.getItem('portal_user');
            const portalNik = localStorage.getItem('portal_nik');
            
            if (!portalToken || !portalUser || !portalNik) {
                showCustomAlert('warning', 'Belum Login', 'Anda belum login. Silakan login terlebih dahulu.', function() {
                    window.location.href = '/layanan-mandiri';
                });
                return;
            }
            
            // Validate user data
            try {
                const userData = JSON.parse(portalUser);
                if (!userData.nik || userData.nik !== portalNik) {
                    throw new Error('Invalid user data');
                }
            } catch (error) {
                console.error('Invalid user data:', error);
                localStorage.removeItem('portal_token');
                localStorage.removeItem('portal_user');
                localStorage.removeItem('portal_nik');
                showCustomAlert('error', 'Data Tidak Valid', 'Data login tidak valid. Silakan login ulang.', function() {
                    window.location.href = '/layanan-mandiri';
                });
                return;
            }
        }
        
        // Load user data from localStorage
        function loadUserData() {
            try {
                const portalUser = localStorage.getItem('portal_user');
                if (portalUser) {
                    const userData = JSON.parse(portalUser);
                    document.getElementById('userName').textContent = userData.nama || 'Warga';
                    
                    // Fetch real user data from database (same as profile page)
                    fetchUserData(userData.nik);
                    
                    // Check for change password requirement
                    const urlParams = new URLSearchParams(window.location.search);
                    if (urlParams.get('change_password') === '1') {
                        showChangePasswordModal();
                    }
                }
            } catch (error) {
                console.error('Error loading user data:', error);
                document.getElementById('userName').textContent = 'Warga';
                showDefaultAvatar();
            }
        }

        // Fetch user data from API (same as profile page)
        async function fetchUserData(nik) {
            try {
                const response = await fetch('/api/v1/portal/user-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    // Update user data with real data from database
                    const realUserData = result.data;
                    
                    // Update user name
                    document.getElementById('userName').textContent = realUserData.nama || 'Warga';
                    
                    // Load user avatar with real photo data
                    loadUserAvatar(realUserData);
                    
                    // Load statistics data
                    fetchStatistics(nik);
                } else {
                    console.error('Failed to fetch user data:', result.message);
                    // Fallback to default avatar
                    showDefaultAvatar();
                }
            } catch (error) {
                console.error('Error fetching user data:', error);
                // Fallback to default avatar
                showDefaultAvatar();
            }
        }

        // Fetch statistics data from database
        async function fetchStatistics(nik) {
            try {
                const response = await fetch('/api/v1/portal/statistics', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    // Update statistics with real data
                    const stats = result.data;
                    document.getElementById('totalSurat').textContent = stats.total_surat || '0';
                    document.getElementById('suratProses').textContent = stats.surat_proses || '0';
                    document.getElementById('suratSelesai').textContent = stats.surat_selesai || '0';
                } else {
                    console.error('Failed to fetch statistics:', result.message);
                    // Show zero if failed
                    document.getElementById('totalSurat').textContent = '0';
                    document.getElementById('suratProses').textContent = '0';
                    document.getElementById('suratSelesai').textContent = '0';
                }
            } catch (error) {
                console.error('Error fetching statistics:', error);
                // Show zero if error
                document.getElementById('totalSurat').textContent = '0';
                document.getElementById('suratProses').textContent = '0';
                document.getElementById('suratSelesai').textContent = '0';
            }
        }

        // Load user avatar (same pattern as profile page)
        function loadUserAvatar(userData) {
            const avatarContainer = document.querySelector('.w-12.h-12.bg-white\\/20.rounded-full');
            const profilePhoto = userData.foto; // Real photo from database
            
            if (profilePhoto && profilePhoto.trim() !== '') {
                // Show photo with fallback to initials (same as profile page)
                avatarContainer.innerHTML = `<img src="/storage/${profilePhoto}" alt="Foto Profil" class="w-full h-full object-cover rounded-full" onerror="this.style.display='none'; this.parentNode.innerHTML='${getInitials(userData.nama || 'NN')}'">`;
            } else {
                // Show initials (same as profile page)
                const initials = getInitials(userData.nama || 'NN');
                avatarContainer.innerHTML = initials;
            }
        }

        // Get initials from name (same as profile page)
        function getInitials(name) {
            return name.split(' ')
                      .map(word => word.charAt(0))
                      .join('')
                      .substring(0, 2)
                      .toUpperCase();
        }

        // Show initials avatar
        function showInitialsAvatar(nama) {
            const userAvatar = document.getElementById('userAvatar');
            const userInitials = document.getElementById('userInitials');
            const initialsText = document.getElementById('initialsText');
            const defaultIcon = document.getElementById('defaultIcon');
            
            if (nama && nama.trim() !== '') {
                // Generate initials
                const nameParts = nama.trim().split(' ');
                let initials = '';
                if (nameParts.length >= 2) {
                    initials = nameParts[0].charAt(0) + nameParts[1].charAt(0);
                } else {
                    initials = nameParts[0].charAt(0) + (nameParts[0].charAt(1) || '');
                }
                
                initialsText.textContent = initials.toUpperCase();
                userInitials.classList.remove('hidden');
                userAvatar.classList.add('hidden');
                defaultIcon.classList.add('hidden');
            } else {
                showDefaultAvatar();
            }
        }

        // Show default avatar
        function showDefaultAvatar() {
            const userAvatar = document.getElementById('userAvatar');
            const userInitials = document.getElementById('userInitials');
            const defaultIcon = document.getElementById('defaultIcon');
            
            userAvatar.classList.add('hidden');
            userInitials.classList.add('hidden');
            defaultIcon.classList.remove('hidden');
        }
        
        // Show change password modal
        function showChangePasswordModal() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-key text-yellow-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Ubah Password</h3>
                        <p class="text-gray-600 text-sm">Anda perlu mengubah password default untuk keamanan akun</p>
                    </div>
                    
                    <div class="space-y-4">
                        <div class="p-3 bg-yellow-50 rounded-xl">
                            <p class="text-sm text-gray-700 mb-2"><strong>Password saat ini:</strong> 6 digit terakhir NIK</p>
                            <p class="text-xs text-gray-600">Untuk keamanan, silakan ubah password Anda dengan yang lebih kuat.</p>
                        </div>
                        
                        <button onclick="showCustomAlert('info', 'Segera Hadir', 'Fitur ubah password akan segera tersedia'); closeModal();" class="w-full bg-yellow-600 text-white py-3 rounded-xl font-semibold hover:bg-yellow-700 transition-all">
                            Ubah Password Sekarang
                        </button>
                        
                        <button onclick="closeModal()" class="w-full text-gray-500 py-2 font-medium">
                            Nanti Saja
                        </button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Navigation Functions
        function navigateToService(serviceType) {
            switch(serviceType) {
                case 'dashboard-personal':
                    window.location.href = '/dashboard-personal';
                    break;
                case 'surat-online':
                    window.location.href = '/surat-online';
                    break;
                case 'tracking-status':
                    showFeatureDetail('Tracking Status', 'Pantau progress pengajuan', 'fas fa-search', 'yellow');
                    break;
                case 'pengaduan':
                    showFeatureDetail('Pengaduan', 'Laporkan masalah dengan mudah', 'fas fa-exclamation-triangle', 'red');
                    break;
                case 'notifikasi':
                    showFeatureDetail('Notifikasi', 'Update real-time via WhatsApp', 'fas fa-bell', 'purple');
                    break;
                case 'profil-warga':
                    window.location.href = '/profil-warga';
                    break;
                case 'surat-keterangan-domisili':
                    showSuratForm('Surat Keterangan Domisili');
                    break;
                case 'surat-keterangan-usaha':
                    showSuratForm('Surat Keterangan Usaha');
                    break;
                case 'surat-keterangan-tidak-mampu':
                    showSuratForm('Surat Keterangan Tidak Mampu');
                    break;
                case 'riwayat-lengkap':
                    showRiwayatLengkap();
                    break;
                case 'tracking':
                    showFeatureDetail('Tracking Status', 'Pantau progress pengajuan', 'fas fa-search', 'yellow');
                    break;
                case 'profil':
                    window.location.href = '/profil-warga';
                    break;
                default:
                    showCustomAlert('info', 'Dalam Pengembangan', 'Fitur ' + serviceType + ' sedang dalam pengembangan');
            }
        }

        // New Navigation Functions for consistency
        function navigateToHome() {
            window.location.href = '/';
        }

        function navigateToBerita() {
            window.location.href = '/berita';
        }

        function navigateToWisata() {
            window.location.href = '/wisata';
        }

        function navigateToUmkm() {
            window.location.href = '/produk-umkm';
        }

        // Show Feature Detail Modal
        function showFeatureDetail(title, description, icon, color) {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-${color}-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="${icon} text-${color}-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${title}</h3>
                        <p class="text-gray-600 text-sm">${description}</p>
                    </div>
                    
                    <div class="space-y-3">
                        <div class="p-3 bg-gray-50 rounded-xl">
                            <p class="text-sm text-gray-700 mb-2"><strong>Status:</strong> Dalam Pengembangan</p>
                            <p class="text-xs text-gray-600">Fitur ini sedang dikembangkan dan akan segera tersedia untuk meningkatkan layanan portal warga.</p>
                        </div>
                        
                        <button onclick="closeModal()" class="w-full bg-${color}-600 text-white py-3 rounded-xl font-semibold hover:bg-${color}-700 transition-all">
                            Tutup
                        </button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Show Surat Form Modal
        function showSuratForm(jenisSurat) {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-file-alt text-blue-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${jenisSurat}</h3>
                        <p class="text-gray-600 text-sm">Form pengajuan surat online</p>
                    </div>
                    
                    <div class="space-y-4">
                        <div class="p-3 bg-blue-50 rounded-xl">
                            <h4 class="font-semibold text-gray-800 text-sm mb-2">Persyaratan:</h4>
                            <ul class="text-xs text-gray-600 space-y-1">
                                <li>• Fotocopy KTP yang masih berlaku</li>
                                <li>• Fotocopy Kartu Keluarga</li>
                                <li>• Surat pengantar RT/RW</li>
                                <li>• Materai 10.000</li>
                            </ul>
                        </div>
                        
                        <div class="p-3 bg-yellow-50 rounded-xl">
                            <p class="text-xs text-gray-700"><strong>Estimasi Selesai:</strong> 3-5 hari kerja</p>
                            <p class="text-xs text-gray-700"><strong>Biaya:</strong> Gratis</p>
                        </div>
                        
                        <button onclick="showCustomAlert('info', 'Segera Hadir', 'Form pengajuan akan segera tersedia')" class="w-full bg-blue-600 text-white py-3 rounded-xl font-semibold hover:bg-blue-700 transition-all">
                            Ajukan Sekarang
                        </button>
                        
                        <button onclick="closeModal()" class="w-full text-gray-500 py-2 font-medium">
                            Batalkan
                        </button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Show Riwayat Lengkap
        function showRiwayatLengkap() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm max-h-96 overflow-y-auto mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Riwayat Lengkap</h3>
                        <p class="text-gray-600 text-sm">Semua aktivitas layanan Anda</p>
                    </div>
                    
                    <div class="space-y-3">
                        <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                            <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-file-alt text-blue-600 text-sm"></i>
                            </div>
                            <div class="flex-1">
                                <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Domisili</h4>
                                <p class="text-gray-500 text-xs">2 hari lalu</p>
                            </div>
                            <span class="px-2 py-1 bg-yellow-100 text-yellow-800 text-xs rounded-full">Proses</span>
                        </div>
                        
                        <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                            <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-file-alt text-green-600 text-sm"></i>
                            </div>
                            <div class="flex-1">
                                <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Usaha</h4>
                                <p class="text-gray-500 text-xs">5 hari lalu</p>
                            </div>
                            <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full">Selesai</span>
                        </div>
                        
                        <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                            <div class="w-8 h-8 bg-red-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-exclamation-triangle text-red-600 text-sm"></i>
                            </div>
                            <div class="flex-1">
                                <h4 class="font-semibold text-gray-800 text-sm">Pengaduan Jalan Rusak</h4>
                                <p class="text-gray-500 text-xs">1 minggu lalu</p>
                            </div>
                            <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full">Selesai</span>
                        </div>
                        
                        <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                            <div class="w-8 h-8 bg-purple-100 rounded-full flex items-center justify-center">
                                <i class="fas fa-file-alt text-purple-600 text-sm"></i>
                            </div>
                            <div class="flex-1">
                                <h4 class="font-semibold text-gray-800 text-sm">Surat Keterangan Tidak Mampu</h4>
                                <p class="text-gray-500 text-xs">2 minggu lalu</p>
                            </div>
                            <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full">Selesai</span>
                        </div>
                    </div>
                    
                    <button onclick="closeModal()" class="w-full bg-gray-600 text-white py-3 rounded-xl font-semibold hover:bg-gray-700 transition-all mt-4">
                        Tutup
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Close Modal
        function closeModal() {
            const modals = document.querySelectorAll('.fixed.inset-0');
            modals.forEach(modal => {
                if (modal.classList.contains('bg-black')) {
                    modal.remove();
                }
            });
        }

        // Logout Function
        function logout() {
            showLogoutModal();
        }

        // Show logout confirmation modal
        function showLogoutModal() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-sign-out-alt text-blue-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Konfirmasi Logout</h3>
                        <p class="text-gray-600 text-sm">Apakah Anda yakin ingin keluar dari Portal Layanan Mandiri?</p>
                    </div>
                    
                    <div class="space-y-3">
                        <button onclick="confirmLogout()" class="w-full bg-blue-600 text-white py-3 rounded-xl font-semibold hover:bg-blue-700 transition-all">
                            Ya, Logout
                        </button>
                        
                        <button onclick="closeModal()" class="w-full bg-gray-500 text-white py-3 rounded-xl font-semibold hover:bg-gray-600 transition-all">
                            Batal
                        </button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Confirm logout action
        function confirmLogout() {
            // Close current modal
            closeModal();
            
            // Clear localStorage
            localStorage.removeItem('portal_token');
            localStorage.removeItem('portal_user');
            localStorage.removeItem('portal_nik');
            
            // Show logout success message
            showLogoutSuccessModal();
        }

        // Show logout success modal
        function showLogoutSuccessModal() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-check text-green-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Logout Berhasil</h3>
                        <p class="text-gray-600 text-sm">Terima kasih telah menggunakan Portal Layanan Mandiri.</p>
                    </div>
                    
                    <button onclick="redirectToHome()" class="w-full bg-green-600 text-white py-3 rounded-xl font-semibold hover:bg-green-700 transition-all">
                        OK
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Redirect to home page
        function redirectToHome() {
            window.location.href = '/layanan-mandiri';
        }

        // Custom Alert Modal Function
        function showCustomAlert(type, title, message, callback) {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            
            let iconClass, iconColor, buttonColor;
            switch(type) {
                case 'warning':
                    iconClass = 'fas fa-exclamation-triangle';
                    iconColor = 'yellow';
                    buttonColor = 'yellow';
                    break;
                case 'error':
                    iconClass = 'fas fa-times-circle';
                    iconColor = 'red';
                    buttonColor = 'red';
                    break;
                case 'success':
                    iconClass = 'fas fa-check-circle';
                    iconColor = 'green';
                    buttonColor = 'green';
                    break;
                case 'info':
                default:
                    iconClass = 'fas fa-info-circle';
                    iconColor = 'blue';
                    buttonColor = 'blue';
                    break;
            }
            
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-${iconColor}-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="${iconClass} text-${iconColor}-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${title}</h3>
                        <p class="text-gray-600 text-sm">${message}</p>
                    </div>
                    
                    <button onclick="closeCustomAlert()" class="w-full bg-${buttonColor}-600 text-white py-3 rounded-xl font-semibold hover:bg-${buttonColor}-700 transition-all">
                        OK
                    </button>
                </div>
            `;
            
            modal.id = 'customAlertModal';
            document.body.appendChild(modal);
            
            // Store callback for when modal is closed
            window.customAlertCallback = callback;
        }

        // Close Custom Alert Modal
        function closeCustomAlert() {
            const modal = document.getElementById('customAlertModal');
            if (modal) {
                modal.remove();
            }
            
            // Execute callback if provided
            if (window.customAlertCallback) {
                window.customAlertCallback();
                window.customAlertCallback = null;
            }
        }

        // Auto refresh notifications every 30 seconds
        setInterval(function() {
            // In real app, this would fetch new notifications from server
            console.log('Checking for new notifications...');
        }, 30000);
    </script>
</body>
</html> 