<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pembayaran Tiket - {{destinasi_wisata}}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-bottom: 16px;
            border: 1px solid #f0f0f0;
        }
        
        .payment-method {
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 12px;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .payment-method.active {
            border-color: #3b82f6;
            background-color: #eff6ff;
        }
        
        .qr-code {
            width: 200px;
            height: 200px;
            background: white;
            border: 1px solid #e5e7eb;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
        }
        
        .countdown {
            font-family: 'Courier New', monospace;
            font-size: 1.5rem;
            font-weight: bold;
            color: #dc2626;
        }
        
        /* FontAwesome fallback with emoji */
        .fab.fa-whatsapp:before, .fa.fa-whatsapp:before { content: "💬" !important; font-family: system-ui !important; }
        .fas.fa-phone:before, .fa.fa-phone:before { content: "📞" !important; font-family: system-ui !important; }
        .fas.fa-arrow-left:before, .fa.fa-arrow-left:before { content: "⬅️" !important; font-family: system-ui !important; }
        .fas.fa-credit-card:before, .fa.fa-credit-card:before { content: "💳" !important; font-family: system-ui !important; }
        .fas.fa-copy:before, .fa.fa-copy:before { content: "📋" !important; font-family: system-ui !important; }
        .fas.fa-cloud-upload-alt:before, .fa.fa-cloud-upload:before { content: "☁️" !important; font-family: system-ui !important; }
        .fas.fa-upload:before, .fa.fa-upload:before { content: "⬆️" !important; font-family: system-ui !important; }
        .fas.fa-clock:before, .fa.fa-clock:before { content: "🕐" !important; font-family: system-ui !important; }
        .fas.fa-sync-alt:before, .fa.fa-sync:before { content: "🔄" !important; font-family: system-ui !important; }
        .fas.fa-shield-alt:before, .fa.fa-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fas.fa-check-circle:before, .fa.fa-check-circle:before { content: "✅" !important; font-family: system-ui !important; }
        .fas.fa-spinner:before, .fa.fa-spinner:before { content: "⏳" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .far:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="bg-white shadow-sm sticky top-0 z-40">
            <div class="px-6 py-3">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <a href="javascript:history.back()" class="p-2 rounded-full bg-gray-100 hover:bg-gray-200 transition-colors">
                        <i class="fas fa-arrow-left text-gray-600"></i>
                    </a>
                    <div>
                        <h1 class="text-lg font-bold text-gray-800">Pembayaran Tiket</h1>
                        <p class="text-sm text-gray-500">Selesaikan pembayaran</p>
                    </div>
                </div>
                <div class="p-2 rounded-full bg-orange-50">
                    <i class="fas fa-credit-card text-orange-600"></i>
                </div>
            </div>
            </div>
        </div>

        <div class="px-6 py-6">
        <!-- Countdown Timer -->
        <div class="mobile-card text-center mb-6">
            <div class="text-sm text-gray-600 mb-2">Batas waktu pembayaran</div>
            <div class="countdown" id="countdown">23:59:45</div>
            <div class="text-xs text-gray-500 mt-1">Pembayaran akan dibatalkan otomatis jika melewati batas waktu</div>
        </div>

        <!-- Order Summary -->
        <div class="mobile-card">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Detail Pesanan</h3>
            <div class="space-y-3">
                <div class="flex justify-between">
                    <span class="text-gray-600">Kode Booking</span>
                    <span class="font-medium">{{kode_booking}}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Nomor Tiket</span>
                    <span class="font-medium">{{nomor_tiket}}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Destinasi</span>
                    <span class="font-medium">{{destinasi_wisata}}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Nama Pengunjung</span>
                    <span class="font-medium">{{nama_pengunjung}}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Tanggal Kunjungan</span>
                    <span class="font-medium">{{tanggal_kunjungan}}</span>
                </div>
                <div class="flex justify-between">
                    <span class="text-gray-600">Jumlah Tiket</span>
                    <span class="font-medium">{{jumlah_tiket}} tiket</span>
                </div>
                <hr class="my-3">
                <div class="flex justify-between text-lg font-bold text-blue-600">
                    <span>Total Pembayaran</span>
                    <span>{{total_harga}}</span>
                </div>
            </div>
        </div>

        <!-- Payment Method QRIS -->
        <div id="payment-qris" class="mobile-card">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Pembayaran QRIS</h3>
            
            <div class="text-center mb-4">
                <div class="qr-code">
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=180x180&data=ID12345678901{{kode_booking}}" 
                         alt="QR Code" class="w-full h-full object-contain">
                </div>
            </div>

            <div class="bg-blue-50 rounded-xl p-4 mb-4">
                <h4 class="font-semibold text-blue-800 mb-2">Cara Pembayaran:</h4>
                <ol class="text-sm text-blue-700 space-y-1">
                    <li>1. Buka aplikasi e-wallet (GoPay, OVO, DANA, ShopeePay)</li>
                    <li>2. Pilih "Scan QR" atau "Bayar"</li>
                    <li>3. Scan QR code di atas</li>
                    <li>4. Konfirmasi pembayaran sebesar {{total_harga}}</li>
                    <li>5. Pembayaran akan diverifikasi otomatis</li>
                </ol>
            </div>

            <div class="flex items-center space-x-3 text-sm text-gray-600">
                <i class="fas fa-shield-alt text-green-600"></i>
                <span>Pembayaran aman dan terenkripsi</span>
            </div>
        </div>

        <!-- Payment Method Transfer -->
        <div id="payment-transfer" class="mobile-card hidden">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Transfer Bank</h3>
            
            <div class="bg-gray-50 rounded-xl p-4 mb-4">
                <h4 class="font-semibold text-gray-800 mb-3">Rekening Tujuan:</h4>
                <div class="space-y-3">
                    <div class="flex items-center justify-between p-3 bg-white rounded-lg border">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-blue-600 rounded-lg flex items-center justify-center">
                                <span class="text-white text-xs font-bold">BCA</span>
                            </div>
                            <div>
                                <div class="font-medium">Bank BCA</div>
                                <div class="text-sm text-gray-600">1234567890</div>
                            </div>
                        </div>
                        <button onclick="copyText('1234567890')" class="text-blue-600 text-sm font-medium">
                            <i class="fas fa-copy mr-1"></i>Salin
                        </button>
                    </div>
                    
                    <div class="flex items-center justify-between p-3 bg-white rounded-lg border">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-green-600 rounded-lg flex items-center justify-center">
                                <span class="text-white text-xs font-bold">BNI</span>
                            </div>
                            <div>
                                <div class="font-medium">Bank BNI</div>
                                <div class="text-sm text-gray-600">0987654321</div>
                            </div>
                        </div>
                        <button onclick="copyText('0987654321')" class="text-blue-600 text-sm font-medium">
                            <i class="fas fa-copy mr-1"></i>Salin
                        </button>
                    </div>
                </div>
                
                <div class="mt-3 p-3 bg-yellow-50 rounded-lg">
                    <div class="text-sm text-yellow-800">
                        <strong>Atas Nama:</strong> PT Desa Digital Indonesia
                    </div>
                </div>
            </div>

            <div class="bg-blue-50 rounded-xl p-4 mb-4">
                <h4 class="font-semibold text-blue-800 mb-2">Cara Transfer:</h4>
                <ol class="text-sm text-blue-700 space-y-1">
                    <li>1. Transfer tepat sebesar {{total_harga}}</li>
                    <li>2. Gunakan berita transfer: {{kode_booking}}</li>
                    <li>3. Simpan bukti transfer</li>
                    <li>4. Upload bukti transfer di bawah</li>
                </ol>
            </div>

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Upload Bukti Transfer</label>
                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-blue-400 transition-colors cursor-pointer" onclick="document.getElementById('bukti-transfer').click()">
                        <i class="fas fa-cloud-upload-alt text-3xl text-gray-400 mb-2"></i>
                        <div class="text-sm text-gray-600">Klik untuk upload bukti transfer</div>
                        <div class="text-xs text-gray-500 mt-1">Format: JPG, PNG, PDF (Max 5MB)</div>
                    </div>
                    <input type="file" id="bukti-transfer" class="hidden" accept="image/*,application/pdf">
                </div>

                <button class="w-full bg-blue-600 text-white py-3 rounded-xl font-medium hover:bg-blue-700 transition-colors">
                    <i class="fas fa-upload mr-2"></i>Konfirmasi Pembayaran
                </button>
            </div>
        </div>

        <!-- Payment Status Check -->
        <div class="mobile-card">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Status Pembayaran</h3>
            <div class="flex items-center space-x-3 mb-4">
                <div class="w-12 h-12 bg-yellow-100 rounded-full flex items-center justify-center">
                    <i class="fas fa-clock text-yellow-600"></i>
                </div>
                <div>
                    <div class="font-medium text-gray-800">Menunggu Pembayaran</div>
                    <div class="text-sm text-gray-600">Silakan lakukan pembayaran sesuai instruksi</div>
                </div>
            </div>
            
            <button onclick="checkPaymentStatus()" class="w-full bg-gray-600 text-white py-3 rounded-xl font-medium hover:bg-gray-700 transition-colors">
                <i class="fas fa-sync-alt mr-2"></i>Cek Status Pembayaran
            </button>
        </div>

        <!-- Help Section -->
        <div class="mobile-card">
            <h3 class="text-lg font-bold text-gray-800 mb-4">Butuh Bantuan?</h3>
            <div class="grid grid-cols-2 gap-3">
                <button class="flex flex-col items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                    <i class="fab fa-whatsapp text-green-600 text-xl mb-2"></i>
                    <span class="text-sm font-medium">WhatsApp</span>
                </button>
                <button class="flex flex-col items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 transition-colors">
                    <i class="fas fa-phone text-blue-600 text-xl mb-2"></i>
                    <span class="text-sm font-medium">Telepon</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom -->
        <div class="h-8"></div>
    </div>

    <script>
        // Countdown timer
        let timeLeft = 86400; // 24 hours in seconds
        
        function updateCountdown() {
            const hours = Math.floor(timeLeft / 3600);
            const minutes = Math.floor((timeLeft % 3600) / 60);
            const seconds = timeLeft % 60;
            
            document.getElementById('countdown').textContent = 
                `${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
            
            if (timeLeft > 0) {
                timeLeft--;
            } else {
                // Payment expired
                alert('Batas waktu pembayaran telah habis. Pesanan dibatalkan.');
                window.location.href = '/';
            }
        }
        
        // Update countdown every second
        setInterval(updateCountdown, 1000);
        updateCountdown();

        // Copy text to clipboard
        function copyText(text) {
            navigator.clipboard.writeText(text).then(function() {
                alert('Nomor rekening berhasil disalin!');
            });
        }

        // Check payment status
        async function checkPaymentStatus() {
            const button = event.target;
            const originalText = button.innerHTML;
            button.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Mengecek...';
            button.disabled = true;

            try {
                // Simulate API call
                await new Promise(resolve => setTimeout(resolve, 2000));
                
                // For demo purposes, randomly show success or still pending
                const isSuccess = Math.random() > 0.7;
                
                if (isSuccess) {
                    alert('Pembayaran berhasil! Tiket Anda telah dikonfirmasi.');
                    window.location.href = '/tiket-saya/{{kode_booking}}';
                } else {
                    alert('Pembayaran belum diterima. Silakan coba lagi dalam beberapa menit.');
                }
            } catch (error) {
                alert('Gagal mengecek status pembayaran. Silakan coba lagi.');
            } finally {
                button.innerHTML = originalText;
                button.disabled = false;
            }
        }

        // Auto check payment status every 30 seconds
        setInterval(checkPaymentStatus, 30000);

        // Handle file upload
        document.getElementById('bukti-transfer').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const fileSize = file.size / 1024 / 1024; // Convert to MB
                if (fileSize > 5) {
                    alert('Ukuran file maksimal 5MB');
                    e.target.value = '';
                    return;
                }
                
                // Update UI to show file selected
                const uploadArea = e.target.previousElementSibling;
                uploadArea.innerHTML = `
                    <i class="fas fa-check-circle text-3xl text-green-500 mb-2"></i>
                    <div class="text-sm text-green-600">File dipilih: ${file.name}</div>
                    <div class="text-xs text-gray-500 mt-1">Klik untuk mengganti file</div>
                `;
                uploadArea.classList.add('border-green-400', 'bg-green-50');
            }
        });
    </script>
</body>
</html> 