<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Registrasi Data Penduduk - Portal Desa</title>
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
            transition: all 0.3s ease;
        }
        
        .mobile-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }
        
        .mobile-button {
            padding: 1rem 1.5rem;
            border-radius: 0.75rem;
            font-weight: 600;
            text-align: center;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            transform: translateY(0);
        }
        
        .mobile-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.18);
        }
        
        .form-step {
            display: none;
        }
        
        .form-step.active {
            display: block;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
        }
        
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e5e7eb;
            color: #6b7280;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin: 0 0.5rem;
            transition: all 0.3s ease;
        }
        
        .step.active {
            background: #2563eb;
            color: white;
        }
        
        .step.completed {
            background: #059669;
            color: white;
        }
        
        .step-line {
            flex: 1;
            height: 2px;
            background: #e5e7eb;
            margin: 0 0.5rem;
            align-self: center;
        }
        
        .step-line.active {
            background: #2563eb;
        }
        
        .file-upload-area {
            border: 2px dashed #e5e7eb;
            border-radius: 10px;
            padding: 2rem;
            text-align: center;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .file-upload-area:hover {
            border-color: #2563eb;
            background: rgba(37, 99, 235, 0.05);
        }
        
        .file-upload-area.dragover {
            border-color: #2563eb;
            background: rgba(37, 99, 235, 0.1);
        }
        
        .required::after {
            content: " *";
            color: #dc2626;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen">
        <!-- Header -->
        <div class="gradient-bg text-white py-8">
            <div class="container mx-auto px-4">
                <div class="text-center">
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-user-plus mr-3"></i>
                        Registrasi Data Penduduk
                    </h1>
                    <p class="text-lg opacity-90">
                        Silakan lengkapi data diri Anda untuk mendaftar sebagai penduduk desa
                    </p>
                    <p class="text-sm opacity-75 mt-2">
                        <i class="fas fa-camera mr-1"></i>Upload foto pribadi dan rumah
                        <i class="fas fa-map-marker-alt ml-3 mr-1"></i>Tagging lokasi GPS
                    </p>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="container mx-auto px-4 py-8 max-w-4xl">

            
            <!-- Progress Indicator -->
            <div class="step-indicator mb-8">
                <div class="step active" data-step="1">
                    <i class="fas fa-user"></i>
                </div>
                <div class="step-line"></div>
                <div class="step" data-step="2">
                    <i class="fas fa-home"></i>
                </div>
                <div class="step-line"></div>
                <div class="step" data-step="3">
                    <i class="fas fa-id-card"></i>
                </div>
                <div class="step-line"></div>
                <div class="step" data-step="4">
                    <i class="fas fa-certificate"></i>
                </div>
                <div class="step-line"></div>
                <div class="step" data-step="5">
                    <i class="fas fa-camera"></i>
                </div>
                <div class="step-line"></div>
                <div class="step" data-step="6">
                    <i class="fas fa-check"></i>
                </div>
            </div>

            <!-- Alert Messages -->
            <div id="alertContainer"></div>
            

            <!-- Registration Form -->
            <form id="registrationForm" action="/registrasi-penduduk" method="POST" enctype="multipart/form-data">
               
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                
                <!-- Hidden fields for backend mapping -->
                <input type="hidden" name="status_kawin" id="status_kawin_hidden">
                <input type="hidden" name="pendidikan" id="pendidikan_hidden">
                
                <!-- Step 1: Personal Information -->
                <div class="form-step active" id="step1">
                    <div class="mobile-card">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">
                            <i class="fas fa-user mr-2 text-blue-600"></i>
                            Data Pribadi
                        </h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="nik" class="block text-sm font-medium text-gray-700 required mb-2">NIK</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="nik" 
                                       name="nik" 
                                       placeholder="Nomor Induk Kependudukan"
                                       maxlength="16"
                                       required>
                                <p class="text-xs text-gray-500 mt-1">16 digit angka NIK sesuai KTP</p>
                            </div>
                            
                            <div>
                                <label for="nama" class="block text-sm font-medium text-gray-700 required mb-2">Nama Lengkap</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="nama" 
                                       name="nama" 
                                       placeholder="Nama lengkap sesuai KTP"
                                       required>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="tempat_lahir" class="block text-sm font-medium text-gray-700 required mb-2">Tempat Lahir</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="tempat_lahir" 
                                       name="tempat_lahir" 
                                       placeholder="Kota tempat lahir"
                                       required>
                            </div>
                            
                            <div>
                                <label for="tanggal_lahir" class="block text-sm font-medium text-gray-700 required mb-2">Tanggal Lahir</label>
                                <input type="date" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="tanggal_lahir" 
                                       name="tanggal_lahir" 
                                       required>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="jenis_kelamin" class="block text-sm font-medium text-gray-700 required mb-2">Jenis Kelamin</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="jenis_kelamin" 
                                        name="jenis_kelamin" 
                                        required>
                                    <option value="">Pilih Jenis Kelamin</option>
                                    <option value="L">Laki-laki</option>
                                    <option value="P">Perempuan</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="agama" class="block text-sm font-medium text-gray-700 required mb-2">Agama</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="agama" 
                                        name="agama" 
                                        required>
                                    <option value="">Pilih Agama</option>
                                    <option value="Islam">Islam</option>
                                    <option value="Kristen">Kristen</option>
                                    <option value="Katolik">Katolik</option>
                                    <option value="Hindu">Hindu</option>
                                    <option value="Buddha">Buddha</option>
                                    <option value="Konghucu">Konghucu</option>
                                </select>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="status_perkawinan" class="block text-sm font-medium text-gray-700 required mb-2">Status Perkawinan</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="status_perkawinan" 
                                        name="status_perkawinan" 
                                        required>
                                    <option value="">Pilih Status</option>
                                    <option value="Belum Kawin">Belum Kawin</option>
                                    <option value="Kawin">Kawin</option>
                                    <option value="Cerai Hidup">Cerai Hidup</option>
                                    <option value="Cerai Mati">Cerai Mati</option>
                                </select>
                            </div>
                            

                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="kewarganegaraan" class="block text-sm font-medium text-gray-700 required mb-2">Kewarganegaraan</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="kewarganegaraan" 
                                        name="kewarganegaraan" 
                                        required>
                                    <option value="WNI" selected>WNI (Warga Negara Indonesia)</option>
                                    <option value="WNA">WNA (Warga Negara Asing)</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="status_hidup" class="block text-sm font-medium text-gray-700 required mb-2">Status Hidup</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="status_hidup" 
                                        name="status_hidup" 
                                        required>
                                    <option value="Hidup" selected>Hidup</option>
                                    <option value="Meninggal">Meninggal</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-right mt-6">
                        <button type="button" class="mobile-button bg-blue-600 text-white hover:bg-blue-700" onclick="nextStep()">
                            Selanjutnya <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>

                <!-- Step 2: Address Information -->
                <div class="form-step" id="step2">
                    <div class="mobile-card">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">
                            <i class="fas fa-home mr-2 text-blue-600"></i>
                            Data Alamat
                        </h3>
                        
                        <div class="mb-4">
                            <label for="alamat" class="block text-sm font-medium text-gray-700 required mb-2">Alamat Lengkap</label>
                            <textarea class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                      id="alamat" 
                                      name="alamat" 
                                      rows="3" 
                                      placeholder="Alamat lengkap tempat tinggal"
                                      required></textarea>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label for="dusun" class="block text-sm font-medium text-gray-700 mb-2">Dusun</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="dusun" 
                                       name="dusun">
                                    <option value="">Pilih Dusun</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="rw" class="block text-sm font-medium text-gray-700 mb-2">RW</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="rw" 
                                       name="rw">
                                    <option value="">Pilih RW</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="rt" class="block text-sm font-medium text-gray-700 mb-2">RT</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="rt" 
                                        name="rt">
                                    <option value="">Pilih RT</option>
                                </select>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="no_kk" class="block text-sm font-medium text-gray-700 mb-2">Nomor Kartu Keluarga</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="no_kk" 
                                       name="no_kk" 
                                       placeholder="Nomor KK (opsional)"
                                       maxlength="16">
                                <p class="text-xs text-gray-500 mt-1">Kosongkan jika belum memiliki KK</p>
                            </div>
                            
                            <div>
                                <label for="no_wa" class="block text-sm font-medium text-gray-700 mb-2">Nomor WhatsApp</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="no_wa" 
                                       name="no_wa" 
                                       placeholder="08xxxxxxxxxx">
                                <p class="text-xs text-gray-500 mt-1">Untuk notifikasi layanan</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex justify-between mt-6">
                        <button type="button" class="mobile-button bg-gray-500 text-white hover:bg-gray-600" onclick="prevStep()">
                            <i class="fas fa-arrow-left mr-2"></i>Sebelumnya
                        </button>
                        <button type="button" class="mobile-button bg-blue-600 text-white hover:bg-blue-700" onclick="nextStep()">
                            Selanjutnya <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>

                <!-- Step 3: Additional Information -->
                <div class="form-step" id="step3">
                    <div class="mobile-card">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">
                            <i class="fas fa-id-card mr-2 text-blue-600"></i>
                            Data Tambahan
                        </h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="pekerjaan" class="block text-sm font-medium text-gray-700 mb-2">Pekerjaan</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="pekerjaan" 
                                       name="pekerjaan" 
                                       placeholder="Pekerjaan saat ini">
                            </div>
                            
                            <div>
                                <label for="pendidikan_terakhir" class="block text-sm font-medium text-gray-700 mb-2">Pendidikan Terakhir</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="pendidikan_terakhir" 
                                        name="pendidikan_terakhir">
                                    <option value="">Pilih Pendidikan</option>
                                    <option value="Tidak Sekolah">Tidak Sekolah</option>
                                    <option value="SD">SD</option>
                                    <option value="SMP">SMP</option>
                                    <option value="SMA">SMA</option>
                                    <option value="D1">D1</option>
                                    <option value="D2">D2</option>
                                    <option value="D3">D3</option>
                                    <option value="S1">S1</option>
                                    <option value="S2">S2</option>
                                    <option value="S3">S3</option>
                                </select>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="golongan_darah" class="block text-sm font-medium text-gray-700 mb-2">Golongan Darah</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="golongan_darah" 
                                        name="golongan_darah">
                                    <option value="">Pilih Golongan Darah</option>
                                    <option value="A">A</option>
                                    <option value="B">B</option>
                                    <option value="AB">AB</option>
                                    <option value="O">O</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="ayah_nik" class="block text-sm font-medium text-gray-700 mb-2">NIK Ayah</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="ayah_nik" 
                                       name="ayah_nik" 
                                       placeholder="NIK Ayah (16 digit)"
                                       maxlength="16">
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="nama_ayah" class="block text-sm font-medium text-gray-700 mb-2">Nama Ayah</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="nama_ayah" 
                                       name="nama_ayah" 
                                       placeholder="Nama ayah kandung">
                                <p class="text-xs text-gray-500 mt-1">Sistem akan mencoba mencocokkan NIK dengan nama</p>
                            </div>
                            
                            <div>
                                <label for="ibu_nik" class="block text-sm font-medium text-gray-700 mb-2">NIK Ibu</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="ibu_nik" 
                                       name="ibu_nik" 
                                       placeholder="NIK Ibu (16 digit)"
                                       maxlength="16">
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                            <div>
                                <label for="nama_ibu" class="block text-sm font-medium text-gray-700 mb-2">Nama Ibu</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="nama_ibu" 
                                       name="nama_ibu" 
                                       placeholder="Nama ibu kandung">
                                <p class="text-xs text-gray-500 mt-1">Sistem akan mencoba mencocokkan NIK dengan nama</p>
                            </div>
                            
                            <div>
                                <label for="hubungan_keluarga" class="block text-sm font-medium text-gray-700 mb-2">Hubungan dalam Keluarga</label>
                                <select class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                        id="hubungan_keluarga" 
                                        name="hubungan_keluarga">
                                    <option value="">Pilih Hubungan Keluarga</option>
                                    <option value="Kepala Keluarga">Kepala Keluarga</option>
                                    <option value="Istri">Istri</option>
                                    <option value="Anak">Anak</option>
                                    <option value="Menantu">Menantu</option>
                                    <option value="Cucu">Cucu</option>
                                    <option value="Orang Tua">Orang Tua</option>
                                    <option value="Mertua">Mertua</option>
                                    <option value="Saudara">Saudara</option>
                                    <option value="Lainnya">Lainnya</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex justify-between mt-6">
                        <button type="button" class="mobile-button bg-gray-500 text-white hover:bg-gray-600" onclick="prevStep()">
                            <i class="fas fa-arrow-left mr-2"></i>Sebelumnya
                        </button>
                        <button type="button" class="mobile-button bg-blue-600 text-white hover:bg-blue-700" onclick="nextStep()">
                            Selanjutnya <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>

                <!-- Step 4: Data Akta Lahir -->
                <div class="form-step" id="step4">
                    <div class="mobile-card">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">
                            <i class="fas fa-certificate mr-2 text-blue-600"></i>
                            Data Akta Lahir
                        </h3>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="no_akta_lahir" class="block text-sm font-medium text-gray-700 mb-2">Nomor Akta Lahir</label>
                                <input type="text" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="no_akta_lahir" 
                                       name="no_akta_lahir" 
                                       placeholder="Nomor akta kelahiran"
                                       maxlength="50">
                            </div>
                            
                            <div>
                                <label for="tanggal_akta_lahir" class="block text-sm font-medium text-gray-700 mb-2">Tanggal Akta Lahir</label>
                                <input type="date" 
                                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                       id="tanggal_akta_lahir" 
                                       name="tanggal_akta_lahir">
                            </div>
                        </div>
                        
                        <div class="mt-4">
                            <label for="tempat_akta_lahir" class="block text-sm font-medium text-gray-700 mb-2">Tempat Akta Lahir</label>
                            <input type="text" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" 
                                   id="tempat_akta_lahir" 
                                   name="tempat_akta_lahir" 
                                   placeholder="Tempat pembuatan akta kelahiran">
                        </div>
                    </div>
                    
                    <div class="flex justify-between mt-6">
                        <button type="button" class="mobile-button bg-gray-500 text-white hover:bg-gray-600" onclick="prevStep()">
                            <i class="fas fa-arrow-left mr-2"></i>Sebelumnya
                        </button>
                        <button type="button" class="mobile-button bg-blue-600 text-white hover:bg-blue-700" onclick="nextStep()">
                            <i class="fas fa-arrow-right mr-2"></i>Selanjutnya
                        </button>
                    </div>
                </div>

                <!-- Step 5: Foto dan Lokasi -->
                <div class="form-step" id="step5">
                    <div class="mobile-card">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">
                            <i class="fas fa-camera mr-2 text-blue-600"></i>
                            Foto dan Lokasi
                        </h3>
                        
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-exclamation-triangle text-yellow-600 mr-2"></i>
                                <span class="text-yellow-800 font-medium">Penting:</span>
                            </div>
                            <p class="text-yellow-700 text-sm mt-1">Foto dan lokasi rumah akan membantu petugas dalam verifikasi data Anda. Pastikan foto jelas dan lokasi akurat. Minimal upload satu foto untuk melanjutkan.</p>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Foto Pribadi -->
                            <div>
                                <label for="fotoInput" class="block text-sm font-medium text-gray-700 mb-2">Foto Pribadi</label>
                                <div class="border-2 border-dashed border-gray-300 rounded-lg p-4 text-center hover:border-blue-400 transition-colors cursor-pointer" onclick="document.getElementById('fotoInput').click()">
                                    <input type="file" name="foto" accept="image/*" class="hidden" id="fotoInput">
                                    <div class="space-y-2">
                                        <i class="fas fa-camera text-3xl text-gray-400"></i>
                                        <div class="text-sm text-gray-600">
                                            <span class="font-medium text-blue-600">Klik untuk upload</span> foto pribadi
                                        </div>
                                        <div class="text-xs text-gray-500">PNG, JPG, JPEG (Max. 2MB, Max. 8000x8000px)</div>
                                        <div class="text-xs text-gray-400 mt-1">Foto akan otomatis diperkecil dan membantu verifikasi identitas</div>
                                    </div>
                                </div>
                                <div id="fotoPreview" class="mt-2 hidden">
                                    <img src="" alt="Preview" class="w-20 h-20 object-cover rounded-lg">
                                </div>
                            </div>
                            
                            <!-- Foto Rumah -->
                            <div>
                                <label for="fotoRumahInput" class="block text-sm font-medium text-gray-700 mb-2">Foto Rumah</label>
                                <div class="border-2 border-dashed border-gray-300 rounded-lg p-4 text-center hover:border-blue-400 transition-colors cursor-pointer" onclick="document.getElementById('fotoRumahInput').click()">
                                    <input type="file" name="foto_rumah" accept="image/*" class="hidden" id="fotoRumahInput">
                                    <div class="space-y-2">
                                        <i class="fas fa-home text-3xl text-gray-400"></i>
                                        <div class="text-sm text-gray-600">
                                            <span class="font-medium text-blue-600">Klik untuk upload</span> foto rumah
                                        </div>
                                        <div class="text-xs text-gray-500">PNG, JPG, JPEG (Max. 2MB, Max. 8000x8000px)</div>
                                        <div class="text-xs text-gray-400 mt-1">Foto akan otomatis diperkecil untuk verifikasi alamat</div>
                                    </div>
                                </div>
                                <div id="fotoRumahPreview" class="mt-2 hidden">
                                    <img src="" alt="Preview" class="w-20 h-20 object-cover rounded-lg">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Lokasi -->
                        <div class="mt-6">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Lokasi Rumah</label>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label for="latitude" class="block text-xs text-gray-600 mb-1">Latitude</label>
                                    <input type="number" id="latitude" name="latitude" step="any" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="-6.123456">
                                </div>
                                <div>
                                    <label for="longitude" class="block text-xs text-gray-600 mb-1">Longitude</label>
                                    <input type="number" id="longitude" name="longitude" step="any" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="106.123456">
                                </div>
                            </div>
                            <div class="mt-2">
                                <button type="button" id="getLocationBtn" class="inline-flex items-center px-3 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    <i class="fas fa-map-marker-alt mr-2"></i>
                                    Ambil Lokasi Sekarang
                                </button>
                                <p class="text-xs text-gray-500 mt-1">Klik tombol di atas untuk mengambil lokasi otomatis dari GPS. Pastikan browser mengizinkan akses lokasi.</p>
                                <p class="text-xs text-gray-400 mt-1">Lokasi akan membantu petugas dalam verifikasi alamat Anda</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex justify-between mt-6">
                        <button type="button" class="mobile-button bg-gray-500 text-white hover:bg-gray-600" onclick="prevStep()">
                            <i class="fas fa-arrow-left mr-2"></i>Sebelumnya
                        </button>
                        <button type="button" class="mobile-button bg-blue-600 text-white hover:bg-blue-700" onclick="nextStep()">
                            Selanjutnya <i class="fas fa-arrow-right ml-2"></i>
                        </button>
                    </div>
                </div>

                <!-- Step 6: Review and Submit -->
                <div class="form-step" id="step6">
                    <div class="mobile-card">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">
                            <i class="fas fa-check mr-2 text-blue-600"></i>
                            Review Data
                        </h3>
                        
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-info-circle text-blue-600 mr-2"></i>
                                <span class="text-blue-800 font-medium">Perhatian:</span>
                            </div>
                            <p class="text-blue-700 text-sm mt-1">Silakan periksa kembali data yang telah diisi sebelum mengirimkan. Foto dan lokasi rumah akan membantu petugas dalam verifikasi data Anda. Data akan disimpan dan diverifikasi oleh petugas.</p>
                        </div>

                        <div id="reviewData">
                            <!-- Data will be populated by JavaScript -->
                        </div>
                        
                        <div class="bg-green-50 border border-green-200 rounded-lg p-4 mt-6">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-600 mr-2"></i>
                                <span class="text-green-800 font-medium">Data Lengkap:</span>
                            </div>
                            <p class="text-green-700 text-sm mt-1">Foto dan lokasi telah diupload. Data Anda siap untuk diverifikasi oleh petugas. Setelah dikirim, data akan diproses dalam 1-3 hari kerja.</p>
                        </div>
                    </div>
                    
                    <div class="flex justify-between mt-6">
                        <button type="button" class="mobile-button bg-gray-500 text-white hover:bg-gray-600" onclick="prevStep()">
                            <i class="fas fa-arrow-left mr-2"></i>Sebelumnya
                        </button>
                        <button type="submit" class="mobile-button bg-green-600 text-white hover:bg-green-700" id="submitBtn">
                            <i class="fas fa-paper-plane mr-2"></i>Kirim Registrasi
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- JavaScript -->
    <script>
        // Global variables
        let currentStep = 1;
        const totalSteps = 6;
        const maxImageDimensions = 8000; // Maximum image dimensions in pixels
        
        // Debug: Script loaded
        console.log('Script loaded, currentStep:', currentStep);

        // Wait for DOM to be ready
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOM loaded, initializing form...');
            
            // Refresh session to prevent timeout
            fetch('/refresh-session')
                .then(response => response.json())
                .then(data => {
                    console.log('Session refreshed:', data);
                })
                .catch(error => {
                    console.log('Failed to refresh session:', error);
                });
            
            // Initialize form
            initializeForm();
            
            // Load saved data
            loadFormData();
            
            // Load wilayah data
            loadWilayahData();
            
            // Initialize hidden fields
            updateHiddenFields();
        });

        // Initialize form functionality
        function initializeForm() {
            // File upload handling
            const fotoInput = document.getElementById('fotoInput');
            const fotoRumahInput = document.getElementById('fotoRumahInput');
            
            if (fotoInput) {
                fotoInput.addEventListener('change', handleFotoUpload);
                console.log('Foto input event listener added');
            }
            
            if (fotoRumahInput) {
                fotoRumahInput.addEventListener('change', handleFotoRumahUpload);
                console.log('Foto rumah input event listener added');
            }

            // Form field change listeners
            const registrationForm = document.getElementById('registrationForm');
            if (registrationForm) {
                registrationForm.addEventListener('input', function(e) {
                    if (e.target.type !== 'file') {
                        setTimeout(saveFormData, 500);
                    }
                });

                registrationForm.addEventListener('change', function(e) {
                    if (e.target.tagName === 'SELECT') {
                        setTimeout(saveFormData, 100);
                    }
                    
                    // Update hidden fields for backend mapping
                    updateHiddenFields();
                });

                // Ensure form submit handler is properly attached
                registrationForm.addEventListener('submit', handleFormSubmit);
                console.log('Form submit event listener attached');
                
                // Also add click handler to submit button as backup
                const submitBtn = document.getElementById('submitBtn');
                if (submitBtn) {
                    submitBtn.addEventListener('click', function(e) {
                        e.preventDefault();
                        console.log('Submit button clicked, triggering form submission');
                        // Create a synthetic submit event with the form element
                        const syntheticEvent = {
                            preventDefault: () => {},
                            target: registrationForm
                        };
                        handleFormSubmit(syntheticEvent);
                    });
                    console.log('Submit button click event listener attached');
                }
            }

            // Location fields
            const latitudeInput = document.querySelector('input[name="latitude"]');
            const longitudeInput = document.querySelector('input[name="longitude"]');
            
            if (latitudeInput) {
                latitudeInput.addEventListener('input', saveFormData);
                console.log('Latitude input event listener added');
            }
            if (longitudeInput) {
                longitudeInput.addEventListener('input', saveFormData);
                console.log('Longitude input event listener added');
            }
            
            // Add event listener for step 5 to ensure data is saved
            document.addEventListener('DOMContentLoaded', function() {
                // Save data when user is on step 5
                if (currentStep === 5) {
                    console.log('User is on step 5, saving data...');
                    saveFormData();
                }
            });
            
            // Add event listener for step 5 changes
            const step5Element = document.getElementById('step5');
            if (step5Element) {
                step5Element.addEventListener('input', function(e) {
                    if (currentStep === 5) {
                        console.log('Input change in step 5, saving data...');
                        saveFormData();
                    }
                });
                
                step5Element.addEventListener('change', function(e) {
                    if (currentStep === 5) {
                        console.log('Change event in step 5, saving data...');
                        saveFormData();
                    }
                });
            }
            

            


            // GPS Location button
            const getLocationBtn = document.getElementById('getLocationBtn');
            if (getLocationBtn) {
                getLocationBtn.addEventListener('click', handleGetLocation);
            }

            // Wilayah dropdowns
            const dusunSelect = document.getElementById('dusun');
            const rwSelect = document.getElementById('rw');
            const rtSelect = document.getElementById('rt');

            if (dusunSelect) {
                dusunSelect.addEventListener('change', handleDusunChange);
            }

            if (rwSelect) {
                rwSelect.addEventListener('change', handleRwChange);
            }
        }

        // File upload handlers
        function handleFotoUpload(e) {
                const file = e.target.files[0];
                if (file) {
                    if (file.size > 2 * 1024 * 1024) {
                    showAlert('Ukuran file terlalu besar. Maksimal 2MB.', 'error');
                    e.target.value = '';
                        return;
                    }
                    
                    const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
                    if (!allowedTypes.includes(file.type)) {
                    showAlert('Format file tidak didukung. Gunakan JPG, JPEG, atau PNG.', 'error');
                    e.target.value = '';
                        return;
                    }
                    
                    // Check image dimensions
                    const img = new Image();
                    img.onload = function() {
                        if (this.width > maxImageDimensions || this.height > maxImageDimensions) {
                            showAlert(`Dimensi foto terlalu besar. Maksimal ${maxImageDimensions}x${maxImageDimensions} piksel. Foto akan otomatis diperkecil saat upload.`, 'error');
                            e.target.value = '';
                            return;
                        }
                        if (this.width < 10 || this.height < 10) {
                            showAlert('Dimensi foto terlalu kecil. Minimal 10x10 piksel.', 'error');
                            e.target.value = '';
                            return;
                        }
                        
                        // Show preview
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            const preview = document.getElementById('fotoPreview');
                            if (preview && preview.querySelector('img')) {
                                preview.querySelector('img').src = e.target.result;
                                preview.classList.remove('hidden');
                            }
                        };
                        reader.readAsDataURL(file);
                        setTimeout(saveFormData, 100);
                    };
                    img.onerror = function() {
                        showAlert('File bukan gambar yang valid.', 'error');
                        e.target.value = '';
                    };
                    img.src = URL.createObjectURL(file);
                }
        }

        function handleFotoRumahUpload(e) {
                const file = e.target.files[0];
                if (file) {
                    if (file.size > 2 * 1024 * 1024) {
                    showAlert('Ukuran file terlalu besar. Maksimal 2MB.', 'error');
                    e.target.value = '';
                        return;
                    }
                    
                    const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png'];
                    if (!allowedTypes.includes(file.type)) {
                    showAlert('Format file tidak didukung. Gunakan JPG, JPEG, atau PNG.', 'error');
                    e.target.value = '';
                        return;
                    }
                    
                    // Check image dimensions
                    const img = new Image();
                    img.onload = function() {
                        if (this.width > maxImageDimensions || this.height > maxImageDimensions) {
                            showAlert(`Dimensi foto terlalu besar. Maksimal ${maxImageDimensions}x${maxImageDimensions} piksel. Foto akan otomatis diperkecil saat upload.`, 'error');
                            e.target.value = '';
                            return;
                        }
                        if (this.width < 10 || this.height < 10) {
                            showAlert('Dimensi foto terlalu kecil. Minimal 10x10 piksel.', 'error');
                            e.target.value = '';
                            return;
                        }
                        
                        // Show preview
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            const preview = document.getElementById('fotoRumahPreview');
                            if (preview && preview.querySelector('img')) {
                                preview.querySelector('img').src = e.target.result;
                                preview.classList.remove('hidden');
                            }
                        };
                        reader.readAsDataURL(file);
                        setTimeout(saveFormData, 100);
                    };
                    img.onerror = function() {
                        showAlert('File bukan gambar yang valid.', 'error');
                        e.target.value = '';
                    };
                    img.src = URL.createObjectURL(file);
                }
        }

        // GPS Location handler
        function handleGetLocation() {
            const btn = document.getElementById('getLocationBtn');
            if (!btn) return;
            
            // Check if geolocation is supported
            if (!navigator.geolocation) {
                showAlert('Browser Anda tidak mendukung geolokasi.', 'error');
                return;
            }
            
            // Check permission status first
            if (navigator.permissions && navigator.permissions.query) {
                navigator.permissions.query({ name: 'geolocation' }).then(function(result) {
                    if (result.state === 'denied') {
                        showAlert('Akses lokasi ditolak. Silakan buka pengaturan browser dan izinkan akses lokasi untuk website ini.', 'error');
                        return;
                    }
                    requestLocation(btn);
                }).catch(function() {
                    // Fallback if permissions API not supported
                    requestLocation(btn);
                });
            } else {
                // Fallback for browsers without permissions API
                requestLocation(btn);
            }
        }
        
        function requestLocation(btn) {
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Mengambil lokasi...';
            btn.disabled = true;
            
            // Try with high accuracy first
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    const latInput = document.querySelector('input[name="latitude"]');
                    const lngInput = document.querySelector('input[name="longitude"]');
                    if (latInput && lngInput) {
                        latInput.value = position.coords.latitude;
                        lngInput.value = position.coords.longitude;
                    }
                    
                    setTimeout(saveFormData, 100);
                    
                    btn.innerHTML = '<i class="fas fa-check mr-2"></i>Lokasi Berhasil Diambil!';
                    btn.classList.add('bg-green-100', 'text-green-700', 'border-green-300');
                    
                    setTimeout(() => {
                        btn.innerHTML = '<i class="fas fa-map-marker-alt mr-2"></i>Ambil Lokasi Sekarang';
                        btn.classList.remove('bg-green-100', 'text-green-700', 'border-green-300');
                        btn.disabled = false;
                    }, 2000);
                },
                function(error) {
                    console.error('Error getting location:', error);
                    
                    let errorMessage = 'Gagal mengambil lokasi. ';
                    switch(error.code) {
                        case error.PERMISSION_DENIED:
                            errorMessage += 'Akses lokasi ditolak. Silakan buka pengaturan browser dan izinkan akses lokasi untuk website ini.';
                            break;
                        case error.POSITION_UNAVAILABLE:
                            errorMessage += 'Informasi lokasi tidak tersedia. Silakan coba lagi dalam beberapa saat.';
                            break;
                        case error.TIMEOUT:
                            errorMessage += 'Waktu permintaan lokasi habis. Silakan coba lagi.';
                            break;
                        default:
                            errorMessage += 'Terjadi kesalahan yang tidak diketahui. Silakan coba lagi.';
                    }
                    
                    showAlert(errorMessage, 'error');
                    btn.innerHTML = '<i class="fas fa-map-marker-alt mr-2"></i>Ambil Lokasi Sekarang';
                    btn.disabled = false;
                },
                {
                    enableHighAccuracy: false, // Try with lower accuracy first
                    timeout: 30000,
                    maximumAge: 300000
                }
            );
        }

        // Wilayah dropdown handlers
        function handleDusunChange() {
            const selectedOption = this.options[this.selectedIndex];
            const dusunId = selectedOption.dataset.id;
            
            if (dusunId) {
                loadRwData(dusunId);
            } else {
                const rwSelect = document.getElementById('rw');
                const rtSelect = document.getElementById('rt');
                if (rwSelect) rwSelect.innerHTML = '<option value="">Pilih RW</option>';
                if (rtSelect) rtSelect.innerHTML = '<option value="">Pilih RT</option>';
            }
            
            saveFormData();
        }

        function handleRwChange() {
            const selectedOption = this.options[this.selectedIndex];
            const rwId = selectedOption.dataset.id;
            
            if (rwId) {
                loadRtData(rwId);
            } else {
                const rtSelect = document.getElementById('rt');
                if (rtSelect) rtSelect.innerHTML = '<option value="">Pilih RT</option>';
            }
            
            saveFormData();
        }

        // Step navigation
        function nextStep() {
            console.log('nextStep called, current step:', currentStep);
            
            if (validateCurrentStep()) {
                console.log('Validation passed, moving to next step');
                if (currentStep < totalSteps) {
                    document.getElementById(`step${currentStep}`).classList.remove('active');
                    currentStep++;
                    document.getElementById(`step${currentStep}`).classList.add('active');
                    updateStepIndicator();
                    
                    console.log('Moved to step:', currentStep);
                    
                    if (currentStep === 6) {
                        console.log('Step 6 reached, populating review data...');
                        populateReviewData();
                        console.log('Step 6 reached, saving data immediately...');
                        saveFormData();
                    } else {
                        setTimeout(saveFormData, 100);
                    }
                } else {
                    console.log('Already at last step');
                }
            } else {
                console.log('Validation failed');
            }
        }



        function prevStep() {
            if (currentStep > 1) {
                document.getElementById(`step${currentStep}`).classList.remove('active');
                currentStep--;
                document.getElementById(`step${currentStep}`).classList.add('active');
                updateStepIndicator();
                
                setTimeout(saveFormData, 100);
            }
        }

        function updateStepIndicator() {
            const steps = document.querySelectorAll('.step');
            const lines = document.querySelectorAll('.step-line');
            
            steps.forEach((step, index) => {
                const stepNum = index + 1;
                step.classList.remove('active', 'completed');
                
                if (stepNum < currentStep) {
                    step.classList.add('completed');
                } else if (stepNum === currentStep) {
                    step.classList.add('active');
                }
            });
            
            lines.forEach((line, index) => {
                const stepNum = index + 1;
                line.classList.remove('active');
                
                if (stepNum < currentStep) {
                    line.classList.add('active');
                }
            });
        }

        function validateCurrentStep() {
            console.log('validateCurrentStep called for step:', currentStep);
            const currentStepElement = document.getElementById(`step${currentStep}`);
            if (!currentStepElement) {
                console.log('Step element not found');
                return false;
            }
            
            // Step 4 (Data Akta Lahir) - semua field optional, langsung pass
            if (currentStep === 4) {
                console.log('Step 4 validation: auto-pass (all fields optional)');
                return true;
            }
            
            const requiredFields = currentStepElement.querySelectorAll('[required]');
            let isValid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    field.classList.add('border-red-500');
                    isValid = false;
                } else {
                    field.classList.remove('border-red-500');
                }
            });
            
            // Special validation for NIK
            if (currentStep === 1) {
                const nik = document.getElementById('nik');
                if (nik && (nik.value.length !== 16 || !/^\d+$/.test(nik.value))) {
                    nik.classList.add('border-red-500');
                    showAlert('NIK harus 16 digit angka', 'error');
                    isValid = false;
                }
            }
            
            // Additional validation for step 5 (Foto dan Lokasi)
            if (currentStep === 5) {
                const fotoInput = document.getElementById('fotoInput');
                const fotoRumahInput = document.getElementById('fotoRumahInput');
                
                if (fotoInput && fotoRumahInput && !fotoInput.files[0] && !fotoRumahInput.files[0]) {
                    showAlert('Silakan upload minimal satu foto (foto pribadi atau foto rumah) untuk membantu verifikasi.', 'error');
                    isValid = false;
                }
            }
            
            // Step 6 (Review Data) - auto-pass, no validation needed
            if (currentStep === 6) {
                console.log('Step 6 validation: auto-pass (review step)');
                return true;
            }
            
            if (!isValid) {
                showAlert('Mohon lengkapi data yang wajib diisi', 'error');
            }
            
            return isValid;
        }

        // Form submission
        function handleFormSubmit(e) {
            e.preventDefault();
            
            console.log('=== FORM SUBMISSION START ===');
            console.log('Current step:', currentStep);
            console.log('Form element:', e.target);
            
            // Validate current step before submission
            if (!validateCurrentStep()) {
                console.log('Validation failed, stopping submission');
                return false;
            }
            
            const submitBtn = document.getElementById('submitBtn');
            let originalText = 'Kirim Data'; // Default fallback
            if (submitBtn) {
                originalText = submitBtn.innerHTML;
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Mengirim...';
            }
            
            // Get CSRF token
            let csrfToken = '';
            const csrfMeta = document.querySelector('meta[name="csrf-token"]');
            if (csrfMeta) {
                csrfToken = csrfMeta.content;
                console.log('CSRF token from meta:', csrfToken ? 'Found' : 'Not found');
            }
            
            if (!csrfToken) {
                const csrfInput = document.querySelector('input[name="_token"]');
                if (csrfInput) {
                    csrfToken = csrfInput.value;
                    console.log('CSRF token from input:', csrfToken ? 'Found' : 'Not found');
                }
            }
            
            if (!csrfToken) {
                console.error('No CSRF token found');
                showAlert('Token keamanan tidak ditemukan. Silakan refresh halaman dan coba lagi.', 'error');
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalText;
                }
                return false;
            }
            
            // Submit form - ensure we have the correct form element
            let formElement = e.target;
            if (!formElement || formElement.tagName !== 'FORM') {
                // If e.target is not a form, try to find the form
                formElement = document.getElementById('registrationForm');
                if (!formElement) {
                    console.error('Form element not found');
                    showAlert('Form tidak ditemukan. Silakan refresh halaman dan coba lagi.', 'error');
                    if (submitBtn) {
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = originalText;
                    }
                    return false;
                }
            }
            
            const formData = new FormData(formElement);
            
            // Ensure CSRF token is in FormData
            if (csrfToken && !formData.has('_token')) {
                formData.append('_token', csrfToken);
            }
            
            // Refresh session before submission to prevent timeout
            fetch('/refresh-session')
                .then(response => response.json())
                .then(data => {
                    // Update CSRF token if new one is provided
                    if (data.csrf_token) {
                        csrfToken = data.csrf_token;
                        const csrfMeta = document.querySelector('meta[name="csrf-token"]');
                        const csrfInput = document.querySelector('input[name="_token"]');
                        if (csrfMeta) csrfMeta.content = data.csrf_token;
                        if (csrfInput) csrfInput.value = data.csrf_token;
                        
                        // Update FormData with new token
                        formData.set('_token', data.csrf_token);
                    }
                    
                    // Now submit the form
                    return fetch('/registrasi-penduduk', {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-TOKEN': csrfToken,
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });
                })
                .catch(error => {
                    console.error('Failed to refresh session before submission:', error);
                    // If session refresh fails, still try to submit with current token
                    return fetch('/registrasi-penduduk', {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-TOKEN': csrfToken,
                            'Accept': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        }
                    });
                })
            .then(response => {
                console.log('Response received:', response);
                console.log('Response status:', response.status);
                console.log('Response headers:', response.headers);
                
                // Handle rate limiting specifically
                if (response.status === 429) {
                    throw new Error('RATE_LIMIT_EXCEEDED');
                }
                
                // Check if response is JSON
                const contentType = response.headers.get('content-type');
                if (contentType && contentType.includes('application/json')) {
                    return response.json();
                } else {
                    // If not JSON, it's likely an HTML error page
                    return response.text().then(text => {
                        console.error('Non-JSON response received:', text);
                        throw new Error('Server returned non-JSON response. This might be a CSRF token error or server error.');
                    });
                }
            })
            .then(data => {
                console.log('Response data:', data);
                
                // Handle CSRF errors specifically
                if (data && data.error_type === 'csrf_mismatch') {
                    console.error('CSRF mismatch detected:', data);
                    showAlert('Token keamanan tidak valid. Silakan refresh halaman dan coba lagi.', 'error');
                    return;
                }
                if (data && data.error_type === 'csrf_missing') {
                    console.error('CSRF token missing:', data);
                    showAlert('Token keamanan tidak ditemukan. Silakan refresh halaman dan coba lagi.', 'error');
                    return;
                }
                
                // Handle successful response
                if (data && data.success) {
                    showAlert(data.message, 'success');
                    setTimeout(() => {
                        window.location.href = data.redirect || '/';
                    }, 2000);
                } else {
                    showAlert(data.message || 'Terjadi kesalahan', 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                if (error.message === 'RATE_LIMIT_EXCEEDED') {
                    showRateLimitMessage();
                } else if (error.message.includes('CSRF token')) {
                    showAlert('Token keamanan tidak valid. Silakan refresh halaman dan coba lagi.', 'error');
                } else if (error.message.includes('non-JSON')) {
                    showAlert('Terjadi kesalahan server. Silakan refresh halaman dan coba lagi.', 'error');
                } else {
                    showAlert('Terjadi kesalahan sistem. Silakan coba lagi.', 'error');
                }
            })
            .finally(() => {
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalText;
                }
            });
        }

        // Utility functions
        function showAlert(message, type) {
            const alertContainer = document.getElementById('alertContainer');
            if (!alertContainer) return;
            
            const alertClass = type === 'error' ? 'bg-red-100 border-red-400 text-red-700' : 'bg-green-100 border-green-400 text-green-700';
            const iconClass = type === 'error' ? 'fas fa-exclamation-circle' : 'fas fa-check-circle';
            
            const alertHTML = `
                <div class="border rounded-lg p-4 mb-4 ${alertClass}">
                    <div class="flex items-center">
                        <i class="${iconClass} mr-2"></i>
                        <span>${message}</span>
                    </div>
                </div>
            `;
            alertContainer.innerHTML = alertHTML;
            
                    setTimeout(() => {
                const alert = alertContainer.querySelector('div');
                if (alert) {
                    alert.remove();
                }
            }, 5000);
        }

        // Rate limit message with countdown
        function showRateLimitMessage() {
            const alertContainer = document.getElementById('alertContainer');
            if (!alertContainer) return;
            
            let timeLeft = 60; // 60 seconds
            const alertHTML = `
                <div class="border rounded-lg p-4 mb-4 bg-yellow-100 border-yellow-400 text-yellow-700">
                    <div class="flex items-center">
                        <i class="fas fa-clock mr-2"></i>
                        <span>Terlalu banyak percobaan registrasi. Silakan tunggu <span id="countdown">${timeLeft}</span> detik sebelum mencoba lagi.</span>
                    </div>
                </div>
            `;
            alertContainer.innerHTML = alertHTML;
            
            // Disable submit button
            const submitBtn = document.getElementById('submitBtn');
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-clock mr-2"></i>Menunggu...';
            }
            
            // Start countdown
            const countdownInterval = setInterval(() => {
                timeLeft--;
                const countdownElement = document.getElementById('countdown');
                if (countdownElement) {
                    countdownElement.textContent = timeLeft;
                }
                
                if (timeLeft <= 0) {
                    clearInterval(countdownInterval);
                    const alert = alertContainer.querySelector('div');
                    if (alert) {
                        alert.remove();
                    }
                    
                    // Re-enable submit button
                    if (submitBtn) {
                        submitBtn.disabled = false;
                        submitBtn.innerHTML = '<i class="fas fa-paper-plane mr-2"></i>Kirim Registrasi';
                    }
                }
            }, 1000);
        }

        function getSelectText(selectId) {
            const select = document.getElementById(selectId);
            if (!select) return '';
            return select.options[select.selectedIndex]?.text || '';
        }
        
        // Update hidden fields for backend mapping
        function updateHiddenFields() {
            // Map status_perkawinan to status_kawin
            const statusPerkawinanSelect = document.getElementById('status_perkawinan');
            const statusKawinHidden = document.getElementById('status_kawin_hidden');
            if (statusPerkawinanSelect && statusKawinHidden) {
                statusKawinHidden.value = statusPerkawinanSelect.value;
                console.log('Updated status_kawin_hidden:', statusKawinHidden.value);
            }
            
            // Map pendidikan_terakhir to pendidikan
            const pendidikanTerakhirSelect = document.getElementById('pendidikan_terakhir');
            const pendidikanHidden = document.getElementById('pendidikan_hidden');
            if (pendidikanTerakhirSelect && pendidikanHidden) {
                pendidikanHidden.value = pendidikanTerakhirSelect.value || 'Tidak Sekolah';
                console.log('Updated pendidikan_hidden:', pendidikanHidden.value);
            }
        }

        // Data management
        function saveFormData() {
                console.log('saveFormData called, current step:', currentStep);
                const formData = new FormData(document.getElementById('registrationForm'));
                const data = {};
                
                for (let [key, value] of formData.entries()) {
                    data[key] = value;
                }
                
                // Add file information for step 5
                if (currentStep === 5) {
                    const fotoInput = document.getElementById('fotoInput');
                    const fotoRumahInput = document.getElementById('fotoRumahInput');
                    
                    if (fotoInput && fotoInput.files.length > 0) {
                        data.fotoUploaded = true;
                        data.fotoName = fotoInput.files[0].name;
                    }
                    
                    if (fotoRumahInput && fotoRumahInput.files.length > 0) {
                        data.fotoRumahUploaded = true;
                        data.fotoRumahName = fotoRumahInput.files[0].name;
                    }
                    
                    // Add location data
                    const latitudeInput = document.getElementById('latitude');
                    const longitudeInput = document.getElementById('longitude');
                    
                    if (latitudeInput) data.latitude = latitudeInput.value;
                    if (longitudeInput) data.longitude = longitudeInput.value;
                }
                
                data.currentStep = currentStep;
                localStorage.setItem('registrasiPendudukData', JSON.stringify(data));
                console.log('Data saved to localStorage:', data);
        }

        function loadFormData() {
            const savedData = localStorage.getItem('registrasiPendudukData');
            if (savedData) {
                const data = JSON.parse(savedData);
                
                Object.keys(data).forEach(key => {
                    if (key !== 'currentStep') {
                        const field = document.getElementById(key);
                        if (field && field.type !== 'file') {
                            field.value = data[key];
                        }
                    }
                });
                
                if (data.currentStep && data.currentStep > 1) {
                    for (let i = 1; i < data.currentStep; i++) {
                        const stepElement = document.getElementById(`step${i}`);
                        if (stepElement) stepElement.classList.remove('active');
                    }
                    currentStep = data.currentStep;
                    const currentStepElement = document.getElementById(`step${currentStep}`);
                    if (currentStepElement) currentStepElement.classList.add('active');
                    updateStepIndicator();
                    
                    if (currentStep === 6) {
                        populateReviewData();
                    }
                }
            }
        }

        function clearFormData() {
            localStorage.removeItem('registrasiPendudukData');
            const form = document.getElementById('registrationForm');
            if (form) form.reset();
            currentStep = 1;
            const step1 = document.getElementById('step1');
            if (step1) step1.classList.add('active');
            for (let i = 2; i <= 6; i++) {
                const stepElement = document.getElementById(`step${i}`);
                if (stepElement) stepElement.classList.remove('active');
            }
            updateStepIndicator();
            showAlert('Data form telah dihapus', 'success');
        }

        // Review data
        function populateReviewData() {
            console.log('populateReviewData called');
            const formData = new FormData(document.getElementById('registrationForm'));
            const reviewDiv = document.getElementById('reviewData');
            if (!reviewDiv) {
                console.error('Review div not found');
                return;
            }
            console.log('Review div found, populating data...');
            
            let reviewHTML = '<div class="grid grid-cols-1 md:grid-cols-2 gap-6">';
            
            // Personal Information
            reviewHTML += `
                <div>
                    <h6 class="text-blue-600 font-semibold mb-3">Data Pribadi</h6>
                    <div class="space-y-2 text-sm">
                        <div><span class="font-medium">NIK:</span> ${formData.get('nik')}</div>
                        <div><span class="font-medium">Nama:</span> ${formData.get('nama')}</div>
                        <div><span class="font-medium">Tempat Lahir:</span> ${formData.get('tempat_lahir')}</div>
                        <div><span class="font-medium">Tanggal Lahir:</span> ${formData.get('tanggal_lahir')}</div>
                        <div><span class="font-medium">Jenis Kelamin:</span> ${getSelectText('jenis_kelamin')}</div>
                        <div><span class="font-medium">Agama:</span> ${getSelectText('agama')}</div>
                        <div><span class="font-medium">Status:</span> ${getSelectText('status_perkawinan')}</div>
                        <div><span class="font-medium">Kewarganegaraan:</span> ${getSelectText('kewarganegaraan')}</div>
                    </div>
                </div>
            `;
            
            // Address Information
            reviewHTML += `
                <div>
                    <h6 class="text-blue-600 font-semibold mb-3">Data Alamat</h6>
                    <div class="space-y-2 text-sm">
                        <div><span class="font-medium">Alamat:</span> ${formData.get('alamat')}</div>
                        <div><span class="font-medium">Dusun:</span> ${formData.get('dusun') || '-'}</div>
                        <div><span class="font-medium">RW:</span> ${formData.get('rw') || '-'}</div>
                        <div><span class="font-medium">RT:</span> ${formData.get('rt') || '-'}</div>
                        <div><span class="font-medium">No. KK:</span> ${formData.get('no_kk') || '-'}</div>
                        <div><span class="font-medium">WhatsApp:</span> ${formData.get('no_wa') || '-'}</div>
                    </div>
                </div>
            `;
            
            // Additional Information
            reviewHTML += `
                <div class="md:col-span-2">
                    <h6 class="text-blue-600 font-semibold mb-3">Data Tambahan</h6>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div><span class="font-medium">Pekerjaan:</span> ${formData.get('pekerjaan') || '-'}</div>
                        <div><span class="font-medium">Pendidikan:</span> ${getSelectText('pendidikan_terakhir') || '-'}</div>
                        <div><span class="font-medium">Golongan Darah:</span> ${getSelectText('golongan_darah') || '-'}</div>
                        <div><span class="font-medium">Status Hidup:</span> ${getSelectText('status_hidup') || '-'}</div>
                    </div>
                </div>
            `;

            // Data Akta Lahir
            reviewHTML += `
                <div class="md:col-span-2">
                    <h6 class="text-blue-600 font-semibold mb-3">Data Akta Lahir</h6>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div><span class="font-medium">No. Akta Lahir:</span> ${formData.get('no_akta_lahir') || '-'}</div>
                        <div><span class="font-medium">Tanggal Akta:</span> ${formData.get('tanggal_akta_lahir') || '-'}</div>
                        <div><span class="font-medium">Tempat Akta:</span> ${formData.get('tempat_akta_lahir') || '-'}</div>
                    </div>
                </div>
            `;

            // Data Orang Tua
            reviewHTML += `
                <div class="md:col-span-2">
                    <h6 class="text-blue-600 font-semibold mb-3">Data Orang Tua</h6>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div><span class="font-medium">NIK Ayah:</span> ${formData.get('ayah_nik') || '-'}</div>
                        <div><span class="font-medium">Nama Ayah:</span> ${formData.get('nama_ayah') || '-'}</div>
                        <div><span class="font-medium">NIK Ibu:</span> ${formData.get('ibu_nik') || '-'}</div>
                        <div><span class="font-medium">Nama Ibu:</span> ${formData.get('nama_ibu') || '-'}</div>
                        <div><span class="font-medium">Hubungan Keluarga:</span> ${getSelectText('hubungan_keluarga') || '-'}</div>
                    </div>
                </div>
            `;
            
            // Foto dan Lokasi
            reviewHTML += `
                <div class="md:col-span-2">
                    <h6 class="text-blue-600 font-semibold mb-3">Foto dan Lokasi</h6>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div><span class="font-medium">Foto Pribadi:</span> ${document.getElementById('fotoInput') && document.getElementById('fotoInput').files.length > 0 ? '✓ Diupload' : '-'}</div>
                        <div><span class="font-medium">Foto Rumah:</span> ${document.getElementById('fotoRumahInput') && document.getElementById('fotoRumahInput').files.length > 0 ? '✓ Diupload' : '-'}</div>
                        <div><span class="font-medium">Latitude:</span> ${formData.get('latitude') || '-'}</div>
                        <div><span class="font-medium">Longitude:</span> ${formData.get('longitude') || '-'}</div>
                    </div>
                </div>
            `;
            
            reviewHTML += '</div>';
            reviewDiv.innerHTML = reviewHTML;
            console.log('Review data populated successfully');
        }

        // Wilayah data loading
        function loadWilayahData() {
            fetch('/api/wilayah/dusun')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const dusunSelect = document.getElementById('dusun');
                        if (dusunSelect) {
                            dusunSelect.innerHTML = '<option value="">Pilih Dusun</option>';
                            
                            data.data.forEach(dusun => {
                                const option = document.createElement('option');
                                option.value = dusun.nama_wilayah;
                                option.textContent = dusun.nama_wilayah;
                                option.dataset.id = dusun.id;
                                dusunSelect.appendChild(option);
                            });
                        }
                    }
                })
                .catch(error => {
                    console.error('Error loading dusun data:', error);
                });
        }

        function loadRwData(dusunId) {
            const rwSelect = document.getElementById('rw');
            const rtSelect = document.getElementById('rt');
            
            if (rwSelect) rwSelect.innerHTML = '<option value="">Pilih RW</option>';
            if (rtSelect) rtSelect.innerHTML = '<option value="">Pilih RT</option>';
            
            if (!dusunId) return;
            
            fetch(`/api/wilayah/rw/${dusunId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success && rwSelect) {
                        data.data.forEach(rw => {
                            const option = document.createElement('option');
                            option.value = rw.nama_wilayah;
                            option.textContent = rw.nama_wilayah;
                            option.dataset.id = rw.id;
                            rwSelect.appendChild(option);
                        });
                    }
                })
                .catch(error => {
                    console.error('Error loading RW data:', error);
                });
        }

        function loadRtData(rwId) {
            const rtSelect = document.getElementById('rt');
            
            if (rtSelect) rtSelect.innerHTML = '<option value="">Pilih RT</option>';
            
            if (!rwId) return;
            
            fetch(`/api/wilayah/rt/${rwId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.success && rtSelect) {
                        data.data.forEach(rt => {
                            const option = document.createElement('option');
                            option.value = rt.nama_wilayah;
                            option.textContent = rt.nama_wilayah;
                            option.dataset.id = rt.id;
                            rtSelect.appendChild(option);
                        });
                    }
                })
                .catch(error => {
                    console.error('Error loading RT data:', error);
                });
        }

        // CSRF token refresh
        setInterval(() => {
            fetch('/csrf-token')
                .then(response => response.json())
                .then(data => {
                    const csrfMeta = document.querySelector('meta[name="csrf-token"]');
                    if (csrfMeta) {
                        csrfMeta.content = data.token;
                    }
                    const csrfInput = document.querySelector('input[name="_token"]');
                    if (csrfInput) {
                        csrfInput.value = data.token;
                    }
                })
                .catch(error => {
                    // Silent fail for CSRF refresh
                });
        }, 5 * 60 * 1000); // 5 minutes

    </script>
</body>
</html> 