<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $berita->judul }} - Portal Desa</title>
    <meta name="description" content="{{ $berita->meta_description ?? $berita->ringkasan }}">
    <meta name="keywords" content="{{ $berita->keywords ?? $berita->kategori }}">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="article">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="{{ $berita->judul }}">
    <meta property="og:description" content="{{ $berita->ringkasan }}">
    @if($berita->gambar)
    <meta property="og:image" content="{{ asset('storage/' . $berita->gambar) }}">
    @endif

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="{{ url()->current() }}">
    <meta property="twitter:title" content="{{ $berita->judul }}">
    <meta property="twitter:description" content="{{ $berita->ringkasan }}">
    @if($berita->gambar)
    <meta property="twitter:image" content="{{ asset('storage/' . $berita->gambar) }}">
    @endif

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- FontAwesome Fallback -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v6.4.0/css/all.css" crossorigin="anonymous" />
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
        }
        
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 80px 0 50px;
        }
        
        .breadcrumb {
            background: rgba(255,255,255,0.1);
            backdrop-filter: blur(10px);
            border-radius: 25px;
            padding: 10px 20px;
        }
        
        .breadcrumb-item a {
            color: rgba(255,255,255,0.8);
            text-decoration: none;
        }
        
        .breadcrumb-item.active {
            color: white;
        }
        
        .article-header {
            margin-bottom: 30px;
        }
        
        .article-meta {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 20px;
            color: rgba(255,255,255,0.9);
            font-size: 0.9rem;
        }
        
        .meta-item {
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .category-badge {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        
        .article-content {
            background: white;
            border-radius: 20px;
            margin-top: -50px;
            position: relative;
            z-index: 2;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .article-image {
            width: 100%;
            height: 400px;
            object-fit: cover;
            border-radius: 20px 20px 0 0;
        }
        
        .article-body {
            padding: 40px;
        }
        
        .article-title {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 20px;
            color: #2c3e50;
            line-height: 1.3;
        }
        
        .article-excerpt {
            font-size: 1.1rem;
            color: #7f8c8d;
            margin-bottom: 30px;
            font-style: italic;
            border-left: 4px solid #3498db;
            padding-left: 20px;
        }
        
        .article-text {
            font-size: 1.05rem;
            line-height: 1.8;
            color: #2c3e50;
        }
        
        .article-text h1, .article-text h2, .article-text h3 {
            color: #2c3e50;
            margin-top: 30px;
            margin-bottom: 15px;
        }
        
        .article-text p {
            margin-bottom: 20px;
        }
        
        .article-text img {
            max-width: 100%;
            height: auto;
            border-radius: 10px;
            margin: 20px 0;
        }
        
        .share-buttons {
            border-top: 1px solid #eee;
            padding-top: 30px;
            margin-top: 40px;
        }
        
        .btn-share {
            padding: 10px 20px;
            margin-right: 10px;
            margin-bottom: 10px;
            border-radius: 25px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .btn-facebook {
            background: #3b5998;
            color: white;
        }
        
        .btn-twitter {
            background: #1da1f2;
            color: white;
        }
        
        .btn-whatsapp {
            background: #25d366;
            color: white;
        }
        
        .btn-telegram {
            background: #0088cc;
            color: white;
        }
        
        .btn-share:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            color: white;
        }
        
        .related-news {
            margin-top: 60px;
        }
        
        .news-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
        }
        
        .news-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.15);
        }
        
        .news-card img {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }
        
        .news-card-body {
            padding: 20px;
        }
        
        .news-card-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 10px;
            color: #2c3e50;
            line-height: 1.4;
        }
        
        .news-card-excerpt {
            color: #7f8c8d;
            font-size: 0.9rem;
            margin-bottom: 15px;
        }
        
        .news-card-meta {
            font-size: 0.8rem;
            color: #95a5a6;
        }
        
        .back-button {
            background: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.3);
            padding: 10px 20px;
            border-radius: 25px;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .back-button:hover {
            background: rgba(255,255,255,0.3);
            color: white;
        }
        
        @media (max-width: 768px) {
            .hero-section {
                padding: 60px 0 30px;
            }
            
            .article-body {
                padding: 30px 20px;
            }
            
            .article-title {
                font-size: 1.8rem;
            }
            
            .article-meta {
                flex-direction: column;
                gap: 10px;
            }
        }
        
        /* FontAwesome fallback with !important for all icons */
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fab.fa-facebook-f:before, .fa.fa-facebook:before { content: "📘" !important; font-family: system-ui !important; }
        .fab.fa-twitter:before, .fa.fa-twitter:before { content: "🐦" !important; font-family: system-ui !important; }
        .fab.fa-whatsapp:before, .fa.fa-whatsapp:before { content: "💬" !important; font-family: system-ui !important; }
        .fab.fa-telegram-plane:before, .fa.fa-telegram:before { content: "✈️" !important; font-family: system-ui !important; }
        .fas.fa-calendar-alt:before, .fa.fa-calendar:before { content: "📅" !important; font-family: system-ui !important; }
        .fas.fa-user:before, .fa.fa-user:before { content: "👤" !important; font-family: system-ui !important; }
        .fas.fa-eye:before, .fa.fa-eye:before { content: "👁️" !important; font-family: system-ui !important; }
        .fas.fa-tag:before, .fa.fa-tag:before { content: "🏷️" !important; font-family: system-ui !important; }
        .fas.fa-arrow-left:before, .fa.fa-arrow-left:before { content: "⬅️" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body>
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}">Beranda</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('public.berita.index') }}">Berita</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ Str::limit($berita->judul, 50) }}</li>
                </ol>
            </nav>
            
            <!-- Article Header -->
            <div class="article-header">
                <div class="article-meta">
                    <div class="meta-item">
                        <i class="fas fa-calendar-alt"></i>
                        <span>{{ $berita->tanggal_terbit ? $berita->tanggal_terbit->format('d F Y') : $berita->created_at->format('d F Y') }}</span>
                    </div>
                    <div class="meta-item">
                        <i class="fas fa-user"></i>
                        <span>{{ $berita->user->name ?? 'Admin' }}</span>
                    </div>
                    <div class="meta-item">
                        <i class="fas fa-eye"></i>
                        <span>{{ number_format($berita->views ?? 0) }} views</span>
                    </div>
                </div>
                
                <span class="category-badge">
                    <i class="fas fa-tag"></i>
                    {{ ucfirst($berita->kategori) }}
                </span>
                
                <a href="{{ route('public.berita.index') }}" class="back-button float-end">
                    <i class="fas fa-arrow-left"></i> Kembali ke Berita
                </a>
            </div>
        </div>
    </section>

    <!-- Article Content -->
    <section class="container">
        <div class="article-content">
            @if($berita->gambar)
            <img src="{{ asset('storage/' . $berita->gambar) }}" 
                 alt="{{ $berita->alt_text ?? $berita->judul }}" 
                 class="article-image">
            @endif
            
            <div class="article-body">
                <h1 class="article-title">{{ $berita->judul }}</h1>
                
                @if($berita->ringkasan)
                <div class="article-excerpt">
                    {{ $berita->ringkasan }}
                </div>
                @endif
                
                <div class="article-text">
                    {!! $berita->konten !!}
                </div>
                
                <!-- Share Buttons -->
                <div class="share-buttons">
                    <h5 class="mb-3">Bagikan Artikel</h5>
                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" 
                       target="_blank" class="btn-share btn-facebook">
                        <i class="fab fa-facebook-f"></i> Facebook
                    </a>
                    <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($berita->judul) }}" 
                       target="_blank" class="btn-share btn-twitter">
                        <i class="fab fa-twitter"></i> Twitter
                    </a>
                    <a href="https://wa.me/?text={{ urlencode($berita->judul . ' - ' . url()->current()) }}" 
                       target="_blank" class="btn-share btn-whatsapp">
                        <i class="fab fa-whatsapp"></i> WhatsApp
                    </a>
                    <a href="https://t.me/share/url?url={{ urlencode(url()->current()) }}&text={{ urlencode($berita->judul) }}" 
                       target="_blank" class="btn-share btn-telegram">
                        <i class="fab fa-telegram-plane"></i> Telegram
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Related News -->
    @if($related && $related->count() > 0)
    <section class="container related-news">
        <h3 class="text-center mb-5">Berita Terkait</h3>
        <div class="row">
            @foreach($related as $item)
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="news-card">
                    @if($item->gambar)
                    <img src="{{ asset('storage/' . $item->gambar) }}" 
                         alt="{{ $item->alt_text ?? $item->judul }}">
                    @else
                    <div style="height: 200px; background: linear-gradient(45deg, #f8f9fa, #e9ecef); display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-newspaper fa-3x text-muted"></i>
                    </div>
                    @endif
                    
                    <div class="news-card-body">
                        <h5 class="news-card-title">
                            <a href="{{ route('public.berita.show', $item->slug) }}" class="text-decoration-none text-dark">
                                {{ Str::limit($item->judul, 60) }}
                            </a>
                        </h5>
                        @if($item->ringkasan)
                        <p class="news-card-excerpt">{{ Str::limit($item->ringkasan, 80) }}</p>
                        @endif
                        <div class="news-card-meta">
                            <i class="fas fa-calendar-alt"></i>
                            {{ $item->tanggal_terbit ? $item->tanggal_terbit->format('d M Y') : $item->created_at->format('d M Y') }}
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </section>
    @endif

    <!-- Bottom Navigation -->
    <div class="fixed-bottom d-flex justify-content-center">
        <div class="bg-white border-top shadow-lg" style="width: 100%; max-width: 448px; padding: 12px 16px; backdrop-filter: blur(10px); background: rgba(255,255,255,0.95);">
            <div class="d-flex justify-content-around align-items-center">
                <a href="/" class="text-decoration-none d-flex flex-column align-items-center" style="color: #6b7280; transition: all 0.2s;">
                    <div class="p-2 rounded-3" style="transition: background-color 0.2s;" onmouseover="this.style.backgroundColor='#eff6ff'" onmouseout="this.style.backgroundColor='transparent'">
                        <i class="fas fa-home" style="font-size: 18px;"></i>
                    </div>
                    <span style="font-size: 12px;">Beranda</span>
                </a>
                
                <a href="/berita" class="text-decoration-none d-flex flex-column align-items-center" style="color: #2563eb; transition: all 0.2s;">
                    <div class="p-2 rounded-3" style="background-color: #eff6ff;">
                        <i class="fas fa-newspaper" style="font-size: 18px;"></i>
                    </div>
                    <span style="font-size: 12px; font-weight: 600;">Berita</span>
                </a>
                
                <a href="/wisata" class="text-decoration-none d-flex flex-column align-items-center" style="color: #6b7280; transition: all 0.2s;">
                    <div class="p-2 rounded-3" style="transition: background-color 0.2s;" onmouseover="this.style.backgroundColor='#eff6ff'" onmouseout="this.style.backgroundColor='transparent'">
                        <i class="fas fa-map-marked-alt" style="font-size: 18px;"></i>
                    </div>
                    <span style="font-size: 12px;">Wisata</span>
                </a>
                
                <a href="/produk-umkm" class="text-decoration-none d-flex flex-column align-items-center" style="color: #6b7280; transition: all 0.2s;">
                    <div class="p-2 rounded-3" style="transition: background-color 0.2s;" onmouseover="this.style.backgroundColor='#eff6ff'" onmouseout="this.style.backgroundColor='transparent'">
                        <i class="fas fa-store" style="font-size: 18px;"></i>
                    </div>
                    <span style="font-size: 12px;">UMKM</span>
                </a>
                
                <a href="/layanan-mandiri" class="text-decoration-none d-flex flex-column align-items-center" style="color: #6b7280; transition: all 0.2s;">
                    <div class="p-2 rounded-3" style="transition: background-color 0.2s;" onmouseover="this.style.backgroundColor='#eff6ff'" onmouseout="this.style.backgroundColor='transparent'">
                        <i class="fas fa-user-shield" style="font-size: 18px;"></i>
                    </div>
                    <span style="font-size: 12px;">Portal</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Footer Spacing -->
    <div style="height: 100px;"></div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
        
        // Add reading progress indicator
        window.addEventListener('scroll', function() {
            const article = document.querySelector('.article-text');
            if (article) {
                const articleTop = article.offsetTop;
                const articleHeight = article.offsetHeight;
                const windowHeight = window.innerHeight;
                const scrollTop = window.scrollY;
                
                const progress = Math.min(100, Math.max(0, 
                    ((scrollTop + windowHeight - articleTop) / articleHeight) * 100
                ));
                
                // You can add a progress bar here if needed
            }
        });
        
        // Check FontAwesome loading
        document.addEventListener('DOMContentLoaded', function() {
            checkFontAwesome();
        });
        
        function checkFontAwesome() {
            setTimeout(() => {
                const testIcon = document.createElement('i');
                testIcon.className = 'fas fa-home';
                testIcon.style.visibility = 'hidden';
                testIcon.style.position = 'absolute';
                document.body.appendChild(testIcon);
                
                const computedStyle = window.getComputedStyle(testIcon, ':before');
                const content = computedStyle.getPropertyValue('content');
                
                if (content && content !== 'none' && content !== '""') {
                    console.log('✅ FontAwesome loaded successfully on detail berita');
                } else {
                    console.error('❌ FontAwesome failed to load on detail berita, adding fallback');
                    loadFontAwesomeFallback();
                }
                
                document.body.removeChild(testIcon);
            }, 1000);
        }
        
        function loadFontAwesomeFallback() {
            const link = document.createElement('link');
            link.rel = 'stylesheet';
            link.href = 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css';
            link.onerror = function() {
                console.error('❌ All FontAwesome sources failed, showing text fallback');
                showTextFallback();
            };
            document.head.appendChild(link);
        }
        
        function showTextFallback() {
            const icons = document.querySelectorAll('.fas, .fab, .fa');
            icons.forEach(icon => {
                const className = icon.className;
                let text = '●';
                
                if (className.includes('fa-home')) text = '🏠';
                else if (className.includes('fa-newspaper')) text = '📰';
                else if (className.includes('fa-map-marked-alt')) text = '🗺️';
                else if (className.includes('fa-store')) text = '🏪';
                else if (className.includes('fa-user-shield')) text = '🛡️';
                else if (className.includes('fa-facebook-f')) text = '📘';
                else if (className.includes('fa-twitter')) text = '🐦';
                else if (className.includes('fa-whatsapp')) text = '💬';
                else if (className.includes('fa-telegram-plane')) text = '✈️';
                
                icon.innerHTML = text;
                icon.style.fontFamily = 'inherit';
                icon.style.fontSize = '16px';
            });
        }
    </script>
</body>
</html> 