<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing API endpoint...\n";

// Create a simple POST request
$request = \Illuminate\Http\Request::create('/api/v1/portal/login', 'POST');
$request->headers->set('Content-Type', 'application/json');
$request->headers->set('Accept', 'application/json');

// Set JSON body
$jsonData = json_encode([
    'nik' => '1234567890123456',
    'password' => 'test123'
]);

$request->initialize(
    [], // query
    [], // request
    [], // attributes
    [], // cookies
    [], // files
    [], // server
    $jsonData
);

echo "Request created with JSON: " . $jsonData . "\n";

try {
    $response = $app->handle($request);
    echo "Response Status: " . $response->getStatusCode() . "\n";
    echo "Response Content: " . $response->getContent() . "\n";
} catch (Exception $e) {
    echo "Exception: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
}
