<?php $__env->startSection('title', 'Detail UMKM'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.umkm.index')); ?>">UMKM</a></li>
<li class="breadcrumb-item active">Detail UMKM</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-store text-primary me-2"></i>
                Detail UMKM
            </h1>
            <p class="text-muted mb-0">Informasi lengkap tentang <?php echo e($umkm->nama_umkm); ?></p>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.umkm.edit', $umkm->id)); ?>" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
            <a href="<?php echo e(route('admin.umkm.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Main Information -->
        <div class="col-lg-8">
            <!-- Basic Information Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Dasar</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Nama UMKM:</strong></td>
                                    <td><?php echo e($umkm->nama_umkm); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Kategori:</strong></td>
                                    <td>
                                        <span class="badge bg-info"><?php echo e($umkm->kategori_label); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Skala Usaha:</strong></td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo e(ucfirst($umkm->skala_usaha)); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status:</strong></td>
                                    <td><?php echo $umkm->status_badge; ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Pemilik:</strong></td>
                                    <td><?php echo e($umkm->pemilik->nama ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>NIK Pemilik:</strong></td>
                                    <td><?php echo e($umkm->pemilik->nik ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Verifikasi:</strong></td>
                                    <td>
                                        <?php if($umkm->is_verified): ?>
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle"></i> Terverifikasi
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-warning">
                                                <i class="fas fa-clock"></i> Belum Verifikasi
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Marketplace:</strong></td>
                                    <td>
                                        <?php if($umkm->aktif_marketplace): ?>
                                            <span class="badge bg-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Tidak Aktif</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <div class="mt-3">
                        <strong>Deskripsi:</strong>
                        <p class="mt-2"><?php echo e($umkm->deskripsi); ?></p>
                    </div>
                </div>
            </div>

            <!-- Contact Information Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Kontak & Lokasi</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td><strong>Alamat:</strong></td>
                                    <td><?php echo e($umkm->alamat); ?></td>
                                </tr>
                                <?php if($umkm->nomor_telepon): ?>
                                <tr>
                                    <td><strong>Telepon:</strong></td>
                                    <td>
                                        <i class="fas fa-phone text-primary me-1"></i>
                                        <?php echo e($umkm->nomor_telepon); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>
                                <?php if($umkm->whatsapp): ?>
                                <tr>
                                    <td><strong>WhatsApp:</strong></td>
                                    <td>
                                        <i class="fab fa-whatsapp text-success me-1"></i>
                                        <?php echo e($umkm->whatsapp); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <?php if($umkm->email): ?>
                                <tr>
                                    <td><strong>Email:</strong></td>
                                    <td>
                                        <i class="fas fa-envelope text-primary me-1"></i>
                                        <?php echo e($umkm->email); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>
                                <?php if($umkm->website): ?>
                                <tr>
                                    <td><strong>Website:</strong></td>
                                    <td>
                                        <i class="fas fa-globe text-primary me-1"></i>
                                        <a href="<?php echo e($umkm->website); ?>" target="_blank"><?php echo e($umkm->website); ?></a>
                                    </td>
                                </tr>
                                <?php endif; ?>
                                <?php if($umkm->latitude && $umkm->longitude): ?>
                                <tr>
                                    <td><strong>Koordinat:</strong></td>
                                    <td>
                                        <i class="fas fa-map-marker-alt text-danger me-1"></i>
                                        <?php echo e($umkm->latitude); ?>, <?php echo e($umkm->longitude); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Pengaturan</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Metode Pembayaran:</h6>
                            <ul class="list-unstyled">
                                <?php if($umkm->bisa_cod): ?>
                                    <li><i class="fas fa-check text-success me-2"></i>Cash on Delivery (COD)</li>
                                <?php endif; ?>
                                <?php if($umkm->bisa_transfer): ?>
                                    <li><i class="fas fa-check text-success me-2"></i>Transfer Bank</li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <?php if($umkm->tags && count($umkm->tags) > 0): ?>
                            <h6>Tags:</h6>
                            <div class="d-flex flex-wrap gap-1">
                                <?php $__currentLoopData = $umkm->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-light text-dark border"><?php echo e($tag); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Logo Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Logo UMKM</h6>
                </div>
                <div class="card-body text-center">
                    <?php if($umkm->logo): ?>
                        <img src="<?php echo e($umkm->logo_url); ?>" alt="Logo <?php echo e($umkm->nama_umkm); ?>" 
                             class="img-fluid rounded" style="max-height: 200px;"
                             onerror="this.src='<?php echo e(asset('images/default-umkm-logo.png')); ?>'">
                    <?php else: ?>
                        <div class="text-muted">
                            <i class="fas fa-image fa-3x mb-3"></i>
                            <p>Belum ada logo</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Statistics Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Statistik</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-primary"><?php echo e($umkm->rating_rata_rata ?? 0); ?></h4>
                                <small class="text-muted">Rating</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-success"><?php echo e($umkm->jumlah_ulasan ?? 0); ?></h4>
                            <small class="text-muted">Ulasan</small>
                        </div>
                    </div>
                    <hr>
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-info"><?php echo e($umkm->jumlah_produk ?? 0); ?></h4>
                                <small class="text-muted">Produk</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-warning"><?php echo e($umkm->jumlah_view ?? 0); ?></h4>
                            <small class="text-muted">Views</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gallery Card -->
            <?php if($umkm->galeri_foto && count($umkm->galeri_foto) > 0): ?>
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Galeri Foto</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php $__currentLoopData = $umkm->galeri_foto_urls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $fotoUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($index < 6): ?> <!-- Show max 6 photos -->
                            <div class="col-6 mb-2">
                                <img src="<?php echo e($fotoUrl); ?>" 
                                     alt="Galeri <?php echo e($index + 1); ?>" 
                                     class="img-fluid rounded" 
                                     style="height: 80px; width: 100%; object-fit: cover;"
                                     data-bs-toggle="modal" 
                                     data-bs-target="#galleryModal"
                                     onclick="showGallery(<?php echo e($index); ?>)"
                                     onerror="this.src='<?php echo e(asset('images/default-umkm-logo.png')); ?>'">
                            </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php if(count($umkm->galeri_foto) > 6): ?>
                        <div class="text-center mt-2">
                            <small class="text-muted">+<?php echo e(count($umkm->galeri_foto) - 6); ?> foto lainnya</small>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Actions Card -->
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.umkm.edit', $umkm->id)); ?>" class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i>Edit UMKM
                        </a>
                        
                        <?php if($umkm->status == 'pending_verifikasi'): ?>
                            <button type="button" class="btn btn-success" onclick="verifyUmkm(<?php echo e($umkm->id); ?>)">
                                <i class="fas fa-check me-2"></i>Verifikasi
                            </button>
                        <?php endif; ?>
                        
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="marketplaceToggle" 
                                   <?php echo e($umkm->aktif_marketplace ? 'checked' : ''); ?>

                                   onchange="toggleMarketplace(<?php echo e($umkm->id); ?>)">
                            <label class="form-check-label" for="marketplaceToggle">
                                Aktifkan Marketplace
                            </label>
                        </div>
                        
                        <button type="button" class="btn btn-danger" onclick="deleteUmkm(<?php echo e($umkm->id); ?>)">
                            <i class="fas fa-trash me-2"></i>Hapus UMKM
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Gallery Modal -->
<?php if($umkm->galeri_foto && count($umkm->galeri_foto) > 0): ?>
<div class="modal fade" id="galleryModal" tabindex="-1" aria-labelledby="galleryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="galleryModalLabel">Galeri Foto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="galleryCarousel" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        <?php $__currentLoopData = $umkm->galeri_foto_urls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $fotoUrl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="carousel-item <?php echo e($index == 0 ? 'active' : ''); ?>">
                            <img src="<?php echo e($fotoUrl); ?>" 
                                 class="d-block w-100" alt="Galeri <?php echo e($index + 1); ?>"
                                 onerror="this.src='<?php echo e(asset('images/default-umkm-logo.png')); ?>'">
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php if(count($umkm->galeri_foto) > 1): ?>
                    <button class="carousel-control-prev" type="button" data-bs-target="#galleryCarousel" data-bs-slide="prev">
                        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Previous</span>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#galleryCarousel" data-bs-slide="next">
                        <span class="carousel-control-next-icon" aria-hidden="true"></span>
                        <span class="visually-hidden">Next</span>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function showGallery(index) {
    // Set active carousel item
    const carousel = document.getElementById('galleryCarousel');
    const items = carousel.querySelectorAll('.carousel-item');
    items.forEach((item, i) => {
        item.classList.toggle('active', i === index);
    });
}

function verifyUmkm(id) {
    Swal.fire({
        title: 'Verifikasi UMKM',
        html: `
            <div class="mb-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-control" id="verify-status">
                    <option value="aktif">Aktif</option>
                    <option value="nonaktif">Non-aktif</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="catatan" class="form-label">Catatan Verifikasi</label>
                <textarea class="form-control" id="verify-catatan" rows="3"></textarea>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Verifikasi',
        cancelButtonText: 'Batal',
        preConfirm: () => {
            const status = document.getElementById('verify-status').value;
            const catatan = document.getElementById('verify-catatan').value;
            
            return { status, catatan };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/umkm/${id}/verify`,
                method: 'PUT',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    status: result.value.status,
                    catatan_verifikasi: result.value.catatan
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function(xhr) {
                    let message = 'Terjadi kesalahan!';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: message
                    });
                }
            });
        }
    });
}

function toggleMarketplace(id) {
    $.ajax({
        url: `/admin/umkm/${id}/toggle-marketplace`,
        method: 'PUT',
        data: {
            _token: '<?php echo e(csrf_token()); ?>'
        },
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.message,
                    timer: 2000,
                    showConfirmButton: false
                });
            }
        },
        error: function(xhr) {
            let message = 'Terjadi kesalahan!';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                message = xhr.responseJSON.message;
            }
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: message
            });
        }
    });
}

function deleteUmkm(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data UMKM akan dihapus permanen!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/admin/umkm/${id}`;
            form.innerHTML = `
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
            `;
            document.body.appendChild(form);
            form.submit();
        }
    });
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/admin/umkm/show.blade.php ENDPATH**/ ?>