

<?php $__env->startSection('title', 'Wilayah Administratif'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item active">Wilayah Administratif</li>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* Prevent modal backdrop issues */
.modal-backdrop {
    display: none !important;
}
body.modal-open {
    overflow: auto !important;
    padding-right: 0 !important;
}

/* Loading indicator styles */
.loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

.table-container {
    position: relative;
    min-height: 400px;
}

.fade-in {
    animation: fadeIn 0.5s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

/* Custom pagination styles */
.pagination-sm .page-link {
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
    border-radius: 0.25rem;
}

.pagination-sm .page-item:first-child .page-link,
.pagination-sm .page-item:last-child .page-link {
    border-radius: 0.25rem;
}

.pagination-sm .page-link i {
    font-size: 10px !important;
    margin: 0;
}

.pagination .page-link {
    transition: all 0.2s ease-in-out;
}

.pagination .page-link:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total Dusun</h6>
                            <h4><?php echo e($stats['total_dusun'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-map-marked-alt fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total RW</h6>
                            <h4><?php echo e($stats['total_rw'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-home fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total RT</h6>
                            <h4><?php echo e($stats['total_rt'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-building fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total KK</h6>
                            <h4><?php echo e($stats['total_kk'] ?? 0); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-users fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-map-marked-alt text-primary me-2"></i>
                        Wilayah Administratif Desa
                    </h4>
                    <div class="btn-group">
                        <a href="<?php echo e(route('admin.wilayah-administratif.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>
                            Tambah Wilayah
                        </a>
                        <button class="btn btn-info" onclick="checkRealTimeStats()">
                            <i class="fas fa-chart-bar me-1"></i>
                            Cek Data Real
                        </button>
                        <button class="btn btn-success" onclick="syncPopulation()">
                            <i class="fas fa-sync me-1"></i>
                            Sinkron Data
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-container">
                        <!-- Loading Indicator -->
                        <div id="loadingIndicator" class="loading-overlay" style="display: none;">
                            <div class="text-center">
                                <div class="spinner-border text-primary mb-3" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <h5 class="text-primary">Memuat Data Wilayah...</h5>
                                <p class="text-muted mb-0">Mohon tunggu sebentar</p>
                            </div>
                        </div>

                        <div class="table-responsive" id="tableContainer">
                            <table class="table table-striped" id="wilayahTable">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Kode</th>
                                        <th>Nama Wilayah</th>
                                        <th>Tipe</th>
                                        <th>Induk Wilayah</th>
                                        <th>Ketua</th>
                                        <th>Jumlah KK</th>
                                        <th>Jumlah Jiwa</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $wilayah ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="fade-in">
                                        <td><?php echo e(($wilayah->currentPage()-1) * $wilayah->perPage() + $index + 1); ?></td>
                                        <td><code><?php echo e($item->kode_wilayah); ?></code></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if($item->jenis_wilayah == 'rt'): ?>
                                                    <span class="me-2">└─</span>
                                                <?php elseif($item->jenis_wilayah == 'rw'): ?>
                                                    <span class="me-2">├─</span>
                                                <?php endif; ?>
                                                <strong><?php echo e($item->nama_wilayah); ?></strong>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo e($item->jenis_wilayah == 'dusun' ? 'primary' : ($item->jenis_wilayah == 'rw' ? 'success' : 'warning')); ?>">
                                                <?php echo e(strtoupper($item->jenis_wilayah)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e($item->parent->nama_wilayah ?? '-'); ?></td>
                                        <td><?php echo e($item->kepala_wilayah ?? '-'); ?></td>
                                        <td>
                                            <span class="badge bg-info"><?php echo e(number_format($item->jumlah_kk ?? 0)); ?></span>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary"><?php echo e(number_format($item->jumlah_penduduk ?? 0)); ?></span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <button class="btn btn-sm btn-info" onclick="showDetail(<?php echo e($item->id); ?>)" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <button class="btn btn-sm btn-warning" onclick="editWilayah(<?php echo e($item->id); ?>)" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button class="btn btn-sm btn-success" onclick="updateStats(<?php echo e($item->id); ?>)" title="Update Statistik">
                                                    <i class="fas fa-calculator"></i>
                                                </button>
                                                <button class="btn btn-sm btn-danger" onclick="deleteWilayah(<?php echo e($item->id); ?>)" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9" class="text-center py-4">
                                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">Belum ada data wilayah administratif</h5>
                                            <p class="text-muted">Klik tombol "Tambah Wilayah" untuk menambahkan data pertama</p>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <?php if($wilayah->hasPages()): ?>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Menampilkan <?php echo e($wilayah->firstItem()); ?> sampai <?php echo e($wilayah->lastItem()); ?> 
                                dari <?php echo e($wilayah->total()); ?> data
                            </div>
                            <div>
                                <!-- Custom Bootstrap Pagination -->
                                <nav aria-label="Pagination Navigation">
                                    <ul class="pagination pagination-sm mb-0">
                                        
                                        <?php if($wilayah->onFirstPage()): ?>
                                            <li class="page-item disabled">
                                                <span class="page-link">
                                                    <i class="fas fa-chevron-left" style="font-size: 12px;"></i>
                                                    <span class="sr-only">Previous</span>
                                                </span>
                                            </li>
                                        <?php else: ?>
                                            <li class="page-item">
                                                <a class="page-link" href="<?php echo e($wilayah->previousPageUrl()); ?>" rel="prev">
                                                    <i class="fas fa-chevron-left" style="font-size: 12px;"></i>
                                                    <span class="sr-only">Previous</span>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        
                                        <?php
                                            $currentPage = $wilayah->currentPage();
                                            $lastPage = $wilayah->lastPage();
                                            $start = max(1, $currentPage - 2);
                                            $end = min($lastPage, $currentPage + 2);
                                            
                                            // Ensure we always show 5 pages if possible
                                            if ($end - $start < 4) {
                                                if ($start == 1) {
                                                    $end = min($lastPage, 5);
                                                } else {
                                                    $start = max(1, $lastPage - 4);
                                                }
                                            }
                                        ?>

                                        
                                        <?php if($start > 1): ?>
                                            <li class="page-item">
                                                <a class="page-link" href="<?php echo e($wilayah->url(1)); ?>">1</a>
                                            </li>
                                            <?php if($start > 2): ?>
                                                <li class="page-item disabled">
                                                    <span class="page-link">...</span>
                                                </li>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        
                                        <?php for($page = $start; $page <= $end; $page++): ?>
                                            <?php if($page == $currentPage): ?>
                                                <li class="page-item active">
                                                    <span class="page-link"><?php echo e($page); ?></span>
                                                </li>
                                            <?php else: ?>
                                                <li class="page-item">
                                                    <a class="page-link" href="<?php echo e($wilayah->url($page)); ?>"><?php echo e($page); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endfor; ?>

                                        
                                        <?php if($end < $lastPage): ?>
                                            <?php if($end < $lastPage - 1): ?>
                                                <li class="page-item disabled">
                                                    <span class="page-link">...</span>
                                                </li>
                                            <?php endif; ?>
                                            <li class="page-item">
                                                <a class="page-link" href="<?php echo e($wilayah->url($lastPage)); ?>"><?php echo e($lastPage); ?></a>
                                            </li>
                                        <?php endif; ?>

                                        
                                        <?php if($wilayah->hasMorePages()): ?>
                                            <li class="page-item">
                                                <a class="page-link" href="<?php echo e($wilayah->nextPageUrl()); ?>" rel="next">
                                                    <i class="fas fa-chevron-right" style="font-size: 12px;"></i>
                                                    <span class="sr-only">Next</span>
                                                </a>
                                            </li>
                                        <?php else: ?>
                                            <li class="page-item disabled">
                                                <span class="page-link">
                                                    <i class="fas fa-chevron-right" style="font-size: 12px;"></i>
                                                    <span class="sr-only">Next</span>
                                                </span>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Loading management functions
function showLoading() {
    document.getElementById('loadingIndicator').style.display = 'flex';
    document.getElementById('tableContainer').style.opacity = '0.5';
}

function hideLoading() {
    document.getElementById('loadingIndicator').style.display = 'none';
    document.getElementById('tableContainer').style.opacity = '1';
}

// Clean up any lingering modal states on page load
document.addEventListener('DOMContentLoaded', function() {
    // Remove any modal backdrops
    const backdrops = document.querySelectorAll('.modal-backdrop');
    backdrops.forEach(backdrop => backdrop.remove());
    
    // Remove modal-open class from body
    document.body.classList.remove('modal-open');
    
    // Reset body styles
    document.body.style.overflow = '';
    document.body.style.paddingRight = '';
    
    // Hide loading after page is ready
    setTimeout(hideLoading, 100);
    
    // Add loading to pagination links
    document.querySelectorAll('.pagination .page-link').forEach(link => {
        if (link.href) { // Only add to actual links, not disabled spans
            link.addEventListener('click', function(e) {
                showLoading();
            });
        }
    });
});

// Check real-time statistics
function checkRealTimeStats() {
    showLoading();
    
    fetch('<?php echo e(route("admin.wilayah-administratif.statistik")); ?>', {
        method: 'GET',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        hideLoading();
        if (data.success) {
            const realtime = data.data.realtime;
            
            let message = '<div class="text-start">';
            message += '<h6><i class="fas fa-chart-line text-info"></i> Statistik Real-Time:</h6>';
            message += `<p><strong>Total KK (Real):</strong> ${realtime.total_kk_real.toLocaleString()}<br>`;
            message += `<strong>Total Penduduk (Real):</strong> ${realtime.total_penduduk_real.toLocaleString()}</p>`;
            
            message += '<h6><i class="fas fa-database text-warning"></i> Data Tersimpan:</h6>';
            message += `<p><strong>Total KK (Tersimpan):</strong> ${realtime.total_kk_wilayah.toLocaleString()}<br>`;
            message += `<strong>Total Penduduk (Tersimpan):</strong> ${realtime.total_penduduk_wilayah.toLocaleString()}</p>`;
            
            if (realtime.selisih_kk !== 0 || realtime.selisih_penduduk !== 0) {
                message += '<h6><i class="fas fa-exclamation-triangle text-danger"></i> Selisih:</h6>';
                message += `<p><strong>Selisih KK:</strong> ${realtime.selisih_kk > 0 ? '+' : ''}${realtime.selisih_kk}<br>`;
                message += `<strong>Selisih Penduduk:</strong> ${realtime.selisih_penduduk > 0 ? '+' : ''}${realtime.selisih_penduduk}</p>`;
                message += '<p class="text-warning"><small>💡 Klik "Sinkron Data" untuk memperbarui statistik</small></p>';
            } else {
                message += '<p class="text-success"><i class="fas fa-check-circle"></i> Data sudah sinkron!</p>';
            }
            message += '</div>';
            
            Swal.fire({
                title: 'Statistik Real-Time vs Tersimpan',
                html: message,
                icon: 'info',
                width: '500px',
                confirmButtonText: 'Tutup'
            });
        } else {
            Swal.fire('Error!', data.message, 'error');
        }
    })
    .catch(error => {
        hideLoading();
        console.error('Stats error:', error);
        Swal.fire('Error!', 'Terjadi kesalahan saat mengambil statistik', 'error');
    });
}

// Enhanced sync population data with loading
function syncPopulation() {
    if (confirm('Apakah Anda yakin ingin menyinkronkan data penduduk dengan wilayah administratif?')) {
        showLoading();
        
        fetch('<?php echo e(route("admin.wilayah-administratif.sync")); ?>', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: data.message,
                    timer: 3000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            } else {
                Swal.fire('Error!', data.message, 'error');
            }
        })
        .catch(error => {
            hideLoading();
            console.error('Sync error:', error);
            Swal.fire('Error!', 'Terjadi kesalahan saat sinkronisasi', 'error');
        });
    }
}

// Update statistics for specific wilayah with loading
function updateStats(id) {
    if (confirm('Update statistik penduduk untuk wilayah ini?')) {
        showLoading();
        
        fetch(`/admin/wilayah-administratif/${id}/update-statistik`, {
            method: 'PUT',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Berhasil!',
                    text: data.message,
                    timer: 2000,
                    showConfirmButton: false
                }).then(() => {
                    location.reload();
                });
            } else {
                Swal.fire('Error!', data.message, 'error');
            }
        })
        .catch(error => {
            hideLoading();
            console.error('Update stats error:', error);
            Swal.fire('Error!', 'Terjadi kesalahan saat update statistik', 'error');
        });
    }
}

// Edit wilayah
function editWilayah(id) {
    window.location.href = `/admin/wilayah-administratif/${id}/edit`;
}

// Delete wilayah
function deleteWilayah(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data wilayah akan dihapus permanen!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`/admin/wilayah-administratif/${id}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('Terhapus!', data.message, 'success');
                    location.reload();
                } else {
                    Swal.fire('Error!', data.message, 'error');
                }
            })
            .catch(error => {
                Swal.fire('Error!', 'Terjadi kesalahan saat menghapus data', 'error');
            });
        }
    });
}

// Show detail
function showDetail(id) {
    // Redirect ke halaman detail view
    window.location.href = `/admin/wilayah-administratif/${id}`;
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/admin/wilayah-administratif/index.blade.php ENDPATH**/ ?>