<?php
require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Helpers\SharedHostingHelper;
use App\Models\Umkm;
use App\Models\ProdukUmkm;

echo "=== Final UMKM Helper Test ===\n\n";

try {
    // Test 1: Helper functions
    echo "1. Testing SharedHostingHelper functions:\n";
    
    $defaultLogo = SharedHostingHelper::getUmkmLogoUrl(null);
    echo "   Default Logo URL: $defaultLogo\n";
    
    $sampleLogo = SharedHostingHelper::getUmkmLogoUrl('sample-logo.png');
    echo "   Sample Logo URL: $sampleLogo\n";
    
    $problematicFilename = '1757789644_logo_Putih%20Biru%20Modern%20Memperingati%20Maulid%20Nabi%20Muhammad%20Instagram%20Post.png';
    $problematicUrl = SharedHostingHelper::getUmkmLogoUrl($problematicFilename);
    echo "   Problematic Filename URL: $problematicUrl\n";
    
    $symlinkWorking = SharedHostingHelper::isStorageSymlinkWorking();
    echo "   Storage Symlink Working: " . ($symlinkWorking ? 'YES' : 'NO') . "\n";
    
    echo "\n2. Testing Model accessors:\n";
    
    // Test UMKM model
    $umkm = new Umkm();
    $umkm->logo = 'sample-logo.png';
    $umkm->galeri_foto = ['sample-gallery1.png', 'sample-gallery2.png'];
    
    echo "   UMKM Logo URL: " . $umkm->logo_url . "\n";
    echo "   UMKM Gallery URLs: " . implode(', ', $umkm->galeri_foto_urls) . "\n";
    
    // Test ProdukUmkm model
    $produk = new ProdukUmkm();
    $produk->foto_utama = 'sample-product.jpg';
    
    echo "   Product Photo URL: " . $produk->foto_utama_url . "\n";
    
    echo "\n✅ All tests passed successfully!\n";
    echo "UMKM photo system is ready for shared hosting!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
?>
