<?php
require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

// Test SharedHostingHelper
use App\Helpers\SharedHostingHelper;

echo "Testing SharedHostingHelper...\n";

// Test 1: Default logo URL
$defaultLogo = SharedHostingHelper::getUmkmLogoUrl(null);
echo "Default Logo URL: $defaultLogo\n";

// Test 2: Sample logo URL
$sampleLogo = SharedHostingHelper::getUmkmLogoUrl('sample-logo.png');
echo "Sample Logo URL: $sampleLogo\n";

// Test 3: Sample gallery URL
$sampleGallery = SharedHostingHelper::getUmkmGalleryUrl('sample-gallery1.png');
echo "Sample Gallery URL: $sampleGallery\n";

// Test 4: Check if storage symlink is working
$symlinkWorking = SharedHostingHelper::isStorageSymlinkWorking();
echo "Storage Symlink Working: " . ($symlinkWorking ? 'YES' : 'NO') . "\n";

echo "✅ Helper test completed successfully!\n";
?>
