<?php

require_once 'vendor/autoload.php';

use Gregwar\Captcha\CaptchaBuilder;

try {
    echo "Testing CAPTCHA Builder...\n";
    
    $builder = new CaptchaBuilder();
    $builder->build();
    
    echo "CAPTCHA phrase: " . $builder->getPhrase() . "\n";
    echo "CAPTCHA built successfully!\n";
    
    // Test getting image data
    $imageData = $builder->get();
    echo "Image data length: " . strlen($imageData) . " bytes\n";
    
    echo "CAPTCHA test PASSED!\n";
    
} catch (Exception $e) {
    echo "CAPTCHA test FAILED: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
