<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Testing Portal Login API...\n";
    
    // Test database connection
    echo "1. Testing database connection...\n";
    $penduduk = \App\Models\Penduduk::first();
    echo "   Database connection: " . ($penduduk ? "OK" : "No data") . "\n";
    
    if ($penduduk) {
        echo "   Sample NIK: " . $penduduk->nik . "\n";
        echo "   Sample Name: " . $penduduk->nama . "\n";
        
        // Test password methods
        echo "2. Testing password methods...\n";
        echo "   hasPassword(): " . ($penduduk->hasPassword() ? "Yes" : "No") . "\n";
        echo "   mustChangePassword(): " . ($penduduk->mustChangePassword() ? "Yes" : "No") . "\n";
        
        // Test if password column exists
        echo "3. Testing password column...\n";
        $columns = \Illuminate\Support\Facades\Schema::getColumnListing('penduduk');
        echo "   Password column exists: " . (in_array('password', $columns) ? "Yes" : "No") . "\n";
        
        if (in_array('password', $columns)) {
            echo "   Password value: " . ($penduduk->password ? "Set" : "Not set") . "\n";
        }
    }
    
    echo "4. Testing API endpoint...\n";
    $request = \Illuminate\Http\Request::create('/api/v1/portal/login', 'POST', [
        'nik' => '1234567890123456',
        'password' => 'test123'
    ]);
    
    $request->headers->set('Content-Type', 'application/json');
    $request->headers->set('Accept', 'application/json');
    
    $response = $app->handle($request);
    echo "   API Response Status: " . $response->getStatusCode() . "\n";
    
    if ($response->getStatusCode() === 500) {
        echo "   ERROR: HTTP 500 detected!\n";
        echo "   Response: " . $response->getContent() . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}
