<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    echo "Testing Portal Login API with detailed error handling...\n";
    
    // Test with valid NIK from database
    $penduduk = \App\Models\Penduduk::first();
    if (!$penduduk) {
        echo "ERROR: No penduduk data found in database\n";
        exit(1);
    }
    
    echo "Testing with NIK: " . $penduduk->nik . "\n";
    echo "Testing with Name: " . $penduduk->nama . "\n";
    
    // Test 1: Valid NIK, wrong password
    echo "\n1. Testing with valid NIK but wrong password...\n";
    $request = \Illuminate\Http\Request::create('/api/v1/portal/login', 'POST');
    $request->headers->set('Content-Type', 'application/json');
    $request->headers->set('Accept', 'application/json');
    
    // Set JSON content
    $request->initialize(
        [], // query
        [], // request
        [], // attributes
        [], // cookies
        [], // files
        [], // server
        json_encode([
            'nik' => $penduduk->nik,
            'password' => 'wrongpassword123'
        ])
    );
    
    $response = $app->handle($request);
    echo "   Status: " . $response->getStatusCode() . "\n";
    echo "   Response: " . $response->getContent() . "\n";
    
    // Test 2: Invalid NIK
    echo "\n2. Testing with invalid NIK...\n";
    $request = \Illuminate\Http\Request::create('/api/v1/portal/login', 'POST');
    $request->headers->set('Content-Type', 'application/json');
    $request->headers->set('Accept', 'application/json');
    
    $request->initialize(
        [], [], [], [], [], [],
        json_encode([
            'nik' => '1234567890123456',
            'password' => 'test123'
        ])
    );
    
    $response = $app->handle($request);
    echo "   Status: " . $response->getStatusCode() . "\n";
    echo "   Response: " . $response->getContent() . "\n";
    
    // Test 3: Missing password
    echo "\n3. Testing with missing password...\n";
    $request = \Illuminate\Http\Request::create('/api/v1/portal/login', 'POST');
    $request->headers->set('Content-Type', 'application/json');
    $request->headers->set('Accept', 'application/json');
    
    $request->initialize(
        [], [], [], [], [], [],
        json_encode([
            'nik' => $penduduk->nik
        ])
    );
    
    $response = $app->handle($request);
    echo "   Status: " . $response->getStatusCode() . "\n";
    echo "   Response: " . $response->getContent() . "\n";
    
    // Test 4: Test with correct password if available
    if ($penduduk->hasPassword()) {
        echo "\n4. Testing with correct password...\n";
        // Try with default password (last 6 digits of NIK)
        $defaultPassword = substr($penduduk->nik, -6);
        echo "   Trying default password: " . $defaultPassword . "\n";
        
        $request = \Illuminate\Http\Request::create('/api/v1/portal/login', 'POST');
        $request->headers->set('Content-Type', 'application/json');
        $request->headers->set('Accept', 'application/json');
        
        $request->initialize(
            [], [], [], [], [], [],
            json_encode([
                'nik' => $penduduk->nik,
                'password' => $defaultPassword
            ])
        );
        
        $response = $app->handle($request);
        echo "   Status: " . $response->getStatusCode() . "\n";
        echo "   Response: " . $response->getContent() . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
    echo "Trace: " . $e->getTraceAsString() . "\n";
}
