<?php
// Test file untuk debugging wilayah administratif
// Letakkan file ini di root project dan akses via browser

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\WilayahAdministratif;
use Illuminate\Support\Facades\DB;

echo "<h1>Test Wilayah Administratif</h1>";

try {
    echo "<h2>1. Test Database Connection</h2>";
    $connection = DB::connection()->getPdo();
    echo "✅ Database connected successfully<br>";
    echo "Database: " . DB::connection()->getDatabaseName() . "<br><br>";

    echo "<h2>2. Test Wilayah Model</h2>";
    $totalWilayah = WilayahAdministratif::count();
    echo "✅ Total wilayah: " . $totalWilayah . "<br><br>";

    if ($totalWilayah > 0) {
        echo "<h2>3. Sample Data</h2>";
        $sampleWilayah = WilayahAdministratif::first();
        echo "✅ Sample wilayah: " . $sampleWilayah->nama_wilayah . " (ID: " . $sampleWilayah->id . ")<br>";
        echo "Jenis: " . $sampleWilayah->jenis_wilayah . "<br>";
        echo "Status: " . $sampleWilayah->status . "<br><br>";

        echo "<h2>4. Test Relationships</h2>";
        $childrenCount = $sampleWilayah->children()->count();
        echo "✅ Children count: " . $childrenCount . "<br>";
        
        if ($sampleWilayah->parent) {
            echo "✅ Parent: " . $sampleWilayah->parent->nama_wilayah . "<br>";
        } else {
            echo "ℹ️ No parent (root level)<br>";
        }
        echo "<br>";

        echo "<h2>5. Test Penduduk Check</h2>";
        $pendudukCount = DB::table('penduduk')
            ->where('dusun', $sampleWilayah->nama_wilayah)
            ->orWhere('rt', $sampleWilayah->nama_wilayah)
            ->orWhere('rw', $sampleWilayah->nama_wilayah)
            ->count();
        echo "✅ Penduduk count: " . $pendudukCount . "<br><br>";

        echo "<h2>6. Test Delete Validation</h2>";
        if ($childrenCount > 0) {
            echo "⚠️ Cannot delete - has children<br>";
        } elseif ($pendudukCount > 0) {
            echo "⚠️ Cannot delete - has penduduk data<br>";
        } else {
            echo "✅ Can be deleted safely<br>";
        }
        echo "<br>";

    } else {
        echo "ℹ️ No wilayah data found<br><br>";
    }

    echo "<h2>7. Test Routes</h2>";
    echo "✅ Index route: /admin/wilayah-administratif<br>";
    echo "✅ Show route: /admin/wilayah-administratif/{id}<br>";
    echo "✅ Delete route: DELETE /admin/wilayah-administratif/{id}<br><br>";

    echo "<h2>8. Test View Files</h2>";
    $viewPath = 'resources/views/admin/wilayah-administratif/show.blade.php';
    if (file_exists($viewPath)) {
        echo "✅ Show view exists: " . $viewPath . "<br>";
    } else {
        echo "❌ Show view missing: " . $viewPath . "<br>";
    }
    echo "<br>";

} catch (Exception $e) {
    echo "<h2>❌ Error</h2>";
    echo "Error: " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . "<br>";
    echo "Line: " . $e->getLine() . "<br>";
    echo "Trace: <pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<hr>";
echo "<h3>Manual Test Links</h3>";
echo "<a href='/admin/wilayah-administratif' target='_blank'>Test Index Page</a><br>";
if (isset($sampleWilayah)) {
    echo "<a href='/admin/wilayah-administratif/{$sampleWilayah->id}' target='_blank'>Test Show Page</a><br>";
    echo "<a href='/admin/wilayah-administratif/{$sampleWilayah->id}/edit' target='_blank'>Test Edit Page</a><br>";
}
echo "<br><strong>Note:</strong> Pastikan sudah login sebagai admin untuk mengakses halaman tersebut.";
?>
